/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.client.render;

import lombok.Generated;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.ColorHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector2;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector3;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector4;

public class ColorCache {
    private final int colorI;
    private final Vector4 colorVF;
    private final Vector4 colorVI;

    public static ColorCache grayscale(float gray) {
        return ColorCache.of(new Vector4(Float.valueOf(gray), Float.valueOf(gray), Float.valueOf(gray), Float.valueOf(1.0f)));
    }

    public static ColorCache grayscale(float gray, float alpha) {
        return ColorCache.of(new Vector4(Float.valueOf(gray), Float.valueOf(gray), Float.valueOf(gray), Float.valueOf(alpha)));
    }

    public static ColorCache grayscale(Vector2 gray) {
        return ColorCache.of(new Vector4(Float.valueOf(gray.fX()), Float.valueOf(gray.fX()), Float.valueOf(gray.fX()), Float.valueOf(gray.fY())));
    }

    public static ColorCache grayscale(int gray) {
        return ColorCache.ofI(new Vector4(gray, gray, gray, 255));
    }

    public static ColorCache grayscale(int gray, int a) {
        return ColorCache.ofI(new Vector4(gray, gray, gray, a));
    }

    public static ColorCache of(float r, float g, float b) {
        return ColorCache.of(new Vector4(Float.valueOf(r), Float.valueOf(g), Float.valueOf(b), Float.valueOf(1.0f)));
    }

    public static ColorCache of(float r, float g, float b, float a) {
        return ColorCache.of(new Vector4(Float.valueOf(r), Float.valueOf(g), Float.valueOf(b), Float.valueOf(a)));
    }

    public static ColorCache of(Vector3 colorVF) {
        return ColorCache.of(new Vector4(Float.valueOf(colorVF.fX()), Float.valueOf(colorVF.fY()), Float.valueOf(colorVF.fZ()), Float.valueOf(1.0f)));
    }

    public static ColorCache of(Vector3 colorVF, float alpha) {
        return ColorCache.of(new Vector4(Float.valueOf(colorVF.fX()), Float.valueOf(colorVF.fY()), Float.valueOf(colorVF.fZ()), Float.valueOf(alpha)));
    }

    public static ColorCache of(Vector4 colorVF, float alpha) {
        return ColorCache.of(new Vector4(Float.valueOf(colorVF.fX()), Float.valueOf(colorVF.fY()), Float.valueOf(colorVF.fZ()), Float.valueOf(alpha)));
    }

    public static ColorCache of(Vector4 colorVF) {
        return new ColorCache(colorVF);
    }

    public static ColorCache of(int r, int g, int b) {
        return ColorCache.ofI(new Vector4(r, g, b, 255));
    }

    public static ColorCache of(int r, int g, int b, float a) {
        return ColorCache.ofI(new Vector4(r, g, b, (int)(255.0f * a)));
    }

    public static ColorCache of(int r, int g, int b, int a) {
        return ColorCache.ofI(new Vector4(r, g, b, a));
    }

    public static ColorCache ofI(Vector4 colorVI) {
        return new ColorCache(ColorHelper.convertI(colorVI));
    }

    public ColorCache(Vector4 colorVF) {
        this(colorVF, ColorHelper.convertF(colorVF));
    }

    protected ColorCache(Vector4 colorVF, Vector4 colorVI) {
        this.colorVF = colorVF;
        this.colorVI = colorVI;
        this.colorI = ColorHelper.makeARGBIntI(this.colorVI);
    }

    public boolean equals(Object other) {
        return other instanceof ColorCache && this.colorI == ((ColorCache)other).colorI;
    }

    public int getIntWithAlpha(float alpha) {
        return ColorHelper.makeARGBInt(this.colorVF.fX(), this.colorVF.fY(), this.colorVF.fZ(), alpha);
    }

    public int getIntWithAlpha(int alpha) {
        return ColorHelper.makeARGBInt(this.colorVI.iX(), this.colorVI.iY(), this.colorVI.iZ(), alpha);
    }

    public Vector4 getVFWithAlpha(float alpha) {
        return new Vector4(Float.valueOf(this.colorVF.fX()), Float.valueOf(this.colorVF.fY()), Float.valueOf(this.colorVF.fZ()), Float.valueOf(alpha));
    }

    public Vector4 getVFWithAlpha(int alpha) {
        return new Vector4(Float.valueOf(this.colorVF.fX()), Float.valueOf(this.colorVF.fY()), Float.valueOf(this.colorVF.fZ()), Float.valueOf((float)alpha / 255.0f));
    }

    public Vector4 getVIWithAlpha(float alpha) {
        return new Vector4(this.colorVI.iX(), this.colorVI.iY(), this.colorVI.iZ(), (int)(alpha * 255.0f));
    }

    public Vector4 getVIWithAlpha(int alpha) {
        return new Vector4(this.colorVI.iX(), this.colorVI.iY(), this.colorVI.iZ(), alpha);
    }

    public float r() {
        return this.colorVF.fX();
    }

    public float g() {
        return this.colorVF.fY();
    }

    public float b() {
        return this.colorVF.fZ();
    }

    public float a() {
        return this.colorVF.fW();
    }

    public ColorCache withAlpha(int alpha) {
        return ColorCache.of(this.colorVI.iX(), this.colorVI.iY(), this.colorVI.iZ(), alpha);
    }

    public ColorCache withAlpha(float alpha) {
        return ColorCache.of(this.colorVF.fX(), this.colorVF.fY(), this.colorVF.fZ(), alpha);
    }

    @Generated
    public int getColorI() {
        return this.colorI;
    }

    @Generated
    public Vector4 getColorVF() {
        return this.colorVF;
    }

    @Generated
    public Vector4 getColorVI() {
        return this.colorVI;
    }
}

