/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.client.render;

import java.util.Collection;
import lombok.Generated;
import mods.thecomputerizer.theimpossiblelibrary.api.client.font.FontAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.ColorCache;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.GLAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.TextBuffer;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.VertexWrapper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.resource.ResourceLocationAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector4;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextAPI;

public abstract class RenderAPI {
    protected final GLAPI gl;
    protected int mouseX;
    protected int mouseY;
    protected Object matrix;
    protected Object font;

    protected RenderAPI(GLAPI gl) {
        this.gl = gl;
    }

    @IndirectCallers
    public abstract void alphaFuncEqual(float var1);

    public abstract void alphaFuncGreater(float var1);

    @IndirectCallers
    public abstract void alphaFuncLesser(float var1);

    public abstract Object beginBuffer(Object var1, int var2, Object var3);

    public abstract void bindTexture(ResourceLocationAPI<?> var1);

    public abstract void blendTranslucent();

    public abstract void defaultBlendFunc();

    public abstract void depthMask(boolean var1);

    @IndirectCallers
    public abstract void disableAlpha();

    public abstract void disableBlend();

    public abstract void disableCull();

    public abstract void disableLighting();

    public abstract void disableTexture();

    @IndirectCallers
    public void drawCenteredString(FontAPI<?> font, TextBuffer text, Number x, Number y) {
        this.drawCenteredString(font, text.getText().getApplied(), x, y, text.getColor().getColorI());
    }

    @IndirectCallers
    public void drawCenteredString(FontAPI<?> font, TextAPI<?> text, Number x, Number y, ColorCache color) {
        this.drawCenteredString(font, text.getApplied(), x, y, color.getColorI());
    }

    public abstract void drawCenteredString(FontAPI<?> var1, String var2, Number var3, Number var4, int var5);

    @IndirectCallers
    public void drawString(FontAPI<?> font, TextBuffer text, Number left, Number top) {
        this.drawString(font, text.getText().getApplied(), left, top, text.getColor().getColorI());
    }

    @IndirectCallers
    public void drawString(FontAPI<?> font, TextAPI<?> text, Number left, Number top, ColorCache color) {
        this.drawString(font, text.getApplied(), left, top, color.getColorI());
    }

    public abstract void drawString(FontAPI<?> var1, String var2, Number var3, Number var4, int var5);

    public abstract void drawTooltip(FontAPI<?> var1, Collection<TextAPI<?>> var2, Number var3, Number var4, Number var5, Number var6, Number var7);

    public abstract void enableAlpha();

    public abstract void enableBlend();

    public abstract void enableCull();

    public abstract void enableLighting();

    public abstract void enableTexture();

    public void endBatch(Object source) {
        TILRef.getClientHandles().endRenderTypeBatch(source);
    }

    @IndirectCallers
    public void endBatch(Object source, Object type) {
        TILRef.getClientHandles().endRenderTypeBatch(source, type);
    }

    public abstract void endBuffer();

    public abstract void endVertex(Object var1);

    public abstract <B> B getBufferBuilder();

    public abstract VertexWrapper getBufferBuilderPC(int var1, int var2);

    public abstract VertexWrapper getBufferBuilderPTC(int var1, int var2);

    public abstract double getDirectMouseX();

    public abstract double getDirectMouseY();

    public abstract GLAPI getGLAPI();

    public abstract RenderAPI init(Object var1);

    @IndirectCallers
    public abstract void modelView();

    public abstract void popMatrix();

    public abstract void pushMatrix();

    public abstract Object renderSourceImmediate();

    @IndirectCallers
    public abstract void resetTextureMatrix();

    public abstract void rotate(float var1, float var2, float var3, float var4);

    public abstract void scale(float var1, float var2, float var3);

    public void setColor(ColorCache color) {
        Vector4 colorVec = color.getColorVF();
        this.setColor(colorVec.fX(), colorVec.fY(), colorVec.fZ(), colorVec.fW());
    }

    public abstract void setColor(float var1, float var2, float var3, float var4);

    @IndirectCallers
    public abstract void setPosColorShader();

    @IndirectCallers
    public void shadeFlat() {
    }

    @IndirectCallers
    public void shadeSmooth() {
    }

    public abstract void translate(double var1, double var3, double var5);

    public abstract void translate(float var1, float var2, float var3);

    @IndirectCallers
    public <F> F unwrapFont() {
        return (F)this.font;
    }

    @IndirectCallers
    public <M> M unwrapMatrix() {
        return (M)this.matrix;
    }

    public abstract <B> B vertexWithMatrix(B var1, Object var2, float var3, float var4, float var5);

    public abstract <B> B vertexColor(B var1, float var2, float var3, float var4, float var5);

    @Generated
    public GLAPI getGl() {
        return this.gl;
    }

    @Generated
    public int getMouseX() {
        return this.mouseX;
    }

    @Generated
    public int getMouseY() {
        return this.mouseY;
    }

    @Generated
    public Object getMatrix() {
        return this.matrix;
    }

    @Generated
    public Object getFont() {
        return this.font;
    }

    @Generated
    public void setMouseX(int mouseX) {
        this.mouseX = mouseX;
    }

    @Generated
    public void setMouseY(int mouseY) {
        this.mouseY = mouseY;
    }

    @Generated
    public void setMatrix(Object matrix) {
        this.matrix = matrix;
    }

    @Generated
    public void setFont(Object font) {
        this.font = font;
    }
}

