/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.client.render;

import java.io.IOException;
import java.util.Map;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.ShapeWidget;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderContext;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.Renderable;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.TextureWrapper;
import mods.thecomputerizer.theimpossiblelibrary.api.common.block.Facing;
import mods.thecomputerizer.theimpossiblelibrary.api.parameter.Parameter;
import mods.thecomputerizer.theimpossiblelibrary.api.resource.ResourceLocationAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.ShapeHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.VectorHelper;

public class RenderablePNG
extends Renderable {
    protected final ShapeWidget texture;

    public RenderablePNG(ResourceLocationAPI<?> source, Map<String, Parameter<?>> parameters) throws IOException {
        super(parameters);
        if (!source.getPath().endsWith(".png")) {
            throw new IOException("Tried to initialize a non png file to a png object! Make sure that you have the correct file extension on your resource location. [" + source + "]");
        }
        this.texture = ShapeWidget.from(ShapeHelper.plane(Facing.Axis.Y));
        this.texture.setTexture(new TextureWrapper().setTexture(source).setU(0.0, 1.0).setV(0.0, 1.0));
    }

    @Override
    public void pos(RenderContext ctx) {
        this.texture.setX(this.getAllignmentX() + this.getParameterAsDouble("x", 0.0));
        this.texture.setY(this.getAllignmentY() + this.getParameterAsDouble("y", 0.0));
    }

    protected void postRender(RenderAPI renderer) {
        renderer.popMatrix();
    }

    protected void preRender(RenderContext ctx, float alpha) {
        ctx.getRenderer().pushMatrix();
        this.texture.getWrapped().getTexture().setAlpha(alpha);
        this.pos(ctx);
        this.scale(ctx);
    }

    @Override
    void render(RenderContext ctx) {
        if (this.canRender()) {
            this.preRender(ctx, Math.max(0.1f, this.getOpacity()));
            this.texture.draw(ctx, VectorHelper.zero3D(), 0.0, 0.0);
            this.postRender(ctx.getRenderer());
        }
    }
}

