/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.common;

import java.util.Objects;
import java.util.function.Consumer;
import mods.thecomputerizer.theimpossiblelibrary.api.client.ClientEntryPoint;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreStateAccessor;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import org.jetbrains.annotations.Nullable;

public abstract class CommonEntryPoint
implements CoreStateAccessor {
    protected final ClientEntryPoint delegatedClientHandle;
    protected final CommonEntryPoint delegatedCustomHandle;
    protected final CommonEntryPoint delegatedServerHandle;
    protected CommonEntryPoint parent;
    protected Object extraData;

    protected CommonEntryPoint() {
        this(true);
    }

    protected CommonEntryPoint(boolean root) {
        if (root) {
            CoreAPI.getInstance().modConstructed(this.getClass().getPackage(), this.getModID(), this.getModName(), this instanceof ClientEntryPoint ? "Client" : "Common");
        }
        this.delegatedClientHandle = CoreAPI.isClient() ? this.checkThis(this.setDelegatedClientHandle()) : null;
        this.delegatedServerHandle = CoreAPI.isServer() ? this.checkThis(this.setDelegatedServerHandle()) : null;
        this.delegatedCustomHandle = this.checkThis(this.setDelegatedCustomHandle());
    }

    protected final void onHandleAdded(CommonEntryPoint handle) {
        handle.parent = this;
        handle.extraData = this.extraData;
    }

    private <E extends CommonEntryPoint> E checkThis(E handle) {
        Object object = handle = this.verifyNoDuplicates(handle) ? handle : null;
        if (Objects.nonNull(handle)) {
            this.onHandleAdded(handle);
        }
        return handle;
    }

    public final void checkClientSetup() {
        if (CoreAPI.isClient()) {
            this.checkClientSetupInner();
        }
    }

    protected final void checkClientSetupInner() {
        this.handleWithClientCustom(ClientEntryPoint::onClientSetup, false);
    }

    public final void checkDedicatedServerSetup() {
        if (CoreAPI.isServer()) {
            this.checkDedicatedServerSetupInner();
        }
    }

    protected final void checkDedicatedServerSetupInner() {
        this.handleWithServerCustom(CommonEntryPoint::onDedicatedServerSetup, false);
    }

    protected abstract String getModID();

    protected abstract String getModName();

    @IndirectCallers
    protected final void handleAll(Consumer<CommonEntryPoint> commonHandle, Consumer<ClientEntryPoint> clientHandle) {
        this.handleAll(commonHandle, clientHandle, true);
    }

    protected final void handleAll(Consumer<CommonEntryPoint> commonHandle, Consumer<ClientEntryPoint> clientHandle, boolean ignoreThis) {
        if (!ignoreThis) {
            this.handleEither(this, commonHandle, clientHandle);
        }
        this.handleEither(this.delegatedClientHandle, commonHandle, clientHandle);
        this.handleEither(this.delegatedCustomHandle, commonHandle, clientHandle);
        this.handleEither(this.delegatedServerHandle, commonHandle, clientHandle);
    }

    @IndirectCallers
    protected final void handleAll(Consumer<CommonEntryPoint> commonHandle) {
        this.handleAll(commonHandle, true);
    }

    protected final void handleAll(Consumer<CommonEntryPoint> commonHandle, boolean ignoreThis) {
        if (!ignoreThis) {
            commonHandle.accept(this);
        }
        if (Objects.nonNull(this.delegatedClientHandle)) {
            commonHandle.accept(this.delegatedClientHandle);
        }
        if (Objects.nonNull(this.delegatedCustomHandle)) {
            commonHandle.accept(this.delegatedCustomHandle);
        }
        if (Objects.nonNull(this.delegatedServerHandle)) {
            commonHandle.accept(this.delegatedServerHandle);
        }
    }

    protected final void handleEither(@Nullable CommonEntryPoint delegate, Consumer<CommonEntryPoint> commonHandle, Consumer<ClientEntryPoint> clientHandle) {
        if (Objects.nonNull(delegate)) {
            if (this instanceof ClientEntryPoint) {
                clientHandle.accept((ClientEntryPoint)delegate);
            } else {
                commonHandle.accept(delegate);
            }
        }
    }

    @IndirectCallers
    protected final void handleWithClient(Consumer<ClientEntryPoint> clientHandle) {
        this.handleWithClient(clientHandle, true);
    }

    protected final void handleWithClient(Consumer<ClientEntryPoint> clientHandle, boolean strict) {
        if (!strict && this instanceof ClientEntryPoint) {
            clientHandle.accept((ClientEntryPoint)this);
        }
        if (Objects.nonNull(this.delegatedClientHandle)) {
            clientHandle.accept(this.delegatedClientHandle);
        }
    }

    @IndirectCallers
    protected final void handleWithClientCustom(Consumer<ClientEntryPoint> clientHandle) {
        this.handleWithClientCustom(clientHandle, true);
    }

    protected final void handleWithClientCustom(Consumer<ClientEntryPoint> clientHandle, boolean strict) {
        this.handleWithClient(clientHandle, strict);
        if (this.delegatedCustomHandle instanceof ClientEntryPoint) {
            clientHandle.accept((ClientEntryPoint)this.delegatedCustomHandle);
        }
    }

    @IndirectCallers
    protected final void handleWithCustom(Consumer<CommonEntryPoint> customHandle) {
        this.handleWithCustom(customHandle, false);
    }

    protected final void handleWithCustom(Consumer<CommonEntryPoint> customHandle, boolean strict) {
        if (!strict) {
            customHandle.accept(this);
        }
        if (Objects.nonNull(this.delegatedCustomHandle)) {
            customHandle.accept(this.delegatedCustomHandle);
        }
    }

    @IndirectCallers
    protected final void handleWithServer(Consumer<CommonEntryPoint> serverHandle) {
        this.handleWithServer(serverHandle, true);
    }

    protected final void handleWithServer(Consumer<CommonEntryPoint> serverHandle, boolean strict) {
        if (!strict) {
            serverHandle.accept(this);
        }
        if (Objects.nonNull(this.delegatedServerHandle)) {
            serverHandle.accept(this.delegatedServerHandle);
        }
    }

    @IndirectCallers
    protected final void handleWithServerCustom(Consumer<CommonEntryPoint> serverHandle) {
        this.handleWithServerCustom(serverHandle, true);
    }

    protected final void handleWithServerCustom(Consumer<CommonEntryPoint> serverHandle, boolean strict) {
        this.handleWithServer(serverHandle, strict);
        if (Objects.nonNull(this.delegatedCustomHandle)) {
            serverHandle.accept(this.delegatedCustomHandle);
        }
    }

    public void onConstructed() {
    }

    public void onPreRegistration() {
    }

    public void onCommonSetup() {
    }

    protected void onDedicatedServerSetup() {
    }

    public void onInterModEnqueue() {
    }

    public void onInterModProcess() {
    }

    public void onLoadComplete() {
    }

    public void onServerAboutToStart() {
    }

    public void onServerStarting() {
    }

    public void onServerStarted() {
    }

    public void onServerStopping() {
    }

    public void onServerStopped() {
    }

    @Nullable
    public ClientEntryPoint setDelegatedClientHandle() {
        return null;
    }

    @Nullable
    public CommonEntryPoint setDelegatedCustomHandle() {
        return null;
    }

    @Nullable
    public CommonEntryPoint setDelegatedServerHandle() {
        return null;
    }

    @IndirectCallers
    public void setExtraData(Object data) {
        this.extraData = data;
        if (Objects.nonNull(this.delegatedClientHandle)) {
            this.delegatedClientHandle.setExtraData(data);
        }
        if (Objects.nonNull(this.delegatedCustomHandle)) {
            this.delegatedCustomHandle.setExtraData(data);
        }
        if (Objects.nonNull(this.delegatedServerHandle)) {
            this.delegatedServerHandle.setExtraData(data);
        }
    }

    protected boolean verifyNoDuplicates(@Nullable CommonEntryPoint handler) {
        if (Objects.isNull(handler)) {
            return true;
        }
        return Objects.nonNull(this.parent) ? this.parent.verifyNoDuplicates(handler) : this.verifyNoDuplicatesInner(handler);
    }

    protected boolean verifyNoDuplicatesInner(CommonEntryPoint handler) {
        if (handler == this) {
            return false;
        }
        if (Objects.nonNull(this.delegatedClientHandle) && !this.delegatedClientHandle.verifyNoDuplicatesInner(handler)) {
            return false;
        }
        if (Objects.nonNull(this.delegatedCustomHandle) && !this.delegatedCustomHandle.verifyNoDuplicatesInner(handler)) {
            return false;
        }
        return Objects.isNull(this.delegatedServerHandle) || this.delegatedServerHandle.verifyNoDuplicatesInner(handler);
    }
}

