/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.common.entity;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import lombok.Generated;
import mods.thecomputerizer.theimpossiblelibrary.api.common.effect.EffectInstanceAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.Hacks;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.registry.RegistryAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.registry.RegistryEntryAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.resource.ResourceLocationAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.Box;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector3;
import mods.thecomputerizer.theimpossiblelibrary.api.tag.CompoundTagAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.util.GenericUtils;
import mods.thecomputerizer.theimpossiblelibrary.api.world.BlockPosAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.world.DimensionAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.world.PosHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.world.WorldAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.wrappers.AbstractWrapped;
import mods.thecomputerizer.theimpossiblelibrary.api.wrappers.WrapperHelper;
import org.jetbrains.annotations.Nullable;

public abstract class EntityAPI<E, V>
extends AbstractWrapped<V>
implements RegistryEntryAPI<V> {
    protected final Function<Object, Collection<?>> effectsGetter;
    protected ResourceLocationAPI<?> registryName;
    protected E entity;
    private boolean erroredEffects;

    protected EntityAPI(Object entity, Object type) {
        this(entity, type, (x$0, x$1) -> (Collection)Hacks.invokeMethodObj(x$0, x$1, new Object[0]));
    }

    protected EntityAPI(Object entity, Object type, BiFunction<E, String, Collection<?>> effectsGetter) {
        super(type);
        this.entity = GenericUtils.cast(entity);
        this.effectsGetter = e -> (Collection)effectsGetter.apply(GenericUtils.cast(e), this.getActiveEffectsMethodName());
    }

    @IndirectCallers
    public abstract boolean canTarget();

    @Override
    public boolean equals(Object other) {
        if (super.equals(other) && other instanceof EntityAPI) {
            E entity = this.getEntity();
            E otherEntity = ((EntityAPI)other).getEntity();
            return Objects.isNull(otherEntity) ? Objects.isNull(entity) : entity.equals(otherEntity);
        }
        return false;
    }

    @IndirectCallers
    public Collection<EffectInstanceAPI<?>> getActiveEffects() {
        if (this.erroredEffects || Objects.isNull(this.entity) || !this.isLiving()) {
            return Collections.emptyList();
        }
        try {
            return WrapperHelper.WrapperType.EFFECT_INSTANCE.wrapCollectionGetter(this.entity, this.effectsGetter);
        }
        catch (Throwable t) {
            TILRef.logError("Failed to retrieve active effects for entity! This check will be disable for the current entity", t);
            this.erroredEffects = true;
            return Collections.emptyList();
        }
    }

    protected String getActiveEffectsMethodName() {
        return "getActiveEffects";
    }

    @IndirectCallers
    public abstract EntityAPI<?, ?> getAttackTarget();

    public abstract Box getBoundingBox();

    public abstract CompoundTagAPI<?> getData();

    public abstract DimensionAPI<?> getDimension();

    @IndirectCallers
    public double getDistanceTo(EntityAPI<?, ?> entity) {
        return Objects.nonNull(entity) ? this.getPos().distanceTo(entity.getPos()) : Double.MAX_VALUE;
    }

    @IndirectCallers
    public double getDistanceTo(BlockPosAPI<?> pos) {
        return Objects.nonNull(pos) ? this.getPos().distanceTo(pos) : Double.MAX_VALUE;
    }

    @IndirectCallers
    public double getDistanceTo(Vector3 pos) {
        return Objects.nonNull(pos) ? this.getPos().distanceTo(pos) : Double.MAX_VALUE;
    }

    @Override
    public abstract String getName();

    public abstract BlockPosAPI<?> getPos();

    public Vector3 getPosExact() {
        return new Vector3(this.x(), this.y(), this.z());
    }

    @IndirectCallers
    public BlockPosAPI<?> getPosRounded() {
        double x = PosHelper.roundToCenter(this.x());
        double y = PosHelper.roundToCenter(this.y());
        double z = PosHelper.roundToCenter(this.z());
        return PosHelper.getPos(x, y, z);
    }

    @Override
    public ResourceLocationAPI<?> getRegistryName() {
        RegistryAPI<?> registry;
        if (Objects.isNull(this.registryName) && Objects.nonNull(this.wrapped) && Objects.nonNull(registry = this.getRegistry())) {
            this.registryName = registry.getKey(this.unwrap());
        }
        return this.registryName;
    }

    public abstract EntityAPI<?, ?> getRootVehicle();

    @Nullable
    public abstract EntityAPI<?, ?> getVehicle();

    public abstract WorldAPI<?> getWorld();

    @IndirectCallers
    public abstract boolean isAlive();

    @IndirectCallers
    public abstract boolean isAnimal();

    @IndirectCallers
    public abstract boolean isHostile();

    public abstract boolean isLiving();

    public abstract boolean isPlayer();

    @IndirectCallers
    public abstract boolean isOwnedBy(EntityAPI<?, ?> var1);

    protected void setLocalRegistryName(ResourceLocationAPI<?> registryName) {
        this.registryName = registryName;
    }

    public void setPosition(BlockPosAPI<?> pos) {
        this.setPosition(pos.x(), pos.y(), pos.z());
    }

    public void setPosition(Vector3 vec) {
        this.setPosition(vec.dX(), vec.dY(), vec.dZ());
    }

    public void setPosition(int x, int y, int z) {
        this.setPosition((double)x, (double)y, (double)z);
    }

    public abstract void setPosition(double var1, double var3, double var5);

    public <T> T unwrapEntity() {
        return GenericUtils.cast(this.getEntity());
    }

    public abstract double x();

    public abstract double y();

    public abstract double z();

    @Generated
    public Function<Object, Collection<?>> getEffectsGetter() {
        return this.effectsGetter;
    }

    @Generated
    public E getEntity() {
        return this.entity;
    }

    @Generated
    public boolean isErroredEffects() {
        return this.erroredEffects;
    }
}

