/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.common.event;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;
import mods.thecomputerizer.theimpossiblelibrary.api.common.advancement.AdvancementAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.block.BlockAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.block.BlockSnapshotAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.block.BlockStateAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.blockentity.BlockEntityAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.entity.DamageAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.entity.EntityAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.entity.LivingEntityAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.entity.PlayerAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.event.EventFieldWrapper;
import mods.thecomputerizer.theimpossiblelibrary.api.common.event.EventHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.common.event.EventPriority;
import mods.thecomputerizer.theimpossiblelibrary.api.common.item.ActionResult;
import mods.thecomputerizer.theimpossiblelibrary.api.common.item.ItemAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.item.ItemStackAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreStateAccessor;
import mods.thecomputerizer.theimpossiblelibrary.api.core.Hacks;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.util.GenericUtils;
import mods.thecomputerizer.theimpossiblelibrary.api.util.Misc;
import mods.thecomputerizer.theimpossiblelibrary.api.world.BlockPosAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.world.ExplosionAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.world.WorldAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.wrappers.Wrapped;
import mods.thecomputerizer.theimpossiblelibrary.api.wrappers.WrapperHelper;
import org.jetbrains.annotations.Nullable;

public abstract class EventWrapper<E>
implements CoreStateAccessor {
    private final EventType<?> type;
    private boolean canceled;
    private EventPriority priority;
    private Result result;
    protected E event;

    protected EventWrapper(EventType<?> type) {
        this.type = type;
        this.priority = EventPriority.NORMAL;
    }

    protected Function<E, ?> actionResultGetter(String getterMethod) {
        return this.getter(getterMethod, EventHelper::getActionResult);
    }

    protected <T> BiConsumer<E, T> actionResultSetter(String setterMethod) {
        return this.setter(setterMethod, EventHelper::setActionResult);
    }

    public void cancel() {
    }

    protected <T> T cast(Object obj) {
        return GenericUtils.cast(obj);
    }

    @Nullable
    protected <I, O> O getter(@Nullable I input, String method) {
        return this.getter(input, method, null);
    }

    @Nullable
    protected <I, O> O getter(@Nullable I input, String method, @Nullable Function<?, O> transformer) {
        if (Objects.isNull(input)) {
            return null;
        }
        if (Objects.isNull(transformer)) {
            return (O)Hacks.invoke(input, method, new Object[0]);
        }
        return transformer.apply(Hacks.invoke(input, method, new Object[0]));
    }

    protected Function<E, Object> getter(String getterMethod) {
        return Misc.safeFunction(event -> this.getter(event, getterMethod));
    }

    protected Function<E, Object> getter(String getterMethod, @Nullable Function<?, ?> transformer) {
        return Misc.safeFunction(event -> this.getter(event, getterMethod, transformer));
    }

    protected Function<E, ?> eventResultGetter(String getterMethod) {
        return this.getter(getterMethod, EventHelper::getEventResult);
    }

    protected <T> BiConsumer<E, T> eventResultSetter(String setterMethod) {
        return this.setter(setterMethod, EventHelper::setEventResult);
    }

    public boolean hasInvokers() {
        return ((EventType)this.type).hasInvokers();
    }

    public boolean hasResult() {
        return ((EventType)this.type).hasResult;
    }

    public <V> V initPrimitive(@Nullable Function<E, V> func, V defVal) {
        return Objects.nonNull(this.event) && Objects.nonNull(func) ? func.apply(this.event) : defVal;
    }

    public boolean isCancelable() {
        return ((EventType)this.type).cancelable;
    }

    public abstract boolean isClient();

    public abstract boolean isCommon();

    public abstract boolean isServer();

    @Nullable
    protected <I, O> O nestedGetter(@Nullable I input, String ... methods) {
        return this.nestedGetter(input, (Function<?, O>)null, methods);
    }

    @Nullable
    protected <I, O> O nestedGetter(@Nullable I input, @Nullable Function<?, O> transformer, String ... methods) {
        if (Objects.isNull(input)) {
            return null;
        }
        Object result = null;
        for (String method : methods) {
            result = Hacks.invoke(input, method, new Object[0]);
        }
        return (O)(Objects.nonNull(transformer) ? transformer.apply(this.cast(result)) : this.cast(result));
    }

    @IndirectCallers
    protected Function<E, Object> nestedGetter(String ... getterMethods) {
        return Misc.safeFunction(event -> this.nestedGetter(event, getterMethods));
    }

    protected Function<E, Object> nestedGetter(@Nullable Function<?, ?> transformer, String ... getterMethods) {
        return Misc.safeFunction(event -> this.nestedGetter(event, transformer, getterMethods));
    }

    protected abstract void populate();

    public void setEvent(E event) {
        this.event = event;
        this.populate();
    }

    protected <T> void setter(@Nullable E event, T result, String method) {
        this.setter(event, result, method, null);
    }

    protected <T> void setter(@Nullable E event, T result, String method, @Nullable Function<?, T> transformer) {
        if (Objects.isNull(event)) {
            return;
        }
        Hacks.invoke(event, method, Objects.nonNull(transformer) ? transformer.apply(this.cast(result)) : result);
    }

    @IndirectCallers
    protected <V> BiConsumer<E, V> setter(String setterMethod) {
        return (event, result) -> this.setter(event, result, setterMethod);
    }

    @IndirectCallers
    protected <V> BiConsumer<E, V> setter(String setterMethod, @Nullable Function<?, V> transformer) {
        return (event, result) -> this.setter(event, result, setterMethod, transformer);
    }

    private <T> T unwrap(Object obj) {
        return GenericUtils.cast(obj);
    }

    private <V> BiConsumer<E, V> wrappedSetter(BiConsumer<?, ?> generic) {
        Function<Object, Object> unwrapper = wrapped -> {
            if (wrapped instanceof BlockEntityAPI) {
                return this.unwrap(((BlockEntityAPI)wrapped).getEntity());
            }
            if (wrapped instanceof EntityAPI) {
                return this.unwrap(((EntityAPI)wrapped).getEntity());
            }
            return ((Wrapped)wrapped).unwrap();
        };
        return (event, api) -> generic.accept(this.unwrap(event), this.unwrap(unwrapper.apply(api)));
    }

    @Nullable
    protected AdvancementAPI<?> wrapAdvancement(@Nullable Function<?, ?> getter) {
        return WrapperHelper.wrapAdvancement(this.event, getter);
    }

    protected <V, T> EventFieldWrapper<E, AdvancementAPI<?>> wrapAdvancementBoth(Function<E, ?> getter, BiConsumer<E, T> setter) {
        return new EventFieldWrapper<Object, Object>(event -> this.wrapAdvancement(getter), this.wrappedSetter(setter), null);
    }

    protected <V> EventFieldWrapper<E, AdvancementAPI<?>> wrapAdvancementGetter(Function<E, ?> getter) {
        return new EventFieldWrapper<Object, Object>(event -> this.wrapAdvancement(getter), null);
    }

    @Nullable
    protected BlockAPI<?> wrapBlock(@Nullable Function<?, ?> getter) {
        return WrapperHelper.wrapBlock(this.event, getter);
    }

    protected <V, T> EventFieldWrapper<E, BlockAPI<?>> wrapBlockBoth(Function<E, ?> getter, BiConsumer<E, T> setter) {
        return new EventFieldWrapper<Object, Object>(event -> this.wrapBlock(getter), this.wrappedSetter(setter), null);
    }

    protected <V> EventFieldWrapper<E, BlockAPI<?>> wrapBlockGetter(Function<E, ?> getter) {
        return new EventFieldWrapper<Object, Object>(event -> this.wrapBlock(getter), null);
    }

    @Nullable
    protected BlockEntityAPI<?, ?> wrapBlockEntity(@Nullable Function<?, ?> getter) {
        return WrapperHelper.wrapBlockEntity(this.event, getter);
    }

    protected <V, T> EventFieldWrapper<E, BlockEntityAPI<?, ?>> wrapBlockEntityBoth(Function<E, ?> getter, BiConsumer<E, T> setter) {
        return new EventFieldWrapper<Object, Object>(event -> this.wrapBlockEntity(getter), this.wrappedSetter(setter), null);
    }

    protected <V> EventFieldWrapper<E, BlockEntityAPI<?, ?>> wrapBlockEntityGetter(Function<E, ?> getter) {
        return new EventFieldWrapper<Object, Object>(event -> this.wrapBlockEntity(getter), null);
    }

    protected EventFieldWrapper<E, ActionResult> wrapActionResultBoth(String getterMethod, String setterMethod) {
        return this.wrapBoth("Generic", this.actionResultGetter(getterMethod), this.actionResultSetter(setterMethod), ActionResult.PASS);
    }

    @IndirectCallers
    protected <V, T> EventFieldWrapper<E, V> wrapBoth(String type, Function<E, ?> getter, BiConsumer<E, T> setter) {
        return (EventFieldWrapper)Hacks.invoke(this, "wrap" + type + "Both", getter, setter);
    }

    protected <V, T> EventFieldWrapper<E, V> wrapBoth(String type, Function<E, ?> getter, BiConsumer<E, T> setter, V defVal) {
        return (EventFieldWrapper)Hacks.invoke(this, "wrap" + type + "Both", getter, setter, defVal);
    }

    @Nullable
    protected DamageAPI<?> wrapDamage(@Nullable Function<?, ?> getter, @Nullable Function<?, Float> getAmount) {
        return WrapperHelper.wrapDamage(this.event, getter, getAmount);
    }

    @Nullable
    protected DamageAPI<?> wrapDamage(@Nullable Function<?, ?> getter, float amount) {
        return WrapperHelper.wrapDamage(this.event, getter, amount);
    }

    protected <V> EventFieldWrapper<E, DamageAPI<?>> wrapDamageGetter(Function<E, ?> sourceGetter, Function<E, Float> getAmount) {
        return new EventFieldWrapper<Object, Object>(event -> this.wrapDamage(sourceGetter, getAmount), null);
    }

    protected <V> EventFieldWrapper<E, DamageAPI<?>> wrapDamageGetter(Function<E, ?> sourceGetter, float amount) {
        return new EventFieldWrapper<Object, Object>(event -> this.wrapDamage(sourceGetter, amount), null);
    }

    @Nullable
    protected EntityAPI<?, ?> wrapEntity(@Nullable Function<?, ?> getter) {
        return WrapperHelper.wrapEntity(this.event, getter);
    }

    protected <V, T> EventFieldWrapper<E, EntityAPI<?, ?>> wrapEntityBoth(Function<E, ?> getter, BiConsumer<E, T> setter) {
        return new EventFieldWrapper<Object, Object>(event -> this.wrapEntity(getter), this.wrappedSetter(setter), null);
    }

    protected <V> EventFieldWrapper<E, EntityAPI<?, ?>> wrapEntityGetter(Function<E, ?> getter) {
        return new EventFieldWrapper<Object, Object>(event -> this.wrapEntity(getter), null);
    }

    protected EventFieldWrapper<E, Result> wrapEventResultBoth(String getterMethod, String setterMethod) {
        return this.wrapBoth("Generic", this.eventResultGetter(getterMethod), this.eventResultSetter(setterMethod), Result.DEFAULT);
    }

    @Nullable
    protected ExplosionAPI<?> wrapExplosion(@Nullable Function<?, ?> getter) {
        return WrapperHelper.wrapExplosion(this.event, getter);
    }

    protected <V, T> EventFieldWrapper<E, ExplosionAPI<?>> wrapExplosionBoth(Function<E, ?> getter, BiConsumer<E, T> setter) {
        return new EventFieldWrapper<Object, Object>(event -> this.wrapExplosion(getter), this.wrappedSetter(setter), null);
    }

    protected <V> EventFieldWrapper<E, ExplosionAPI<?>> wrapExplosionGetter(Function<E, ?> getter) {
        return new EventFieldWrapper<Object, Object>(event -> this.wrapExplosion(getter), null);
    }

    @IndirectCallers
    protected <V> EventFieldWrapper<E, V> wrapGetter(String type, Function<E, ?> getter) {
        return (EventFieldWrapper)Hacks.invoke(this, "wrap" + type + "Getter", getter);
    }

    @IndirectCallers
    protected <V> EventFieldWrapper<E, V> wrapGetter(String type, Function<E, ?> getter, V defVal) {
        return (EventFieldWrapper)Hacks.invoke(this, "wrap" + type + "Getter", getter, defVal);
    }

    @Nullable
    protected ItemAPI<?> wrapItem(@Nullable Function<?, ?> getter) {
        return WrapperHelper.wrapItem(this.event, getter);
    }

    protected <V, T> EventFieldWrapper<E, ItemAPI<?>> wrapItemBoth(Function<E, ?> getter, BiConsumer<E, T> setter) {
        return new EventFieldWrapper<Object, Object>(event -> this.wrapItem(getter), this.wrappedSetter(setter), null);
    }

    protected <V> EventFieldWrapper<E, ItemAPI<?>> wrapItemGetter(Function<E, ?> getter) {
        return new EventFieldWrapper<Object, Object>(event -> this.wrapItem(getter), null);
    }

    @Nullable
    protected ItemStackAPI<?> wrapItemStack(@Nullable Function<?, ?> getter) {
        return WrapperHelper.wrapItemStack(this.event, getter);
    }

    protected <V, T> EventFieldWrapper<E, ItemStackAPI<?>> wrapItemStackBoth(Function<E, ?> getter, BiConsumer<E, T> setter) {
        return new EventFieldWrapper<Object, Object>(event -> this.wrapItemStack(getter), this.wrappedSetter(setter), null);
    }

    protected <V> EventFieldWrapper<E, ItemStackAPI<?>> wrapItemStackGetter(Function<E, ?> getter) {
        return new EventFieldWrapper<Object, Object>(event -> this.wrapItemStack(getter), null);
    }

    @Nullable
    protected LivingEntityAPI<?, ?> wrapLiving(@Nullable Function<?, ?> getter) {
        return WrapperHelper.wrapLivingEntity(this.event, getter);
    }

    protected <V, T> EventFieldWrapper<E, LivingEntityAPI<?, ?>> wrapLivingBoth(Function<E, ?> getter, BiConsumer<E, T> setter) {
        return new EventFieldWrapper<Object, Object>(event -> this.wrapLiving(getter), this.wrappedSetter(setter), null);
    }

    protected <V> EventFieldWrapper<E, LivingEntityAPI<?, ?>> wrapLivingGetter(Function<E, ?> getter) {
        return new EventFieldWrapper<Object, Object>(event -> this.wrapLiving(getter), null);
    }

    @Nullable
    protected PlayerAPI<?, ?> wrapPlayer(@Nullable Function<E, ?> getter) {
        return WrapperHelper.wrapPlayer(this.event, getter);
    }

    protected <V, T> EventFieldWrapper<E, PlayerAPI<?, ?>> wrapPlayerBoth(Function<E, ?> getter, BiConsumer<E, T> setter) {
        return new EventFieldWrapper<Object, Object>(event -> this.wrapPlayer(getter), this.wrappedSetter(setter), null);
    }

    protected <V> EventFieldWrapper<E, PlayerAPI<?, ?>> wrapPlayerGetter(Function<E, ?> getter) {
        return new EventFieldWrapper<Object, Object>(event -> this.wrapPlayer(getter), null);
    }

    @Nullable
    protected BlockPosAPI<?> wrapPos(@Nullable Function<?, ?> getter) {
        return WrapperHelper.wrapPosition(this.event, getter);
    }

    protected <V, T> EventFieldWrapper<E, BlockPosAPI<?>> wrapPosBoth(Function<E, ?> getter, BiConsumer<E, T> setter) {
        return new EventFieldWrapper<Object, Object>(event -> this.wrapPos(getter), this.wrappedSetter(setter), null);
    }

    protected <V> EventFieldWrapper<E, BlockPosAPI<?>> wrapPosGetter(Function<E, ?> getter) {
        return new EventFieldWrapper<Object, Object>(event -> this.wrapPos(getter), null);
    }

    protected <V, T> EventFieldWrapper<E, V> wrapGenericBoth(Function<E, ?> getter, BiConsumer<E, T> setter, V defVal) {
        return new EventFieldWrapper(GenericUtils.castFunction(getter), GenericUtils.castBiConsumer(setter), defVal);
    }

    protected <V> EventFieldWrapper<E, V> wrapGenericGetter(Function<E, ?> getter, V defVal) {
        return new EventFieldWrapper(GenericUtils.castFunction(getter), defVal);
    }

    @Nullable
    protected BlockSnapshotAPI<?> wrapSnapshot(@Nullable Function<?, ?> getter) {
        return WrapperHelper.wrapSnapshot(this.event, getter);
    }

    protected <V, T> EventFieldWrapper<E, BlockSnapshotAPI<?>> wrapSnapshotBoth(Function<E, ?> getter, BiConsumer<E, T> setter) {
        return new EventFieldWrapper<Object, Object>(event -> this.wrapSnapshot(getter), this.wrappedSetter(setter), null);
    }

    protected <V> EventFieldWrapper<E, BlockSnapshotAPI<?>> wrapSnapshotGetter(Function<E, ?> getter) {
        return new EventFieldWrapper<Object, Object>(event -> this.wrapSnapshot(getter), null);
    }

    @Nullable
    protected BlockStateAPI<?> wrapState(@Nullable Function<?, ?> getter) {
        return WrapperHelper.wrapState(this.event, getter);
    }

    protected <V, T> EventFieldWrapper<E, BlockStateAPI<?>> wrapStateBoth(Function<E, ?> getter, BiConsumer<E, T> setter) {
        return new EventFieldWrapper<Object, Object>(event -> this.wrapState(getter), this.wrappedSetter(setter), null);
    }

    protected <V> EventFieldWrapper<E, BlockStateAPI<?>> wrapStateGetter(Function<E, ?> getter) {
        return new EventFieldWrapper<Object, Object>(event -> this.wrapState(getter), null);
    }

    @Nullable
    protected WorldAPI<?> wrapWorld(@Nullable Function<?, ?> getter) {
        return WrapperHelper.wrapWorld(this.event, getter);
    }

    protected <V, T> EventFieldWrapper<E, WorldAPI<?>> wrapWorldBoth(Function<E, ?> getter, BiConsumer<E, T> setter) {
        return new EventFieldWrapper<Object, Object>(event -> this.wrapWorld(getter), this.wrappedSetter(setter), null);
    }

    protected <V> EventFieldWrapper<E, WorldAPI<?>> wrapWorldGetter(Function<E, ?> getter) {
        return new EventFieldWrapper<Object, Object>(event -> this.wrapWorld(getter), null);
    }

    @Generated
    public EventType<?> getType() {
        return this.type;
    }

    @Generated
    public boolean isCanceled() {
        return this.canceled;
    }

    @Generated
    public EventPriority getPriority() {
        return this.priority;
    }

    @Generated
    public Result getResult() {
        return this.result;
    }

    @Generated
    public E getEvent() {
        return this.event;
    }

    @Generated
    public void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    @Generated
    public void setPriority(EventPriority priority) {
        this.priority = priority;
    }

    @Generated
    public void setResult(Result result) {
        this.result = result;
    }

    public static abstract class EventType<E extends EventWrapper<?>> {
        private final boolean cancelable;
        private final boolean hasResult;
        private final List<Consumer<E>> invokers;
        private E connector;

        protected EventType(boolean cancelable, boolean hasResult) {
            this.cancelable = cancelable;
            this.hasResult = hasResult;
            this.invokers = new ArrayList<Consumer<E>>();
        }

        public void addInvoker(Consumer<E> invoker) {
            if (Objects.nonNull(this.connector)) {
                if (this.invokers.isEmpty()) {
                    EventHelper.registerWrapperImpl(this.connector);
                }
                this.invokers.add(invoker);
            } else {
                TILRef.logError("Cannot add invoker to unconnected event type ({})", this.getClass().getName());
            }
        }

        private boolean hasInvokers() {
            return Objects.nonNull(this.connector) && !this.invokers.isEmpty();
        }

        public <C> void invoke(C event) {
            if (Objects.nonNull(this.connector) && !this.invokers.isEmpty() && this.setWrapperEvent(event, (EventWrapper<?>)this.connector)) {
                for (Consumer<E> invoker : this.invokers) {
                    invoker.accept(this.connector);
                    if (!((EventWrapper)this.connector).isCancelable() || !((EventWrapper)this.connector).isCanceled()) continue;
                    ((EventWrapper)this.connector).cancel();
                    break;
                }
            }
        }

        public abstract boolean isClient();

        public abstract boolean isCommon();

        public abstract boolean isServer();

        public void removeInvoker(Consumer<E> invoker) {
            this.invokers.remove(invoker);
        }

        public <I extends E> void setConnector(I impl) {
            this.connector = impl;
        }

        private <C> boolean setWrapperEvent(C event, EventWrapper<?> wrapper) {
            wrapper.setEvent(event);
            return !((EventWrapper)wrapper).canceled;
        }
    }

    public static enum Result {
        ALLOW,
        DEFAULT,
        DENY;

    }
}

