/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.common.item;

import java.util.Objects;
import mods.thecomputerizer.theimpossiblelibrary.api.common.item.ItemAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.tag.CompoundTagAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.tag.TagHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.wrappers.AbstractWrapped;
import org.jetbrains.annotations.Nullable;

public abstract class ItemStackAPI<S>
extends AbstractWrapped<S> {
    protected ItemStackAPI(Object stack) {
        super(stack);
    }

    @IndirectCallers
    public void decrement() {
        int count = this.getCount();
        if (count > 0) {
            this.setCount(count - 1);
        }
    }

    public abstract int getCount();

    public abstract ItemAPI<?> getItem();

    @IndirectCallers
    public CompoundTagAPI<?> getOrCreateTag() {
        CompoundTagAPI<?> tag = this.getTag();
        if (Objects.isNull(tag)) {
            tag = TagHelper.makeCompoundTag();
            this.setTag(tag);
        }
        return tag;
    }

    @Nullable
    public abstract CompoundTagAPI<?> getTag();

    @IndirectCallers
    public void increment() {
        this.setCount(this.getCount() + 1);
    }

    public abstract boolean isEmpty();

    public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public abstract void setCount(int var1);

    public abstract void setTag(@Nullable CompoundTagAPI<?> var1);
}

