/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.core;

import io.github.toolfactory.jvm.util.BufferHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import mods.thecomputerizer.theimpossiblelibrary.api.core.ArrayHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.Hacks;
import mods.thecomputerizer.theimpossiblelibrary.api.core.JVMHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILDev;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.io.FileHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.io.IOUtils;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.util.GenericUtils;
import mods.thecomputerizer.theimpossiblelibrary.api.util.Misc;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ClassHelper {
    static final Logger LOGGER = TILRef.createLogger("TIL ClassHelper");
    static final String PACKAGE_VERSION_INFO = Package.class.getName() + "$VersionInfo";

    public static URL absoluteLocation(@Nullable URL url, String className) {
        String locationStr = ClassHelper.absoluteLocationStr(url, className);
        return Objects.nonNull(locationStr) ? FileHelper.toURL(locationStr) : null;
    }

    @Nullable
    public static String absoluteLocationStr(@Nullable URL url, String className) {
        if (Objects.isNull(url)) {
            LOGGER.error("Cannot extract class path of null URL for {}!", (Object)className);
            return null;
        }
        String urlStr = url.toString().replace("%20", " ");
        String appended = (urlStr.startsWith("jar") ? "!/" : "/") + className;
        String ret = urlStr.substring(urlStr.indexOf("/"), urlStr.length() - appended.length());
        if (ret.contains(".jar") || JVMHelper.isJava8()) {
            return ret;
        }
        int index = ret.lastIndexOf("/");
        return index == -1 ? ret : ret.substring(0, index);
    }

    public static void addSource(Set<String> sources, Class<?> clazz) {
        URL url = ClassHelper.getSourceURL(clazz);
        if (Objects.nonNull(url)) {
            sources.add(url.toString());
        } else {
            LOGGER.error("Failed to add source for {}", clazz);
        }
    }

    @IndirectCallers
    public static boolean addSourceTo(Class<?> c, ClassLoader to) {
        if (c.getClassLoader() == to) {
            LOGGER.error("Source for {} already exists on {}!", c, (Object)to);
            return false;
        }
        boolean added = false;
        URL source = ClassHelper.getSourceURL(c);
        CoreAPI core = CoreAPI.getInstance();
        if (Objects.nonNull(core)) {
            added = core.addURLToClassLoader(to, source);
        } else if (to instanceof URLClassLoader) {
            added = ClassHelper.loadURL((URLClassLoader)to, source);
        } else {
            LOGGER.error("Failed to add source for {} to {}!", c, (Object)to);
        }
        return added;
    }

    public static String className(@Nullable Object obj) {
        return ClassHelper.className(Objects.nonNull(obj) ? obj.getClass() : null, false);
    }

    public static String className(@Nullable Class<?> clazz) {
        return ClassHelper.className(clazz, false);
    }

    public static String className(@Nullable Object obj, boolean simple) {
        return ClassHelper.className(Objects.nonNull(obj) ? obj.getClass() : null, simple);
    }

    public static String className(@Nullable Class<?> clazz, boolean simple) {
        return Objects.nonNull(clazz) ? (simple ? clazz.getSimpleName() : clazz.getName()) : "";
    }

    @Nullable
    public static Class<?> defineAndResolveClass(ClassLoader loader, String name, byte[] byteCode) {
        return ClassHelper.resolveClass(loader, ClassHelper.defineClass(loader, name, byteCode));
    }

    @Nullable
    public static Class<?> defineClass(ClassLoader loader, String name, URL url) {
        if (Objects.nonNull(url)) {
            TILDev.logInfo("Attempting to define class {} from URL {} on loader {}", name, url, loader);
            Hacks.checkBurningWaveInit();
            ByteBuffer buffer = IOUtils.toBuffer(url);
            if (Objects.nonNull(buffer)) {
                return Hacks.defineClass(loader, name, buffer);
            }
            LOGGER.error("Cannot define class after buffer retrieval failure: {}", (Object)name);
            return null;
        }
        LOGGER.error("Cannot define class at null URL on {}", (Object)loader);
        return null;
    }

    public static Class<?> defineClass(ClassLoader loader, String className, byte[] bytes) {
        return Hacks.defineClass(loader, className, Objects.nonNull(bytes) ? ByteBuffer.wrap(bytes) : null);
    }

    public static String descriptor(Class<?> clazz) {
        return Objects.nonNull(clazz) ? ClassHelper.descriptor(clazz.getName()) : "";
    }

    public static String descriptor(String classpath) {
        return TextHelper.isNotBlank(classpath) ? "L" + ClassHelper.internalName(classpath) + ";" : "";
    }

    public static Class<?> existsOn(String name, ClassLoader loader) {
        if (Objects.isNull(name) || name.isEmpty()) {
            LOGGER.warn("Tried to check if class with null or empty name exists on {}", (Object)loader);
            return null;
        }
        try {
            return Class.forName(name, false, loader);
        }
        catch (ClassNotFoundException ex) {
            if (TILDev.DEV) {
                LOGGER.debug("Class `{}` does not exist on {}", (Object)name, (Object)loader, (Object)ex);
            } else {
                LOGGER.debug("Class `{}` does not exist on {}", (Object)name, (Object)loader);
            }
            return null;
        }
    }

    @Nullable
    public static <T> Class<T> findExtensibleClass(String name, Class<?> superClass) {
        Class clazz = (Class)GenericUtils.cast(Hacks.findClass(name));
        return Objects.nonNull(clazz) && superClass.isAssignableFrom(clazz) ? clazz : null;
    }

    public static byte[] getClassBytes(@Nullable Class<?> clazz) {
        if (Objects.isNull(clazz)) {
            LOGGER.error("Cannot get bytecode for null class!");
            return null;
        }
        ByteBuffer byteCode = Hacks.getByteCode(clazz);
        if (Objects.isNull(byteCode)) {
            LOGGER.error("Bytecode not found for {}!", clazz);
            return new byte[0];
        }
        return BufferHandler.toByteArray(byteCode);
    }

    public static URL getJarResource(String path, String relativePath) {
        try {
            String prefix = path.startsWith("/") ? "jar:file:" : "jar:file:/";
            return new URL(prefix + path + "!/" + relativePath);
        }
        catch (Exception ex) {
            LOGGER.error("Failed to get entry {} from presumed jar file {}", (Object)relativePath, (Object)path, (Object)ex);
            return null;
        }
    }

    public static String getResourcePath(String className) {
        return className.replace('.', '/') + ".class";
    }

    @Nullable
    public static URL getSourceURL(@Nullable String className, ClassLoader loader) {
        if (Objects.nonNull(className) && !className.isEmpty()) {
            try {
                String relativePath = ClassHelper.getResourcePath(className);
                return ClassHelper.absoluteLocation(loader.getResource(relativePath), relativePath);
            }
            catch (Exception ex) {
                LOGGER.error("Caught exception trying to get source URL for {} on {}", (Object)className, (Object)loader, (Object)ex);
            }
        } else {
            LOGGER.error("Cannot get source URL for null or empty class name!");
        }
        return null;
    }

    @Nullable
    public static URL getSourceURL(@Nullable Class<?> clazz) {
        if (Objects.nonNull(clazz)) {
            ProtectionDomain pd = clazz.getProtectionDomain();
            if (Objects.nonNull(pd)) {
                CodeSource source = pd.getCodeSource();
                if (Objects.nonNull(source)) {
                    return source.getLocation();
                }
                LOGGER.error("Cannot get source URL for class with null CodeSource! {}", clazz);
            } else {
                LOGGER.error("Cannot get source URL for class with null ProtectionDomain! {}", clazz);
            }
        } else {
            LOGGER.error("Cannot get source URL for null class!");
        }
        return null;
    }

    @IndirectCallers
    @Nullable
    public static String getSourceURLStr(@Nullable String className, ClassLoader loader) {
        if (Objects.nonNull(className) && !className.isEmpty()) {
            try {
                String relativePath = ClassHelper.getResourcePath(className);
                return ClassHelper.absoluteLocationStr(loader.getResource(relativePath), relativePath);
            }
            catch (Exception ex) {
                LOGGER.error("Caught exception trying to get source URL for {} on {}", (Object)className, (Object)loader, (Object)ex);
            }
        } else {
            LOGGER.error("Cannot get source URL for null or empty class name!");
        }
        return null;
    }

    @IndirectCallers
    public static String internalName(Class<?> clazz) {
        return ClassHelper.internalName(clazz.getName());
    }

    public static String internalName(String classpath) {
        return classpath.replace('.', '/');
    }

    @IndirectCallers
    public static void loadClass(String classpath, byte[] bytes) {
        ClassHelper.loadClass(ClassLoader.getSystemClassLoader(), classpath, bytes);
    }

    public static void loadClass(ClassLoader classLoader, String classpath, byte[] bytes) {
        ClassHelper.loadClass(classLoader, ClassHelper.defineClass(classLoader, classpath, bytes));
    }

    @IndirectCallers
    public static void loadClass(Class<?> clazz) {
        ClassHelper.loadClass(ClassLoader.getSystemClassLoader(), clazz);
    }

    public static void loadClass(ClassLoader classLoader, @Nullable Class<?> clazz) {
        if (Objects.nonNull(clazz)) {
            classLoader.loadClass(clazz.getName());
        } else {
            LOGGER.error("Tried to load null class to {}", (Object)classLoader);
        }
    }

    public static void loadURL(ClassLoader loader, Class<?> clazz) {
        URL source = ClassHelper.getSourceURL(clazz);
        if (!ClassHelper.loadURL((URLClassLoader)loader, source)) {
            LOGGER.error("Failed to load source for {} (URL={})", clazz, (Object)source);
        }
    }

    public static boolean loadURL(URLClassLoader classLoader, URL url) {
        TILDev.logDebug("Attempting to load URL `{}` with ClassLoader `{}`", url, classLoader);
        Hacks.invokeDirect(classLoader, "addURL", url);
        return true;
    }

    @IndirectCallers
    public static <T> T newGenericProxy(ClassLoader loader, String typeName, String namedMethod, String intermediaryMethod, Function<Object[], Object> handler) {
        return ClassHelper.newGenericProxy(loader, typeName, Hacks.isNamedEnv() ? namedMethod : intermediaryMethod, handler);
    }

    @IndirectCallers
    public static <T> T newGenericProxy(String typeName, String namedMethod, String intermediaryMethod, Function<Object[], Object> handler) {
        return ClassHelper.newGenericProxy(typeName, Hacks.isNamedEnv() ? namedMethod : intermediaryMethod, handler);
    }

    @IndirectCallers
    public static <T> T newGenericProxy(Class<T> type, String namedMethod, String intermediaryMethod, Function<Object[], Object> handler) {
        return ClassHelper.newGenericProxy(type, Hacks.isNamedEnv() ? namedMethod : intermediaryMethod, handler);
    }

    public static <T> T newGenericProxy(String typeName, String methodName, Function<Object[], Object> handler) {
        return ClassHelper.newGenericProxy(Hacks.contextClassLoader(), typeName, methodName, handler);
    }

    public static <T> T newGenericProxy(ClassLoader loader, String typeName, String methodName, Function<Object[], Object> handler) {
        return ClassHelper.newGenericProxy(loader, typeName, (Method method) -> methodName.equals(method.getName()), handler);
    }

    public static <T> T newGenericProxy(Class<T> type, String methodName, Function<Object[], Object> handler) {
        return ClassHelper.newGenericProxy(type, (Method method) -> methodName.equals(method.getName()), handler);
    }

    @IndirectCallers
    public static <T> T newGenericProxy(ClassLoader loader, String typeName, BiFunction<String, Object[], Object> handler) {
        return ClassHelper.newProxy(typeName, ClassHelper.proxyInvoker(handler));
    }

    @IndirectCallers
    public static <T> T newGenericProxy(String typeName, BiFunction<String, Object[], Object> handler) {
        return ClassHelper.newProxy(typeName, ClassHelper.proxyInvoker(handler));
    }

    @IndirectCallers
    public static <T> T newGenericProxy(Class<T> type, BiFunction<String, Object[], Object> handler) {
        return ClassHelper.newProxy(type, ClassHelper.proxyInvoker(handler));
    }

    public static <T> T newGenericProxy(ClassLoader loader, String typeName, Function<Method, Boolean> methodMatcher, Function<Object[], Object> argsHandler) {
        return ClassHelper.newProxy(loader, typeName, ClassHelper.proxyInvoker(methodMatcher, argsHandler));
    }

    @IndirectCallers
    public static <T> T newGenericProxy(String typeName, Function<Method, Boolean> methodMatcher, Function<Object[], Object> argsHandler) {
        return ClassHelper.newProxy(typeName, ClassHelper.proxyInvoker(methodMatcher, argsHandler));
    }

    public static <T> T newGenericProxy(Class<T> type, Function<Method, Boolean> methodMatcher, Function<Object[], Object> argsHandler) {
        return ClassHelper.newProxy(type, ClassHelper.proxyInvoker(methodMatcher, argsHandler));
    }

    @IndirectCallers
    public static <T> T newProxy(String typeName, InvocationHandler handler) {
        return ClassHelper.newProxy(Hacks.contextClassLoader(), typeName, handler);
    }

    public static <T> T newProxy(Class<T> type, InvocationHandler handler) {
        return ClassHelper.newProxy(type.getClassLoader(), handler, type);
    }

    public static <T> T newProxy(ClassLoader loader, String typeName, InvocationHandler handler) {
        return ClassHelper.newProxy(loader, handler, typeName);
    }

    @IndirectCallers
    public static <T> T newProxy(ClassLoader loader, Class<T> type, InvocationHandler handler) {
        return ClassHelper.newProxy(loader, handler, type);
    }

    public static <T> T newProxy(ClassLoader loader, InvocationHandler handler, Object ... typesOrNames) {
        if (Objects.isNull(typesOrNames) || typesOrNames.length == 0) {
            return ClassHelper.proxyFail(2, new Object[0]);
        }
        Class[] types = new Class[typesOrNames.length];
        for (int i = 0; i < types.length; ++i) {
            Object typeOrName = typesOrNames[i];
            if (Objects.isNull(typeOrName)) {
                return ClassHelper.proxyFail(1, new Object[]{null});
            }
            if (typeOrName instanceof Class) {
                types[i] = (Class)typeOrName;
                continue;
            }
            String typeName = String.valueOf(typeOrName);
            Class type = Hacks.findClass(typeName);
            if (Objects.isNull(type)) {
                return ClassHelper.proxyFail(1, typeName);
            }
            types[i] = type;
        }
        return ClassHelper.newProxy(loader, handler, types);
    }

    public static <T> T newProxy(ClassLoader loader, InvocationHandler handler, Class<?> ... types) {
        return Objects.nonNull(types) && types.length > 0 ? GenericUtils.cast(Proxy.newProxyInstance(loader, types, handler)) : ClassHelper.proxyFail(2, new Object[0]);
    }

    @IndirectCallers
    public static String packageName(@Nullable Class<?> clazz) {
        return Objects.nonNull(clazz) ? clazz.getPackage().getName() : "";
    }

    private static <T> T proxyFail(int failType, Object ... args) {
        switch (failType) {
            case 1: {
                LOGGER.error("Cannot create proxy! Class not found: {}", args);
            }
            case 2: {
                LOGGER.error("Cannot create proxy with null or empty types array");
            }
        }
        return null;
    }

    public static InvocationHandler proxyInvoker(Function<Method, Boolean> matcher, Function<Object[], Object> handler) {
        return ClassHelper.proxyInvoker(true, matcher, handler);
    }

    public static InvocationHandler proxyInvoker(boolean handleDefault, Function<Method, Boolean> matcher, Function<Object[], Object> handler) {
        return ClassHelper.proxyInvokerWrappedHandle(handleDefault, (method, args) -> (Boolean)matcher.apply((Method)method) != false ? handler.apply((Object[])args) : null);
    }

    public static InvocationHandler proxyInvoker(BiFunction<String, Object[], Object> handler) {
        return ClassHelper.proxyInvoker(true, handler);
    }

    public static InvocationHandler proxyInvoker(boolean handleDefault, BiFunction<String, Object[], Object> handler) {
        return ClassHelper.proxyInvokerWrappedHandle(handleDefault, (method, args) -> handler.apply(method.getName(), (Object[])args));
    }

    @IndirectCallers
    public static InvocationHandler proxyInvokerWrappedHandle(BiFunction<Method, Object[], Object> handler) {
        return ClassHelper.proxyInvokerWrappedHandle(true, handler);
    }

    public static InvocationHandler proxyInvokerWrappedHandle(boolean handleDefault, BiFunction<Method, Object[], Object> handler) {
        return handleDefault ? (instance, method, args) -> {
            switch (method.getName()) {
                case "equals": {
                    return args.length > 0 && instance == args[0];
                }
                case "hashCode": {
                    return 0;
                }
                case "toString": {
                    return instance.toString();
                }
            }
            return handler.apply(method, args);
        } : (instance, method, args) -> handler.apply(method, args);
    }

    public static Class<?> resolveClass(ClassLoader loader, @Nullable Class<?> clazz) {
        if (Objects.isNull(clazz)) {
            LOGGER.fatal("Cannot resolve null defined class! (ClassLoader = {})", (Object)loader);
            return null;
        }
        return (Class)Hacks.checkBurningWaveInitAndCall("loadOrDefineClass", clazz, loader);
    }

    @IndirectCallers
    public static void setPackageSelfVersion(Class<?> c) {
        ClassHelper.setPackageVersion(c, "0.4.6");
    }

    public static void setPackageSelfVersion(Package pkg) {
        ClassHelper.setPackageVersion(pkg, "0.4.6");
    }

    public static void setPackageVersion(Class<?> c, String version) {
        ClassHelper.setPackageVersion(c.getPackage(), version);
    }

    public static void setPackageVersion(Package pkg, String version) {
        if (JVMHelper.isJava8()) {
            ClassHelper.setPackageVersionJava8(pkg, version);
        } else {
            ClassHelper.setPackageVersionInfo(pkg, null, null, null, null, version, null, null);
        }
    }

    @IndirectCallers
    public static void setPackageVersionInfo(Class<?> c, Object ... args) {
        ClassHelper.setPackageVersionInfo(c.getPackage(), args);
    }

    public static void setPackageVersionInfo(Package pkg, Object ... args) {
        if (JVMHelper.isJava8()) {
            ClassHelper.setPackageVersionInfoJava8(pkg, args);
        } else {
            Hacks.setFieldDirect(pkg, "versionInfo", Hacks.construct(PACKAGE_VERSION_INFO, args));
        }
    }

    private static void setPackageVersionInfoJava8(Package pkg, Object ... args) {
        String[] fieldTypes = new String[]{"spec", "impl"};
        String[] fieldNames = new String[]{"Title", "Version", "Vendor"};
        for (int t = 0; t < fieldTypes.length; ++t) {
            for (int n = 0; n < fieldNames.length; ++n) {
                int argIndex = 3 * t + n;
                Hacks.setFieldDirect(pkg, fieldTypes[t] + fieldNames[n], args.length > argIndex ? args[argIndex] : null);
            }
        }
    }

    private static void setPackageVersionJava8(Package pkg, String version) {
        Hacks.setFieldDirect(pkg, "implVersion", version);
    }

    @IndirectCallers
    public static String signature(Class<?> clazz, Class<?> ... parameters) {
        return ClassHelper.signatureDesc(ClassHelper.descriptor(clazz), ArrayHelper.mapTo(parameters, String.class, ClassHelper::descriptor));
    }

    @IndirectCallers
    public static String signatureClasspath(String classpath, String ... parameterPaths) {
        return ClassHelper.signatureDesc(ClassHelper.descriptor(classpath), ArrayHelper.mapTo(parameterPaths, String.class, ClassHelper::descriptor));
    }

    public static String signatureDesc(String desc, String ... parameterDescs) {
        if (TextHelper.isBlank(desc)) {
            return "";
        }
        StringBuilder builder = new StringBuilder(desc.substring(0, desc.length() - 1)).append("<");
        if (ArrayHelper.isNotEmpty(parameterDescs)) {
            for (String parameter : parameterDescs) {
                builder.append(parameter);
            }
        }
        return builder.append(">;").toString();
    }

    @IndirectCallers
    public static String signatureInternal(String name, String ... parameterNames) {
        if (TextHelper.isBlank(name)) {
            return "";
        }
        return ClassHelper.signatureDesc("L" + name + ";", ArrayHelper.mapTo(parameterNames, String.class, p -> "L" + p + ";"));
    }

    @IndirectCallers
    public static void syncSourcesAndLoadClass(ClassLoader syncFrom, ClassLoader syncTo, String className, BiFunction<ClassLoader, URL, Boolean> urlLoader) {
        ClassHelper.syncSourcesForClass(syncFrom, syncTo, className, urlLoader, className);
    }

    public static Class<?> syncDirect(ClassLoader loader, Class<?> clazz) {
        TILDev.logInfo("Attempting direct sync of {} to {}", clazz, loader);
        if (loader == clazz.getClassLoader()) {
            LOGGER.error("Tried to sync {} to its own loader", clazz);
            return clazz;
        }
        return ClassHelper.resolveClass(loader, ClassHelper.defineClass(loader, clazz.getName(), ClassHelper.getClassBytes(clazz)));
    }

    public static void syncSourcesForClass(ClassLoader syncFrom, ClassLoader syncTo, String className, BiFunction<ClassLoader, URL, Boolean> urlLoader, String ... classesToLoad) {
        try {
            LOGGER.debug("Attempting to sync class loaders for {} ({} -> {})", (Object)className, (Object)syncFrom, (Object)syncTo);
            URL url = ClassHelper.getSourceURL(syncFrom.loadClass(className));
            if (Objects.nonNull(url)) {
                LOGGER.debug("Syncing URL {}", (Object)url);
                if (!urlLoader.apply(syncTo, url).booleanValue()) {
                    LOGGER.error("Failed to sync sources for {} from {} to {}!", (Object)className, (Object)syncFrom, (Object)syncTo);
                } else if (Objects.nonNull(classesToLoad)) {
                    for (String classToLoad : classesToLoad) {
                        Hacks.findClass(classToLoad, syncTo);
                    }
                }
            } else {
                LOGGER.debug("Not syncing null URL");
            }
        }
        catch (ClassNotFoundException ex) {
            ClassLoader systemLoader = ClassLoader.getSystemClassLoader();
            if (Misc.equalsAny(systemLoader, syncFrom, syncTo)) {
                LOGGER.error("Failed to sync sources for {} from {} to {}!", (Object)className, (Object)syncFrom, (Object)syncTo, (Object)ex);
            }
            ClassHelper.syncSourcesForClass(systemLoader, syncTo, className, urlLoader, classesToLoad);
        }
    }

    public static void verifyPackageSelfVersion(Package pkg) {
        ClassHelper.verifyPackageVersion(pkg, "0.4.6");
    }

    public static void verifyPackageVersion(Package pkg, String defaultVersion) {
        if (Objects.isNull(pkg.getImplementationVersion())) {
            LOGGER.debug("Setting missing implementation version for {}", (Object)pkg);
            ClassHelper.setPackageVersion(pkg, defaultVersion);
        }
    }

    @IndirectCallers
    public static String withPkgName(@Nullable Class<?> ref, String simpleName) {
        return ClassHelper.withPkgName(Objects.nonNull(ref) ? ref.getPackage() : null, simpleName);
    }

    public static String withPkgName(@Nullable Package pkg, String simpleName) {
        simpleName = Objects.nonNull(simpleName) ? simpleName.replace(" ", "").replace('/', '.') : null;
        return Objects.nonNull(pkg) && TextHelper.isNotBlank(pkg.getName()) ? pkg.getName() + "." + simpleName : simpleName;
    }
}

