/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.core;

import java.lang.management.ManagementFactory;
import java.util.List;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import org.apache.logging.log4j.Logger;

public class JVMHelper {
    static final List<String> JVM_FLAGS = ManagementFactory.getRuntimeMXBean().getInputArguments();
    static final boolean COMPACT_OBJECT_HEADERS = JVM_FLAGS.contains("UseCompactObjectHeaders");
    static final int FALLBACK_JAVA_VERSION = 17;
    static final String JAVA_VERSION = System.getProperty("java.version");
    static final int MAX_JAVA_VERSION = 25;
    static final Logger LOGGER = TILRef.createLogger("TIL JVMHelper");
    static int javaVersionCache;

    public static boolean hasNativeAccess() {
        return JVMHelper.isVersionLessThan(25) && !COMPACT_OBJECT_HEADERS;
    }

    public static boolean isJava8() {
        return JVMHelper.isJava8(true);
    }

    public static boolean isJava8(boolean strict) {
        return strict ? JVMHelper.isVersion(8) : JVMHelper.isVersionAtLeast(8);
    }

    public static boolean isJava17() {
        return JVMHelper.isJava17(false);
    }

    public static boolean isJava17(boolean strict) {
        return strict ? JVMHelper.isVersion(17) : JVMHelper.isVersionAtLeast(17);
    }

    public static boolean isJava21() {
        return JVMHelper.isJava21(false);
    }

    public static boolean isJava21(boolean strict) {
        return strict ? JVMHelper.isVersion(21) : JVMHelper.isVersionAtLeast(21);
    }

    @IndirectCallers
    public static boolean isJava25() {
        return JVMHelper.isJava25(false);
    }

    public static boolean isJava25(boolean strict) {
        return strict ? JVMHelper.isVersion(25) : JVMHelper.isVersionAtLeast(25);
    }

    public static boolean isVersion(int version) {
        return JVMHelper.version() == version;
    }

    public static boolean isVersionAtLeast(int version) {
        return JVMHelper.version() >= version;
    }

    @IndirectCallers
    public static boolean isVersionAtMost(int version) {
        return JVMHelper.version() <= version;
    }

    @IndirectCallers
    public static boolean isVersionGreaterThan(int version) {
        return JVMHelper.version() > version;
    }

    public static boolean isVersionLessThan(int version) {
        return JVMHelper.version() < version;
    }

    public static int version() {
        if (javaVersionCache > 0) {
            return javaVersionCache;
        }
        javaVersionCache = 17;
        LOGGER.info("Parsing Java version from {}", (Object)JAVA_VERSION);
        if (JAVA_VERSION.startsWith("1.")) {
            javaVersionCache = 8;
        } else {
            String majorVersion = JAVA_VERSION.split("\\.")[0].split("_")[0];
            try {
                javaVersionCache = Integer.parseInt(majorVersion);
            }
            catch (Exception ex) {
                LOGGER.error("Failed to parse Java version from {} (split={})", (Object)majorVersion, (Object)JAVA_VERSION, (Object)ex);
            }
        }
        if (javaVersionCache > 25) {
            throw new RuntimeException("The Impossible Library is not yet compatible with Java " + javaVersionCache + "! Please ensure that you are using Java " + 25 + " or earlier.");
        }
        return javaVersionCache;
    }
}

