/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.core.bootstrap;

import java.lang.reflect.Method;
import java.util.Objects;
import java.util.function.Function;
import mods.thecomputerizer.theimpossiblelibrary.api.core.ClassHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.Hacks;
import mods.thecomputerizer.theimpossiblelibrary.api.core.bootstrap.TILLauncher;
import mods.thecomputerizer.theimpossiblelibrary.api.core.bootstrap.TILLauncherRef;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public abstract class TILForgeLikeServiceLauncher {
    public static final String HACKS = "mods.thecomputerizer.theimpossiblelibrary.api.core.Hacks";
    static TILForgeLikeServiceLauncher instance;
    final ClassLoader bootLoader;
    final String loader;
    protected final Logger logger;

    private static Class<?> bootClass(String target, boolean useHacks) throws Throwable {
        return TILForgeLikeServiceLauncher.findClass(target, useHacks, TILForgeLikeServiceLauncher.bootLoader());
    }

    protected static ClassLoader bootLoader() {
        return TILForgeLikeServiceLauncher.instance.bootLoader;
    }

    @Nullable
    protected static Object callMethod(@Nullable Method m, @Nullable Object target, Object ... args) {
        if (Objects.isNull(m)) {
            TILForgeLikeServiceLauncher.instance.logger.warn("Tried to invoke null Method object on {} with args {}", target, (Object)args);
            return null;
        }
        try {
            return m.invoke(target, args);
        }
        catch (Throwable t) {
            TILForgeLikeServiceLauncher.instance.logger.fatal("Failed to invoke {} on target {} with args {}!", (Object)m, target, (Object)args, (Object)t);
            return null;
        }
    }

    private static void checkHacksInit(boolean direct) {
        TILForgeLikeServiceLauncher.checkHacksInit(direct, TILForgeLikeServiceLauncher.bootLoader());
    }

    public static void checkHacksInit(boolean direct, ClassLoader loader) {
        if (direct) {
            Hacks.checkBurningWaveInit();
            return;
        }
        try {
            TILForgeLikeServiceLauncher.callMethod(TILForgeLikeServiceLauncher.getMethod(TILForgeLikeServiceLauncher.findClass(HACKS, false, loader), "checkBurningWaveInit", new Class[0]), null, new Object[0]);
        }
        catch (Throwable t) {
            TILForgeLikeServiceLauncher.instance.logger.fatal("Failed to invoke {}#checkBurningWaveInit in the BOOT layer!", (Object)HACKS, (Object)t);
        }
    }

    private static Class<?> findClass(String target, boolean useHacks, ClassLoader loader) throws Throwable {
        if (useHacks) {
            TILForgeLikeServiceLauncher.checkHacksInit(false);
            return Hacks.findClass(target, loader, true);
        }
        return Class.forName(target, true, loader);
    }

    @Nullable
    protected static Method getMethod(Class<?> c, String name, Class<?> ... argTypes) {
        try {
            return c.getDeclaredMethod(name, argTypes);
        }
        catch (Throwable declaredT) {
            TILForgeLikeServiceLauncher.instance.logger.debug("Declared method {} not found in {}! Checking for inherited method");
            try {
                return c.getMethod(name, argTypes);
            }
            catch (Throwable t) {
                TILForgeLikeServiceLauncher.instance.logger.error("Method {} not found in {} with args {}", (Object)name, c, argTypes, (Object)t);
                TILForgeLikeServiceLauncher.instance.logger.error("Declared method stacktrace", declaredT);
                return null;
            }
        }
    }

    public static void init(Class<?> caller, Class<?> instanceClass, boolean serviceLoaded) {
        TILForgeLikeServiceLauncher.printClassInit(instanceClass, serviceLoaded);
        try {
            instanceClass.getConstructor(Class.class).newInstance(caller);
        }
        catch (Throwable t) {
            System.err.println("Failed to initialize SERVICE launcher " + instanceClass);
            t.printStackTrace(System.err);
        }
    }

    protected static boolean java8() {
        return System.getProperty("java.version").startsWith("1.");
    }

    static Function<TILLauncher, Boolean> launcherCheck(String loader) {
        return "Forge".equals(loader) ? TILLauncher::isActiveForge : TILLauncher::isActiveNeoforge;
    }

    static void printClassInit(Class<?> c, boolean serviceLoaded) {
        System.out.println("[" + (serviceLoaded ? "SERVICE" : "BOOT") + "] Class init: " + c.getName());
    }

    protected static Class<?> thisClass() {
        return instance.getClass();
    }

    protected static ClassLoader thisClassLoader() {
        return TILForgeLikeServiceLauncher.thisClass().getClassLoader();
    }

    protected TILForgeLikeServiceLauncher(@Nullable ClassLoader bootLoader, String loader) {
        instance = this;
        this.bootLoader = Objects.nonNull(bootLoader) ? bootLoader : ClassLoader.getSystemClassLoader();
        this.loader = loader;
        this.logger = this.initLogger();
    }

    boolean bootLoaded() {
        return this.bootLoader == TILForgeLikeServiceLauncher.thisClassLoader();
    }

    protected abstract String coreLoader();

    boolean handleServiceEntryPoint() {
        if (TILForgeLikeServiceLauncher.java8()) {
            this.logger.info("I see you are running Java 8. Good choice, but I'll be using burningwave anyways");
            try {
                TILForgeLikeServiceLauncher.checkHacksInit(true);
                ClassHelper.loadURL(this.bootLoader, TILForgeLikeServiceLauncher.thisClass());
                return true;
            }
            catch (Throwable t) {
                this.logger.fatal("Failed to handle Java 8 entrypoint??", t);
                return false;
            }
        }
        this.logger.info("I see you are running Java 9+ so I'll be using burningwave to break its strong encapsulation");
        try {
            TILForgeLikeServiceLauncher.checkHacksInit(true);
            this.logger.info("Initialized hacks");
            String moduleName = this.moduleName(TILForgeLikeServiceLauncher.thisClass());
            if (Objects.nonNull(moduleName)) {
                this.logger.info("Module name is {}", (Object)moduleName);
                this.moveModule(moduleName);
                this.logger.info("Moved module {} to the BOOT layer", (Object)moduleName);
                return true;
            }
            this.logger.info("Null module?");
        }
        catch (Throwable t) {
            System.err.println("Entrypoint handling for the SERVICE layer failed!");
            t.printStackTrace(System.err);
            return false;
        }
        this.logger.error("Entrypoint handling for the SERVICE layer failed without a stacktrace??");
        return false;
    }

    protected final void initCoreAPI(Class<?> caller) {
        if (Objects.nonNull(this.initCoreAPI())) {
            TILForgeLikeServiceLauncher.checkHacksInit(true);
            this.setModLoadingVersion(caller);
        } else {
            this.logger.error("Failed to initialized {} CoreAPI instance in the BOOT layer!", (Object)this.loader);
        }
    }

    protected abstract Object initCoreAPI();

    Logger initLogger() {
        if (Objects.isNull(TILLauncherRef.launcher)) {
            TILForgeLikeServiceLauncher.launcherCheck(this.loader).apply(TILLauncher.init(this.bootLoaded()));
        }
        return TILLauncherRef.launcher.getLogger();
    }

    protected final void load(Class<?> caller) {
        if (this.bootLoaded()) {
            this.initCoreAPI(caller);
            return;
        }
        this.logger.info("Handling SERVICE layer launcher");
        if (!this.handleServiceEntryPoint()) {
            return;
        }
        try {
            String initMethod = "initCoreAPI";
            this.logger.info("Calling Hacks$invokeStatic for method '{}'", (Object)initMethod);
            String coreLoader = this.coreLoader();
            this.logger.info("Core loader is {}", (Object)coreLoader);
            this.logger.info("Full call for Hacks$invokeStatic is {}#{}", (Object)coreLoader, (Object)initMethod);
            Class<?> bootClass = TILForgeLikeServiceLauncher.bootClass(coreLoader, true);
            this.logger.info("Found boot {}", bootClass);
            if (Objects.nonNull(TILForgeLikeServiceLauncher.callMethod(TILForgeLikeServiceLauncher.getMethod(bootClass, initMethod, new Class[0]), null, new Object[0]))) {
                if (TILForgeLikeServiceLauncher.java8()) {
                    this.setModLoadingVersion(caller);
                } else {
                    this.logger.info("Successfully handled SERVICE layer initialization");
                }
            } else {
                this.logger.fatal("CoreAPI failed to initialize from {}#{}!", (Object)coreLoader, (Object)initMethod);
            }
        }
        catch (Throwable t) {
            this.logger.fatal("Failed to initialize BOOT layer CoreAPI instance", t);
        }
    }

    protected abstract String modLoading();

    protected abstract String moduleName(Class<?> var1);

    protected abstract void moveModule(String var1);

    void setModLoadingVersion(Class<?> caller) {
        try {
            Method m = TILForgeLikeServiceLauncher.getMethod(TILForgeLikeServiceLauncher.bootClass(this.modLoading(), false), "setLoadingVersion", Class.class);
            if (!Boolean.parseBoolean(String.valueOf(TILForgeLikeServiceLauncher.callMethod(m, null, caller)))) {
                throw new RuntimeException("Failed to set mod loading version for " + caller);
            }
        }
        catch (Throwable t) {
            this.logger.fatal("Failed to set version for mod loading!", t);
        }
    }
}

