/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.core.bootstrap;

import java.util.EnumSet;
import lombok.Generated;
import mods.thecomputerizer.theimpossiblelibrary.api.core.Hacks;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.bootstrap.TILLauncherRef;
import org.apache.logging.log4j.Logger;

public class TILLauncher {
    protected static final boolean DEV = Boolean.parseBoolean(System.getProperty("til.dev", "false"));
    protected static final boolean MODULES = !System.getProperty("java.version").startsWith("1.");
    protected final String activeLoader = this.validate(TILLauncher.fmlLoader("minecraftforge")) ? "forge" : (this.validate(TILLauncher.fmlLoader("neoforged")) ? "neoforge" : "");
    protected final Logger logger = TILRef.createLogger("The Impossible Loader" + (this.isActive() ? " (" + this.activeLoaderExt() + ")" : ""));

    protected static String fmlLoader(String loaderPkg) {
        return "net." + loaderPkg + ".fml.loading.FMLLoader";
    }

    public static TILLauncher init(boolean withHacks) {
        return new TILLauncher(withHacks);
    }

    protected static <E extends Enum<E>> EnumSet<E> none(Class<E> enumClass) {
        return EnumSet.noneOf(enumClass);
    }

    protected TILLauncher(boolean withHacks) {
        this.logger.info("Created {}active {} launch plugin", (Object)(this.isActive() ? "" : "in"), (Object)(withHacks ? "BOOT" : "SERVICE"));
        if (withHacks) {
            Hacks.checkBurningWaveInit();
            if (DEV) {
                Hacks.removeEnvironmentProperty("MOD_CLASSES");
            }
        }
        TILLauncherRef.launcher = this;
    }

    String activeLoaderExt() {
        return this.activeLoader.substring(0, 1).toUpperCase() + this.activeLoader.substring(1);
    }

    boolean isActive() {
        return !this.activeLoader.isEmpty();
    }

    boolean isActive(String loader) {
        return loader.equals(this.activeLoader);
    }

    public boolean isActiveForge() {
        return this.isActive("forge");
    }

    public boolean isActiveNeoforge() {
        return this.isActive("neoforge");
    }

    public String name() {
        return "theimpossibleloader";
    }

    private boolean validate(String validator) {
        ClassLoader thisClassLoader = this.getClass().getClassLoader();
        try {
            Class.forName(validator, false, thisClassLoader);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    @Generated
    public Logger getLogger() {
        return this.logger;
    }

    static {
        System.out.println("Class init: " + TILLauncher.class.getName());
    }
}

