/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.io;

import java.util.Objects;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public interface LoggableAPI {
    @IndirectCallers
    default public void log(Level level, String msg, Object ... args) {
        if (Objects.isNull(level)) {
            return;
        }
        switch (level.name()) {
            case "DEBUG": {
                this.logDebug(msg, args);
                return;
            }
            case "ERROR": {
                this.logError(msg, args);
                return;
            }
            case "FATAL": {
                this.logFatal(msg, args);
                return;
            }
            case "INFO": {
                this.logInfo(msg, args);
                return;
            }
            case "TRACE": {
                this.logTrace(msg, args);
                return;
            }
            case "WARN": {
                this.logWarn(msg, args);
                return;
            }
        }
        Logger logger = this.logger();
        if (Objects.nonNull(logger)) {
            logger.log(level, msg, args);
        }
    }

    public void logDebug(String var1, Object ... var2);

    public void logError(String var1, Object ... var2);

    public void logFatal(String var1, Object ... var2);

    public void logInfo(String var1, Object ... var2);

    public void logTrace(String var1, Object ... var2);

    public void logWarn(String var1, Object ... var2);

    public Logger logger();
}

