/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.network.message;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;
import mods.thecomputerizer.theimpossiblelibrary.api.core.ClassHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreStateAccessor;
import mods.thecomputerizer.theimpossiblelibrary.api.core.Hacks;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILDev;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.network.NetworkHandler;
import mods.thecomputerizer.theimpossiblelibrary.api.network.NetworkHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.network.message.MessageAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.network.message.MessageDirectionInfo;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.util.GenericUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MessageWrapperAPI<PLAYER, CTX>
implements CoreStateAccessor {
    private static final String FORGE_NETWORK_HELPER = "mods.thecomputerizer.theimpossiblelibrary.forge.network.ForgeNetworkHelper";
    private static Class<?> FORGE_NETWORK_HELPER_CLASS;
    private boolean debug = TILDev.DEBUG_NETWORK;
    private Collection<MessageAPI<CTX>> messages;
    private Collection<PLAYER> players;
    private Collection<Class<?>> missingDecoders;
    protected MessageDirectionInfo<?> info;

    public static <DIR> DIR classToDir(Class<?> msgCls) {
        if (Client.class == msgCls) {
            return NetworkHelper.getDirToClient();
        }
        if (ClientLogin.class == msgCls) {
            return NetworkHelper.getDirToClientLogin();
        }
        if (Server.class == msgCls) {
            return NetworkHelper.getDirToServer();
        }
        if (ServerLogin.class == msgCls) {
            return NetworkHelper.getDirToServerLogin();
        }
        TILRef.logError("Cannot get direction for unknown MessageWrapperAPI extension class! {}", msgCls);
        return null;
    }

    @NotNull
    public static <DIR, P, C, B extends ByteBuf> Function<B, MessageWrapperAPI<P, C>> decoder(MessageDirectionInfo<DIR> dir) {
        return Objects.nonNull(dir) ? MessageWrapperAPI.innerDecoder(dir.getDirection()) : buf -> null;
    }

    @NotNull
    public static <P, C, B extends ByteBuf> Function<B, MessageWrapperAPI<P, C>> decoder(Class<?> msgClass) {
        return buf -> {
            Function wrappedDecoder = MessageWrapperAPI.innerDecoder(MessageWrapperAPI.classToDir(msgClass));
            return wrappedDecoder.apply(buf);
        };
    }

    @NotNull
    public static <P, C, B extends ByteBuf> BiConsumer<MessageWrapperAPI<P, C>, B> encoder() {
        return MessageWrapperAPI::encode;
    }

    public static <DIR, P, C> Class<MessageWrapperAPI<P, C>> getClass(MessageDirectionInfo<DIR> dir) {
        if (Objects.isNull(dir)) {
            if (TILDev.DEBUG_NETWORK) {
                TILRef.logWarn("Tried to call MessageWrapperAPI#getClass with null direction info!", new Object[0]);
            }
            return null;
        }
        return MessageWrapperAPI.getClass(dir.getDirection());
    }

    public static <DIR, P, C> Class<MessageWrapperAPI<P, C>> getClass(DIR dir) {
        if (Objects.isNull(dir)) {
            if (TILDev.DEBUG_NETWORK) {
                TILRef.logWarn("Tried to call MessageWrapperAPI#getClass with null direction!", new Object[0]);
            }
            return null;
        }
        boolean client = NetworkHelper.isDirToClient(dir);
        boolean login = NetworkHelper.isDirLogin(dir);
        Class cls = login ? (client ? ClientLogin.class : ServerLogin.class) : (client ? Client.class : Server.class);
        return (Class)GenericUtils.cast(cls);
    }

    @Nullable
    private static Class<?> getForgeHelperClass() {
        if (Objects.nonNull(FORGE_NETWORK_HELPER_CLASS)) {
            return FORGE_NETWORK_HELPER_CLASS;
        }
        FORGE_NETWORK_HELPER_CLASS = Hacks.findClass(FORGE_NETWORK_HELPER);
        return FORGE_NETWORK_HELPER_CLASS;
    }

    public static <DIR, P, C> MessageWrapperAPI<P, C> getInstance(MessageDirectionInfo<DIR> dir) {
        if (Objects.isNull(dir)) {
            if (TILDev.DEBUG_NETWORK) {
                TILRef.logWarn("Tried to call MessageWrapperAPI#getInstance(dir) with null direction info!", new Object[0]);
            }
            return null;
        }
        return MessageWrapperAPI.getInstance(dir.getDirection());
    }

    public static <DIR, P, C> MessageWrapperAPI<P, C> getInstance(DIR dir) {
        if (Objects.isNull(dir)) {
            if (TILDev.DEBUG_NETWORK) {
                TILRef.logWarn("Tried to call MessageWrapperAPI#getInstance(dir) with null direction!", new Object[0]);
            }
            return null;
        }
        boolean client = NetworkHelper.isDirToClient(dir);
        boolean login = NetworkHelper.isDirLogin(dir);
        return login ? (client ? new ClientLogin() : new ServerLogin()) : (client ? new Client() : new Server());
    }

    public static <DIR, P, C, B extends ByteBuf> MessageWrapperAPI<P, C> getInstance(MessageDirectionInfo<DIR> dir, B buf) {
        if (Objects.isNull(dir)) {
            if (TILDev.DEBUG_NETWORK) {
                TILRef.logWarn("Tried to call MessageWrapperAPI#getInstance(dir,buf) with null direction info!", new Object[0]);
            }
            return null;
        }
        return MessageWrapperAPI.getInstance(dir.getDirection(), buf);
    }

    public static <DIR, P, C, B extends ByteBuf> MessageWrapperAPI<P, C> getInstance(DIR dir, B buf) {
        if (Objects.isNull(dir)) {
            if (TILDev.DEBUG_NETWORK) {
                TILRef.logWarn("Tried to call MessageWrapperAPI#getInstance(dir,buf) with null direction!", new Object[0]);
            }
            return null;
        }
        if (TILDev.DEBUG_NETWORK) {
            TILRef.logInfo("Decoding message for {}", dir);
        }
        boolean client = NetworkHelper.isDirToClient(dir);
        boolean login = NetworkHelper.isDirLogin(dir);
        return login ? (client ? new ClientLogin(buf) : new ServerLogin(buf)) : (client ? new Client(buf) : new Server(buf));
    }

    @NotNull
    public static <DIR, P, C, S> BiConsumer<MessageWrapperAPI<P, C>, S> handler(MessageDirectionInfo<DIR> dir, Function<S, C> contextGetter, Function<C, P> playerGetter) {
        return MessageWrapperAPI.handler(Objects.nonNull(dir) ? (DIR)dir.getDirection() : null, contextGetter, playerGetter);
    }

    @NotNull
    public static <DIR, P, C, S> BiConsumer<MessageWrapperAPI<P, C>, S> handler(DIR dir, Function<S, C> contextGetter, Function<C, P> playerGetter) {
        return (message, contextHolder) -> {
            Object context = contextGetter.apply(contextHolder);
            MessageWrapperAPI response = message.handle(context);
            if (Objects.nonNull(response) && Objects.nonNull(dir)) {
                if (NetworkHelper.isDirToClient(response.getDir())) {
                    response.setPlayer(playerGetter.apply(context)).send();
                } else {
                    response.send();
                }
            }
            if (CoreAPI.legacyPacketEnv()) {
                Hacks.invoke(context, "setPacketHandled", true);
            }
        };
    }

    @NotNull
    public static <DIR, P, C, B extends ByteBuf> Function<B, MessageWrapperAPI<P, C>> innerDecoder(DIR dir) {
        if (Objects.isNull(dir)) {
            return buf -> null;
        }
        return buf -> (MessageWrapperAPI)GenericUtils.cast(MessageWrapperAPI.getInstance(dir, buf));
    }

    private static void invokeForgeHelper(String method, Object ... args) {
        if (!FORGE) {
            return;
        }
        Class<?> forgeHelper = MessageWrapperAPI.getForgeHelperClass();
        if (Objects.isNull(forgeHelper) || TextHelper.isBlank(method)) {
            TILRef.logError("Cannot invoke Forge network helper method {}#{} (args={})", FORGE_NETWORK_HELPER, method, args);
            return;
        }
        Hacks.invokeStatic(forgeHelper, method, args);
    }

    protected MessageWrapperAPI() {
    }

    protected MessageWrapperAPI(ByteBuf buf) {
        this.info = NetworkHandler.getDirectionInfo(NetworkHelper.readDir(buf));
        this.decode(buf);
    }

    public void decode(ByteBuf buf) {
        this.debug = buf.readBoolean();
        if (this.debug) {
            TILRef.logInfo("[Direction={}]: Decoding messages for type: {}", this.dirName(), this.getClass());
        }
        AtomicBoolean failure = new AtomicBoolean();
        this.messages = NetworkHelper.readCollection(buf, () -> this.decodeMessage(buf, failure));
        if (failure.get()) {
            if (this.decodingFailure(buf, failure)) {
                if (this.debug) {
                    TILRef.logInfo("[Direction={}]: Successfully resolved & decoded {} messages for type: {}", this.dirName(), this.messages.size(), this.getClass());
                }
            } else {
                TILRef.logError("[Direction={}]: Failed to decode all messages for {}", this.dirName(), this.getClass());
            }
        } else if (this.debug) {
            TILRef.logInfo("[Direction={}]: Successfully decoded {} messages for type: {}", this.dirName(), this.messages.size(), this.getClass());
        }
    }

    @Nullable
    protected MessageAPI<CTX> decodeMessage(ByteBuf buf, AtomicBoolean failure) {
        if (failure.get()) {
            return null;
        }
        String name = NetworkHelper.readString(buf);
        if (Objects.isNull(this.info)) {
            TILRef.logError("Tried to decode class {} but direction info for {} is null!", name, this.getClass());
            return null;
        }
        if (this.debug) {
            TILRef.logInfo("[Direction={}]: Decoding message type name: {}", this.dirName(), name);
        }
        return this.decodeMessage(buf, ClassHelper.findExtensibleClass(name, MessageAPI.class), failure);
    }

    @Nullable
    protected MessageAPI<CTX> decodeMessage(ByteBuf buf, Class<?> msgClass, AtomicBoolean failure) {
        MessageAPI<CTX> decoded;
        if (failure.get()) {
            return null;
        }
        if (this.debug) {
            TILRef.logInfo("[Direction={}]: Decoding message type: {}", this.dirName(), msgClass);
        }
        MessageAPI<CTX> messageAPI = decoded = Objects.nonNull(msgClass) ? (MessageAPI<CTX>)this.info.decode(msgClass, buf) : null;
        if (Objects.isNull(decoded)) {
            this.markMissingDecoder(msgClass, buf, failure);
        } else if (this.debug) {
            TILRef.logInfo("[Direction={}]: Successfully decoded message type: {}", this.dirName(), msgClass);
        }
        return decoded;
    }

    private boolean decodingFailure(ByteBuf buf, AtomicBoolean failure) {
        Class failedClass = this.getOrInitMissingDecoders().stream().findFirst().orElse(null);
        if (Objects.isNull(failedClass)) {
            TILRef.logError("Attempted to address a message decoding failure but no failed message class was found! (wrapper={})", this.getClass());
            return false;
        }
        return this.decodingFailure(buf, failedClass, failure);
    }

    private boolean decodingFailure(ByteBuf buf, Class<?> failedClass, AtomicBoolean failure) {
        MessageAPI<CTX> failed;
        AtomicInteger removals = new AtomicInteger();
        this.messages.removeIf(msg -> {
            if (Objects.isNull(msg)) {
                removals.incrementAndGet();
                return true;
            }
            return false;
        });
        failure.set(false);
        int failures = removals.decrementAndGet();
        if (failures < 0) {
            TILRef.logError("Attempted to address a message decoding failure for {} but no failed messages were found! (wrapper={})", failedClass, this.getClass());
            return true;
        }
        MessageAPI<CTX> messageAPI = failed = Objects.nonNull(failedClass) ? this.decodeMessage(buf, failedClass, failure) : null;
        if (Objects.isNull(failed)) {
            TILRef.logError("Failed to decode message {} for the 2nd time! Remaining messages will now be dropped!", failedClass);
            return false;
        }
        this.markFoundMissingDecoder(failedClass);
        for (int i = 0; i < failures; ++i) {
            MessageAPI<CTX> decoded = this.decodeMessage(buf, failure);
            if (Objects.nonNull(decoded)) {
                this.messages.add(decoded);
                continue;
            }
            if (failure.get()) break;
        }
        return !failure.get() || this.decodingFailure(buf, failure);
    }

    protected String dirName() {
        if (Objects.isNull(this.info)) {
            return "[NULL DIRECTION INFO]";
        }
        Object direction = this.info.getDirection();
        if (Objects.isNull(direction)) {
            return "[NULL DIRECTION]";
        }
        return direction instanceof Enum ? ((Enum)direction).name() : direction.toString();
    }

    @IndirectCallers
    public void disableDebug() {
        this.debug = false;
    }

    @IndirectCallers
    public void enableDebug() {
        this.debug = true;
    }

    public void encode(ByteBuf buf) {
        if (Objects.isNull(this.messages)) {
            this.messages = Collections.emptyList();
        }
        if (this.debug) {
            TILRef.logInfo("[Direction={}]: Encoding {} messages for type: {}", this.dirName(), this.messages.size(), this.getClass());
        }
        NetworkHelper.writeDir(buf, this.info.getDirection());
        buf.writeBoolean(this.debug);
        NetworkHelper.writeCollection(buf, this.messages, message -> {
            if (this.debug) {
                TILRef.logInfo("[Direction={}]: Encoding message: {}", this.dirName(), message.getClass());
            }
            String className = message.getClass().getName();
            NetworkHelper.writeString(buf, className);
            if (Objects.isNull(this.info)) {
                TILRef.logError("Tried to encode class {} but direction info for {} is null!", className, this.getClass());
            } else {
                this.info.encode(message, buf);
            }
            if (this.debug) {
                TILRef.logInfo("[Direction={}]: Successfully encoded message: {}", this.dirName(), message.getClass());
            }
        });
        if (this.debug) {
            TILRef.logInfo("[Direction={}]: Successfully encoded {} messages for type: {}", this.dirName(), this.messages.size(), this.getClass());
        }
    }

    @Nullable
    protected <DIR> DIR getDir() {
        return Objects.nonNull(this.info) ? (DIR)GenericUtils.cast(this.info.getDirection()) : null;
    }

    @IndirectCallers
    @Nullable
    protected Collection<Class<?>> getMissingDecoders() {
        return this.missingDecoders;
    }

    @Nullable
    protected <DIR> DIR getOppositeDir() {
        DIR curDir = this.getDir();
        return Objects.nonNull(curDir) ? (DIR)NetworkHelper.getOppositeDir(curDir) : null;
    }

    @IndirectCallers
    protected Collection<Class<?>> getOrInitMissingDecoders() {
        if (Objects.isNull(this.missingDecoders)) {
            this.missingDecoders = this.initMissingDecoderCollection();
        }
        return this.missingDecoders;
    }

    @Nullable
    public MessageWrapperAPI<PLAYER, CTX> handle(CTX context) {
        if (Objects.isNull(this.messages)) {
            this.messages = Collections.emptyList();
        }
        if (this.debug) {
            TILRef.logInfo("[Direction={}]: Handling {} messages for type: {}", this.dirName(), this.messages.size(), this.getClass());
        }
        ArrayList replies = new ArrayList();
        for (MessageAPI<CTX> message : this.messages) {
            MessageAPI<CTX> reply;
            if (Objects.isNull(message)) {
                if (!this.debug) continue;
                TILRef.logInfo("[Direction={}]: Skipping handle for null message", this.dirName());
                continue;
            }
            if (this.debug) {
                TILRef.logInfo("[Direction={}]: Handling message: {}", this.dirName(), message.getClass());
            }
            if (Objects.nonNull(reply = this.info.handle(message, context))) {
                if (this.debug) {
                    TILRef.logInfo("[Direction={}]: Handling message reply: {}", this.dirName(), reply.getClass());
                }
                replies.add(reply);
                continue;
            }
            if (!this.debug) continue;
            TILRef.logInfo("[Direction={}]: No message reply to handle for {}", this.dirName(), message.getClass());
        }
        if (this.debug) {
            TILRef.logInfo("[Direction={}]: Sending {} message replies for type: {}", this.dirName(), this.messages.size(), this.getClass());
        }
        if (replies.isEmpty()) {
            return null;
        }
        MessageWrapperAPI response = (MessageWrapperAPI)GenericUtils.cast(NetworkHelper.wrapMessages(this.getOppositeDir(), replies));
        if (this.debug) {
            TILRef.logInfo("[Direction={}]: Response message type: {}", Objects.nonNull(response) ? response.getClass() : null);
        }
        if (this.debug) {
            TILRef.logInfo("[Direction={}]: Successfully handled {} messages for type: {}", this.dirName(), this.messages.size(), this.getClass());
        }
        return response;
    }

    protected Collection<Class<?>> initMissingDecoderCollection() {
        return new HashSet();
    }

    protected void markFoundMissingDecoder(Class<?> msgClass) {
        if (this.debug) {
            TILRef.logInfo("[Direction={}]: Missing decoder has been found for type: {}!", this.dirName(), msgClass);
        }
        if (Objects.nonNull(this.missingDecoders)) {
            this.missingDecoders.remove(msgClass);
        }
    }

    protected void markMissingDecoder(Class<?> msgClass, ByteBuf buf, AtomicBoolean decodingFailure) {
        Collection<Class<?>> missingDecoders;
        if (this.debug) {
            TILRef.logError("[Direction={}]: Failed to decode message type: {}", this.dirName(), msgClass);
        }
        if (!(missingDecoders = this.getOrInitMissingDecoders()).contains(msgClass)) {
            MessageWrapperAPI.invokeForgeHelper("requestDecoder", this.info, msgClass, buf);
            missingDecoders.add(msgClass);
        }
        decodingFailure.set(true);
    }

    public void send() {
        if (Objects.isNull(this.info) || Objects.isNull(this.getDir())) {
            TILRef.logError("Cannot send packet of class `{}` with null info or direction!", this.getClass());
            return;
        }
        if (Objects.isNull(this.messages)) {
            TILRef.logError("Cannot send packet of class `{}` with no messages set!", this.getClass());
            return;
        }
        if (NetworkHelper.isDirToClient(this.getDir())) {
            if (Objects.isNull(this.players)) {
                TILRef.logError("Cannot send packet of class `{}` to client with no players set!", this.getClass());
                return;
            }
            if (this.debug) {
                TILRef.logInfo("Sending {} messages to {} clients (wrapper={})", Objects.nonNull(this.messages) ? this.messages.size() : 0, this.players.size(), this.getClass().getName());
            }
            for (PLAYER player : this.players) {
                NetworkHelper.sendToPlayer(this, player);
            }
        } else {
            if (this.debug) {
                TILRef.logInfo("Sending {} messages to the server (wrapper={})", Objects.nonNull(this.messages) ? this.messages.size() : 0, this.getClass().getName());
            }
            NetworkHelper.sendToServer(this);
        }
    }

    public <DIR> MessageWrapperAPI<PLAYER, CTX> setMessage(DIR dir, MessageAPI<CTX> message) {
        this.info = NetworkHandler.getDirectionInfo(dir);
        this.messages = Collections.singletonList(message);
        return this;
    }

    @SafeVarargs
    public final <DIR> MessageWrapperAPI<PLAYER, CTX> setMessages(DIR dir, MessageAPI<CTX> ... messages) {
        return this.setMessages(dir, Arrays.asList(messages));
    }

    public <DIR> MessageWrapperAPI<PLAYER, CTX> setMessages(DIR dir, Collection<MessageAPI<CTX>> messages) {
        this.info = NetworkHandler.getDirectionInfo(dir);
        this.messages = Collections.unmodifiableCollection(messages);
        return this;
    }

    public MessageWrapperAPI<PLAYER, CTX> setPlayer(PLAYER player) {
        this.players = Collections.singletonList(player);
        return this;
    }

    @SafeVarargs
    @IndirectCallers
    public final MessageWrapperAPI<PLAYER, CTX> setPlayers(PLAYER ... players) {
        this.players = Arrays.asList(players);
        return this;
    }

    @IndirectCallers
    public MessageWrapperAPI<PLAYER, CTX> setPlayers(Collection<PLAYER> players) {
        this.players = Collections.unmodifiableCollection(players);
        return this;
    }

    public static final class ServerLogin<PLAYER, CTX>
    extends MessageWrapperAPI<PLAYER, CTX> {
        ServerLogin() {
        }

        ServerLogin(ByteBuf buf) {
            super(buf);
        }
    }

    public static final class Server<PLAYER, CTX>
    extends MessageWrapperAPI<PLAYER, CTX> {
        Server() {
        }

        Server(ByteBuf buf) {
            super(buf);
        }
    }

    public static final class ClientLogin<PLAYER, CTX>
    extends MessageWrapperAPI<PLAYER, CTX> {
        ClientLogin() {
        }

        ClientLogin(ByteBuf buf) {
            super(buf);
        }
    }

    public static final class Client<PLAYER, CTX>
    extends MessageWrapperAPI<PLAYER, CTX> {
        Client() {
        }

        Client(ByteBuf buf) {
            super(buf);
        }
    }
}

