/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.parameter;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.ColorCache;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.ColorHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.io.LoggableAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.parameter.Parameter;

public interface ParameterMap
extends LoggableAPI {
    public Parameter<?> getParameter(String var1);

    default public <T> T getParameterAs(String name, BiFunction<Parameter<?>, String, T> getter) {
        return this.getParameterAs(name, null, getter);
    }

    default public <T> T getParameterAs(String name, T defVal, BiFunction<Parameter<?>, String, T> getter) {
        Parameter<?> parameter = this.getParameter(name);
        return Objects.nonNull(parameter) ? getter.apply(parameter, name) : defVal;
    }

    @IndirectCallers
    default public boolean getParameterAsBoolean(String name) {
        return this.getParameterAsBoolean(name, false);
    }

    default public boolean getParameterAsBoolean(String name, boolean defVal) {
        return this.getParameterAs(name, defVal, Parameter::getAsBoolean);
    }

    @IndirectCallers
    default public byte getParameterAsByte(String name) {
        return this.getParameterAsByte(name, (byte)0);
    }

    default public byte getParameterAsByte(String name, byte defVal) {
        return this.getParameterAs(name, defVal, Parameter::getAsByte);
    }

    @IndirectCallers
    default public ColorCache getParameterAsColor(String name) {
        return this.getParameterAsColor(name, ColorHelper.WHITE);
    }

    default public ColorCache getParameterAsColor(String name, ColorCache defVal) {
        return this.getParameterAs(name, defVal, (p, ignored) -> p.getAsColor());
    }

    @IndirectCallers
    default public double getParameterAsDouble(String name) {
        return this.getParameterAsDouble(name, 0.0);
    }

    default public double getParameterAsDouble(String name, double defVal) {
        return this.getParameterAs(name, defVal, Parameter::getAsDouble);
    }

    @IndirectCallers
    default public float getParameterAsFloat(String name) {
        return this.getParameterAsFloat(name, 0.0f);
    }

    default public float getParameterAsFloat(String name, float defVal) {
        return this.getParameterAs(name, Float.valueOf(defVal), Parameter::getAsFloat).floatValue();
    }

    @IndirectCallers
    default public int getParameterAsInt(String name) {
        return this.getParameterAsInt(name, 0);
    }

    default public int getParameterAsInt(String name, int defVal) {
        return this.getParameterAs(name, defVal, Parameter::getAsInt);
    }

    @IndirectCallers
    default public List<?> getParameterAsList(String name) {
        return this.getParameterAsList(name, Collections.emptyList());
    }

    default public List<?> getParameterAsList(String name, List<?> defVal) {
        return this.getParameterAs(name, defVal, (p, ignored) -> p.getAsList());
    }

    @IndirectCallers
    default public long getParameterAsLong(String name) {
        return this.getParameterAsLong(name, 0L);
    }

    default public long getParameterAsLong(String name, long defVal) {
        return this.getParameterAs(name, defVal, Parameter::getAsLong);
    }

    @IndirectCallers
    default public Number getParameterAsNumber(String name) {
        return this.getParameterAsNumber(name, 0);
    }

    default public Number getParameterAsNumber(String name, Number defVal) {
        return this.getParameterAs(name, defVal, Parameter::getAsNumber);
    }

    default public Object getParameterAsObject(String name) {
        return this.getParameterAsObject(name, null);
    }

    default public Object getParameterAsObject(String name, Object defVal) {
        return this.getParameterAs(name, defVal, (p, ignored) -> p.getValue());
    }

    @IndirectCallers
    default public short getParameterAsShort(String name) {
        return this.getParameterAsShort(name, (short)0);
    }

    default public short getParameterAsShort(String name, short defVal) {
        return this.getParameterAs(name, defVal, Parameter::getAsShort);
    }

    @IndirectCallers
    default public String getParameterAsString(String name) {
        return this.getParameterAsString(name, null);
    }

    default public String getParameterAsString(String name, String defVal) {
        return this.getParameterAs(name, defVal, (p, ignored) -> p.getAsString());
    }

    @IndirectCallers
    default public Map<String, Object> getValueMap() {
        return this.getValueMap(false);
    }

    default public Map<String, Object> getValueMap(boolean filterNullValues) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (String key : this.keys()) {
            Object value = this.getParameterAsObject(key);
            if (!Objects.nonNull(value) && filterNullValues) continue;
            map.put(key, value);
        }
        return map;
    }

    public Collection<String> keys();

    public Collection<Parameter<?>> parameters();
}

