/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.parameter;

import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.function.Function;
import mods.thecomputerizer.theimpossiblelibrary.api.network.NetworkHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.parameter.Parameter;
import org.jetbrains.annotations.Nullable;

public class ParameterString
extends Parameter<String> {
    public ParameterString(String defaultValue) {
        super(defaultValue);
    }

    public ParameterString(ByteBuf buf) {
        super(buf);
    }

    public ParameterString copy() {
        ParameterString copy = new ParameterString((String)this.defaultValue);
        copy.value = this.value;
        return copy;
    }

    @Override
    protected <V extends Number> V getAsNumber(@Nullable Object value, Function<Number, V> fromNumber, Function<String, V> fromString) {
        return (V)((Number)fromString.apply((String)this.value));
    }

    @Override
    public String getAsString() {
        return (String)this.value;
    }

    @Override
    public boolean isBool() {
        return false;
    }

    @Override
    public boolean isByte() {
        return false;
    }

    @Override
    public boolean isDouble() {
        return false;
    }

    @Override
    public boolean isFloat() {
        return false;
    }

    @Override
    public boolean isInt() {
        return false;
    }

    @Override
    public boolean isList() {
        return false;
    }

    @Override
    public boolean isLong() {
        return false;
    }

    @Override
    public boolean isNumber() {
        return false;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public boolean isShort() {
        return false;
    }

    @Override
    public boolean isString() {
        return true;
    }

    @Override
    protected String read(ByteBuf buf) {
        return NetworkHelper.readString(buf);
    }

    @Override
    public void setValue(@Nullable Object value) {
        this.value = Objects.nonNull(value) ? value.toString() : null;
    }

    @Override
    protected void write(ByteBuf buf, String val) {
        NetworkHelper.writeString(buf, val);
    }
}

