/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.registry;

import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.Hacks;
import mods.thecomputerizer.theimpossiblelibrary.api.resource.ResourceLocationAPI;

public abstract class RegistryEntryBuilder<API> {
    protected static final boolean NAMED_ENV = CoreAPI.isNamedEnv();
    protected static final boolean SRG_ENV = CoreAPI.isSrgEnv();
    protected static final CoreAPI.GameVersion VERSION = CoreAPI.gameVersion();
    protected static final boolean DEFAULT_MINOR_VERSION = VERSION == CoreAPI.GameVersion.V12_2 || VERSION == CoreAPI.GameVersion.V16_5 || VERSION == CoreAPI.GameVersion.V18_2 || CoreAPI.isForge() && VERSION == CoreAPI.GameVersion.V20_6;
    protected ResourceLocationAPI<?> registryName;

    public abstract API build();

    protected <T> T findAndInitializeForVersion(String baseClassName, Object ... args) {
        return this.findAndInitializeForVersion(baseClassName, DEFAULT_MINOR_VERSION, args);
    }

    protected <T> T findAndInitializeForVersion(String baseClassName, boolean minor, Object ... args) {
        return Hacks.construct(this.getClassForVersion(baseClassName, minor), args);
    }

    protected String getClassForVersion(String className, boolean minor) {
        return VERSION.withClassExt(this.getClass().getPackage().getName() + "." + className, minor);
    }

    public RegistryEntryBuilder<API> setRegistryName(ResourceLocationAPI<?> name) {
        this.registryName = name;
        return this;
    }
}

