/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors;

import lombok.Generated;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector1;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector2;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector3;
import mods.thecomputerizer.theimpossiblelibrary.api.util.GenericUtils;

public class Vector4
implements Vector {
    protected Number x;
    protected Number y;
    protected Number z;
    protected Number w;

    public Vector4() {
        this(0, 0, 0, 0);
    }

    public Vector4(Number x) {
        this(x, 0, 0, 0);
    }

    public Vector4(Number x, Number y) {
        this(x, y, 0, 0);
    }

    public Vector4(Number x, Number y, Number z) {
        this(x, y, z, 0);
    }

    public Vector4(Number x, Number y, Number z, Number w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    @Override
    public Vector4 add(Vector v) {
        int count = v.count();
        if (count > 0) {
            this.setX(GenericUtils.numberAdd(this.x, v.x()));
            if (count > 1) {
                this.setY(GenericUtils.numberAdd(this.y, v.y()));
                if (count > 2) {
                    this.setZ(GenericUtils.numberAdd(this.z, v.z()));
                    if (count > 3) {
                        this.setW(GenericUtils.numberAdd(this.w, v.w()));
                    }
                }
            }
        }
        return this;
    }

    @Override
    public Vector4 addScalar(Number n) {
        this.setX(GenericUtils.numberAdd(this.x, n));
        this.setY(GenericUtils.numberAdd(this.y, n));
        this.setZ(GenericUtils.numberAdd(this.z, n));
        this.setW(GenericUtils.numberAdd(this.w, n));
        return this;
    }

    @Override
    public double angle(Vector v) {
        double l2;
        double l1;
        double vdW;
        double vdZ;
        double vdY;
        if (v.count() < 4) {
            return 0.0;
        }
        double dX = this.dX();
        double dY = this.dY();
        double dZ = this.dZ();
        double dW = this.dW();
        double vdX = v.dX();
        double l3 = dX * vdX + (dY * (vdY = v.dY()) + (dZ * (vdZ = v.dZ()) + dW * (vdW = v.dW())));
        double angle = l3 / Math.sqrt((l1 = dX * dX + (dY * dY + (dZ * dZ + dW * dW))) * (l2 = vdX * vdX + (vdY * vdY + (vdZ * vdZ + vdW * vdW))));
        return Math.acos(angle < 1.0 ? (angle > -1.0 ? angle : -1.0) : 1.0);
    }

    @Override
    public Number[] array() {
        return new Number[]{this.x, this.y, this.z, this.w};
    }

    @Override
    public byte[] bArrray() {
        return new byte[]{this.bX(), this.bY(), this.bZ(), this.bW()};
    }

    @Override
    public Vector4 copy() {
        return new Vector4(this.x, this.y, this.z, this.w);
    }

    @Override
    public int count() {
        return 4;
    }

    @Override
    public Vector cross(Vector v) {
        return this;
    }

    @Override
    public double[] dArrray() {
        return new double[]{this.dX(), this.dY(), this.dZ(), this.dW()};
    }

    @Override
    public double distance(Vector v) {
        if (v.count() < 4) {
            return 0.0;
        }
        double dx = this.dX() - v.dX();
        double dy = this.dY() - v.dY();
        double dz = this.dZ() - v.dZ();
        double dw = this.dW() - v.dW();
        return Math.sqrt(dx * dx + dy * dy + dz * dz + dw * dw);
    }

    @Override
    public Vector4 div(Vector v) {
        int count = v.count();
        if (count > 0) {
            this.setX(GenericUtils.numberDiv(this.x, v.x()));
            if (count > 1) {
                this.setY(GenericUtils.numberDiv(this.y, v.y()));
                if (count > 2) {
                    this.setZ(GenericUtils.numberDiv(this.z, v.z()));
                    if (count > 3) {
                        this.setW(GenericUtils.numberDiv(this.w, v.w()));
                    }
                }
            }
        }
        return this;
    }

    @Override
    public Vector4 divScalar(Number n) {
        this.setX(GenericUtils.numberDiv(this.x, n));
        this.setY(GenericUtils.numberDiv(this.y, n));
        this.setZ(GenericUtils.numberDiv(this.z, n));
        this.setW(GenericUtils.numberDiv(this.w, n));
        return this;
    }

    @Override
    public double dot(Vector v) {
        int count = v.count();
        if (count == 0) {
            return 0.0;
        }
        double total = this.dX() * v.dX();
        if (count > 1) {
            total += this.dY() * v.dY();
        }
        if (count > 2) {
            total += this.dZ() * v.dZ();
        }
        if (count > 3) {
            total += this.dW() * v.dW();
        }
        return total;
    }

    @Override
    public float[] fArrray() {
        return new float[]{this.fX(), this.fY(), this.fZ(), this.fW()};
    }

    @Override
    public int[] iArrray() {
        return new int[]{this.iX(), this.iY(), this.iZ(), this.iW()};
    }

    @Override
    public long[] lArrray() {
        return new long[]{this.lX(), this.lY(), this.lZ(), this.lW()};
    }

    @Override
    public Vector4 mul(Vector v) {
        int count = v.count();
        if (count > 0) {
            this.setX(GenericUtils.numberMul(this.x, v.x()));
            if (count > 1) {
                this.setY(GenericUtils.numberMul(this.y, v.y()));
                if (count > 2) {
                    this.setZ(GenericUtils.numberMul(this.z, v.z()));
                    if (count > 3) {
                        this.setW(GenericUtils.numberMul(this.w, v.w()));
                    }
                }
            }
        }
        return this;
    }

    @Override
    public Vector4 mulScalar(Number n) {
        this.setX(GenericUtils.numberMul(this.x, n));
        this.setY(GenericUtils.numberMul(this.y, n));
        this.setZ(GenericUtils.numberMul(this.z, n));
        this.setW(GenericUtils.numberMul(this.w, n));
        return this;
    }

    @Override
    public short[] sArrray() {
        return new short[]{this.sX(), this.sY(), this.sZ(), this.sW()};
    }

    @Override
    public Vector4 sub(Vector v) {
        int count = v.count();
        if (count > 0) {
            this.setX(GenericUtils.numberMul(this.x, v.x()));
            if (count > 1) {
                this.setY(GenericUtils.numberMul(this.y, v.y()));
                if (count > 2) {
                    this.setZ(GenericUtils.numberMul(this.z, v.z()));
                    if (count > 3) {
                        this.setW(GenericUtils.numberMul(this.w, v.w()));
                    }
                }
            }
        }
        return this;
    }

    @Override
    public Vector4 subScalar(Number n) {
        this.setX(GenericUtils.numberSub(this.x, n));
        this.setY(GenericUtils.numberSub(this.y, n));
        this.setZ(GenericUtils.numberSub(this.z, n));
        this.setW(GenericUtils.numberSub(this.w, n));
        return this;
    }

    @Override
    public Vector vW() {
        return new Vector1(this.w());
    }

    @Override
    public Vector vX() {
        return new Vector1(this.x());
    }

    @Override
    public Vector vXW() {
        return new Vector2(this.x(), this.w());
    }

    @Override
    public Vector vXY() {
        return new Vector2(this.x(), this.y());
    }

    @Override
    public Vector vXYZ() {
        return new Vector3(this.x(), this.y(), this.z());
    }

    @Override
    public Vector vXZ() {
        return new Vector2(this.x(), this.z());
    }

    @Override
    public Vector vXZW() {
        return new Vector3(this.x(), this.z(), this.w());
    }

    @Override
    public Vector vY() {
        return new Vector1(this.y());
    }

    @Override
    public Vector vYW() {
        return new Vector2(this.y(), this.w());
    }

    @Override
    public Vector vYZ() {
        return new Vector2(this.y(), this.z());
    }

    @Override
    public Vector vYZW() {
        return new Vector3(this.y(), this.z(), this.w());
    }

    @Override
    public Vector vZ() {
        return new Vector1(this.z());
    }

    @Override
    public Vector vZW() {
        return new Vector2(this.z(), this.w());
    }

    @Override
    public Number w() {
        return this.w;
    }

    @Override
    public Number x() {
        return this.x;
    }

    @Override
    public Number y() {
        return this.y;
    }

    @Override
    public Number z() {
        return this.z;
    }

    @Override
    @Generated
    public void setX(Number x) {
        this.x = x;
    }

    @Override
    @Generated
    public void setY(Number y) {
        this.y = y;
    }

    @Override
    @Generated
    public void setZ(Number z) {
        this.z = z;
    }

    @Override
    @Generated
    public void setW(Number w) {
        this.w = w;
    }
}

