/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.tag;

import java.util.Objects;
import mods.thecomputerizer.theimpossiblelibrary.api.tag.BaseTagAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.tag.ListTagAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.tag.PrimitiveTagAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.tag.StringTagAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.tag.TagHelper;

public abstract class CompoundTagAPI<T>
extends BaseTagAPI<T> {
    protected CompoundTagAPI(Object tag) {
        super(tag);
    }

    @Override
    public CompoundTagAPI<?> asCompoundTag() {
        return this;
    }

    @Override
    public ListTagAPI<?> asListTag() {
        return null;
    }

    @Override
    public PrimitiveTagAPI<?> asPrimitiveTag() {
        return null;
    }

    @Override
    public StringTagAPI<?> asStringTag() {
        return null;
    }

    public abstract boolean contains(String var1);

    public CompoundTagAPI<?> getCompoundTag(String key) {
        if (!this.contains(key)) {
            return null;
        }
        return this.getTag(key).asCompoundTag();
    }

    public ListTagAPI<?> getListTag(String key) {
        if (!this.contains(key)) {
            return null;
        }
        return this.getTag(key).asListTag();
    }

    public PrimitiveTagAPI<?> getPrimitiveTag(String key) {
        if (!this.contains(key)) {
            return null;
        }
        return this.getTag(key).asPrimitiveTag();
    }

    public String getString(String key) {
        if (!this.contains(key)) {
            return null;
        }
        StringTagAPI<?> tag = this.getTag(key).asStringTag();
        return Objects.nonNull(tag) ? tag.getValue() : null;
    }

    public abstract BaseTagAPI<?> getTag(String var1);

    @Override
    public boolean isCompound() {
        return true;
    }

    public abstract boolean isEmpty();

    @Override
    public boolean isList() {
        return false;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public boolean isString() {
        return false;
    }

    public void putBoolean(String key, boolean b) {
        this.putTag(key, TagHelper.makePrimitiveTag(b));
    }

    public void putByte(String key, byte b) {
        this.putTag(key, TagHelper.makePrimitiveTag(b));
    }

    public void putDouble(String key, double d) {
        this.putTag(key, TagHelper.makePrimitiveTag(d));
    }

    public void putFloat(String key, float f) {
        this.putTag(key, TagHelper.makePrimitiveTag(f));
    }

    public void putInt(String key, int i) {
        this.putTag(key, TagHelper.makePrimitiveTag(i));
    }

    public void putLong(String key, long l) {
        this.putTag(key, TagHelper.makePrimitiveTag(l));
    }

    public void putShort(String key, short s) {
        this.putTag(key, TagHelper.makePrimitiveTag(s));
    }

    public void putString(String key, String value) {
        this.putTag(key, TagHelper.makeStringTag(value));
    }

    public abstract void putTag(String var1, BaseTagAPI<?> var2);

    public abstract String toPrettyString();
}

