/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.tag;

import java.io.File;
import java.util.Objects;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.tag.BaseTagAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.tag.CompoundTagAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.tag.ListTagAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.tag.PrimitiveTagAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.tag.StringTagAPI;

public interface TagAPI {
    public <T> BaseTagAPI<T> getWrapped(T var1);

    default public CompoundTagAPI<?> makeCompoundTag() {
        return this.getWrapped(this.newCompoundTag()).asCompoundTag();
    }

    default public ListTagAPI<?> makeListTag() {
        return this.getWrapped(this.newListTag()).asListTag();
    }

    default public PrimitiveTagAPI<?> makePrimitiveTag(boolean b) {
        return this.getWrapped(this.newPrimitiveTag(b)).asPrimitiveTag();
    }

    default public PrimitiveTagAPI<?> makePrimitiveTag(byte b) {
        return this.getWrapped(this.newPrimitiveTag(b)).asPrimitiveTag();
    }

    default public PrimitiveTagAPI<?> makePrimitiveTag(double d) {
        return this.getWrapped(this.newPrimitiveTag(d)).asPrimitiveTag();
    }

    default public PrimitiveTagAPI<?> makePrimitiveTag(float f) {
        return this.getWrapped(this.newPrimitiveTag(f)).asPrimitiveTag();
    }

    default public PrimitiveTagAPI<?> makePrimitiveTag(int i) {
        return this.getWrapped(this.newPrimitiveTag(i)).asPrimitiveTag();
    }

    default public PrimitiveTagAPI<?> makePrimitiveTag(long l) {
        return this.getWrapped(this.newPrimitiveTag(l)).asPrimitiveTag();
    }

    default public PrimitiveTagAPI<?> makePrimitiveTag(short s) {
        return this.getWrapped(this.newPrimitiveTag(s)).asPrimitiveTag();
    }

    default public StringTagAPI<?> makeStringTag(String value) {
        return this.getWrapped(this.newStringTag(value)).asStringTag();
    }

    public Object newCompoundTag();

    public Object newListTag();

    public Object newPrimitiveTag(boolean var1);

    public Object newPrimitiveTag(byte var1);

    public Object newPrimitiveTag(double var1);

    public Object newPrimitiveTag(float var1);

    public Object newPrimitiveTag(int var1);

    public Object newPrimitiveTag(long var1);

    public Object newPrimitiveTag(short var1);

    public Object newStringTag(String var1);

    default public CompoundTagAPI<?> readFromFile(File file) {
        Object tag = null;
        if (Objects.isNull(file)) {
            TILRef.logError("Tried to read NBT data from null file!", new Object[0]);
        } else {
            try {
                tag = this.readFromFileDirect(file);
            }
            catch (Exception ex) {
                TILRef.logWarn("Empty data file {}", file.toPath(), ex.getMessage());
            }
        }
        return this.getWrapped(Objects.nonNull(tag) ? tag : this.newCompoundTag()).asCompoundTag();
    }

    public Object readFromFileDirect(File var1) throws Exception;

    default public void writeToFile(CompoundTagAPI<?> tag, File file) {
        if (Objects.nonNull(tag) && !tag.isEmpty() && Objects.nonNull(file)) {
            try {
                this.writeToFileDirect(tag, file);
            }
            catch (Exception ex) {
                TILRef.logError("Failed to write tag to file {}", file, ex);
            }
        }
    }

    public void writeToFileDirect(CompoundTagAPI<?> var1, File var2) throws Exception;
}

