/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiFunction;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;

public enum Matching {
    CONTAINS(String::contains),
    ENDS_WITH(String::endsWith),
    EQUALS(String::equals),
    MATCHES(String::matches),
    STARTS_WITH(String::startsWith);

    final BiFunction<String, String, Boolean> matcher;

    public static boolean matchesAll(String value, String checkThis, Matching ... matchers) {
        for (Matching matcher : matchers) {
            if (matcher.matches(value, checkThis)) continue;
            return false;
        }
        return true;
    }

    public static boolean matchesAny(String value, String checkThis, Matching ... matchers) {
        for (Matching matcher : matchers) {
            if (!matcher.matches(value, checkThis)) continue;
            return true;
        }
        return false;
    }

    @IndirectCallers
    public static Set<String> matchingValuesAll(Collection<String> values, String checkThis, Matching ... matchers) {
        HashSet<String> matches = new HashSet<String>();
        for (String value : values) {
            if (!Matching.matchesAll(value, checkThis, matchers)) continue;
            matches.add(value);
        }
        return matches;
    }

    public static Set<String> matchingValuesAny(Collection<String> values, String checkThis, Matching ... matchers) {
        HashSet<String> matches = new HashSet<String>();
        for (String value : values) {
            if (!Matching.matchesAny(value, checkThis, matchers)) continue;
            matches.add(value);
        }
        return matches;
    }

    private Matching(BiFunction<String, String, Boolean> matcher) {
        this.matcher = matcher;
    }

    public boolean matches(String value, String checkThis) {
        return this.matcher.apply(value, checkThis);
    }
}

