/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.util;

import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.util.GenericUtils;

public enum Sorting {
    ALPHABETICAL(Comparator.naturalOrder()),
    REVERSE(Comparator.reverseOrder());

    final Comparator<?> comparator;

    @IndirectCallers
    public static <T, C extends Collection<T>> C applyAll(C collection, Sorting ... sorters) {
        for (Sorting sorter : sorters) {
            collection = sorter.sorted(collection);
        }
        return collection;
    }

    private Sorting(Comparator<?> comparator) {
        this.comparator = comparator;
    }

    <T, C extends Collection<T>> C sorted(C collection) {
        Comparator comparator = (Comparator)GenericUtils.cast(this.comparator);
        if (Objects.nonNull(comparator)) {
            Set set;
            if (collection instanceof List) {
                List list = (List)GenericUtils.cast(collection);
                if (Objects.nonNull(list)) {
                    list.sort(comparator);
                }
            } else if (collection instanceof Set && Objects.nonNull(set = (Set)GenericUtils.cast(collection))) {
                set = set.stream().sorted(comparator).collect(Collectors.toCollection(LinkedHashSet::new));
                collection = (Collection)GenericUtils.cast(set);
            }
        }
        return collection;
    }
}

