/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.wrappers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import mods.thecomputerizer.theimpossiblelibrary.api.client.sound.SoundAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.CommonAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.advancement.AdvancementAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.biome.BiomeAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.block.BlockAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.block.BlockSnapshotAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.block.BlockStateAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.block.MaterialAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.blockentity.BlockEntityAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.container.InventoryAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.container.PlayerInventoryAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.effect.EffectAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.effect.EffectInstanceAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.effect.PotionAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.entity.DamageAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.entity.EntityAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.entity.LivingEntityAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.entity.PlayerAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.item.ItemAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.item.ItemStackAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.sound.SoundEventAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.structure.StructureAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.Hacks;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.registry.tab.CreativeTabAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.resource.ResourceLocationAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.server.CommandSenderAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.util.GenericUtils;
import mods.thecomputerizer.theimpossiblelibrary.api.world.BlockPosAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.world.DimensionAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.world.ExplosionAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.world.WorldAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.wrappers.AbstractWrapped;
import mods.thecomputerizer.theimpossiblelibrary.api.wrappers.WrapperAPI;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class WrapperHelper {
    static final Logger LOGGER = TILRef.createLogger("TIL Wrapper Helper");

    public static <W, G> Collector<W, G, Collection<W>> defaultCollector() {
        return (Collector)GenericUtils.cast(Collectors.toList());
    }

    @Nullable
    private static Object fixGenericGetter(@Nullable Object source, @Nullable Function<?, ?> getter) {
        return Objects.nonNull(source) && Objects.nonNull(getter) ? getter.apply(GenericUtils.cast(source)) : null;
    }

    public static WrapperAPI getAPI() {
        return TILRef.getCommonSubAPI(CommonAPI::getWrapper);
    }

    public static WrapperType getWrapperType(String name) {
        return WrapperType.getByName(name);
    }

    public static <A> AdvancementAPI<A> wrapAdvancement(@Nullable Object source, @Nullable Function<?, ?> getter) {
        return WrapperHelper.wrapAdvancement(WrapperHelper.fixGenericGetter(source, getter));
    }

    public static <A> AdvancementAPI<A> wrapAdvancement(@Nullable Object advancement) {
        return WrapperHelper.getAPI().wrapAdvancement(advancement);
    }

    public static <A> BiomeAPI<A> wrapBiome(@Nullable Object source, @Nullable Function<?, ?> getter) {
        return WrapperHelper.wrapBiome(WrapperHelper.fixGenericGetter(source, getter));
    }

    public static <B> BiomeAPI<B> wrapBiome(@Nullable Object biome) {
        return WrapperHelper.getAPI().wrapBiome(biome);
    }

    public static <B> BlockAPI<B> wrapBlock(@Nullable Object source, @Nullable Function<?, ?> getter) {
        return WrapperHelper.wrapBlock(WrapperHelper.fixGenericGetter(source, getter));
    }

    public static <B> BlockAPI<B> wrapBlock(@Nullable Object block) {
        return WrapperHelper.getAPI().wrapBlock(block);
    }

    public static <B> BlockEntityAPI<B, ?> wrapBlockEntity(@Nullable Object source, @Nullable Function<?, ?> getter) {
        return WrapperHelper.wrapBlockEntity(WrapperHelper.fixGenericGetter(source, getter));
    }

    public static <B> BlockEntityAPI<B, ?> wrapBlockEntity(@Nullable Object blockentity) {
        return WrapperHelper.getAPI().wrapBlockEntity(blockentity);
    }

    @IndirectCallers
    public static <A extends AbstractWrapped<?>> Collection<A> wrapCollection(@Nullable Collection<?> collection, String typeName) {
        return WrapperHelper.wrapCollection(collection, WrapperHelper.getWrapperType(typeName));
    }

    @IndirectCallers
    public static <A extends AbstractWrapped<?>> Collection<A> wrapCollection(@Nullable Collection<?> collection, String typeName, boolean mutableIfEmpty) {
        return WrapperHelper.wrapCollection(collection, WrapperHelper.getWrapperType(typeName), mutableIfEmpty);
    }

    @IndirectCallers
    public static <A extends AbstractWrapped<?>> Collection<A> wrapCollection(@Nullable Collection<?> collection, String typeName, @Nullable Collector<A, ?, Collection<A>> collector) {
        return WrapperHelper.wrapCollection(collection, WrapperHelper.getWrapperType(typeName), collector);
    }

    @IndirectCallers
    public static <A extends AbstractWrapped<?>> Collection<A> wrapCollection(@Nullable Collection<?> collection, String typeName, boolean mutableIfEmpty, @Nullable Collector<A, ?, Collection<A>> collector) {
        return WrapperHelper.wrapCollection(collection, WrapperHelper.getWrapperType(typeName), mutableIfEmpty, collector);
    }

    public static <A extends AbstractWrapped<?>> Collection<A> wrapCollection(@Nullable Collection<?> collection, WrapperType type) {
        return WrapperHelper.wrapCollection(collection, type::wrap);
    }

    public static <A extends AbstractWrapped<?>> Collection<A> wrapCollection(@Nullable Collection<?> collection, WrapperType type, boolean mutableIfEmpty) {
        return WrapperHelper.wrapCollection(collection, type::wrap, mutableIfEmpty);
    }

    public static <A extends AbstractWrapped<?>> Collection<A> wrapCollection(@Nullable Collection<?> collection, WrapperType type, @Nullable Collector<A, ?, Collection<A>> collector) {
        return WrapperHelper.wrapCollection(collection, type::wrap, collector);
    }

    public static <A extends AbstractWrapped<?>> Collection<A> wrapCollection(@Nullable Collection<?> collection, WrapperType type, boolean mutableIfEmpty, @Nullable Collector<A, ?, Collection<A>> collector) {
        return WrapperHelper.wrapCollection(collection, type::wrap, mutableIfEmpty, collector);
    }

    @IndirectCallers
    public static <A extends AbstractWrapped<?>> Collection<A> wrapCollection(@Nullable Collection<?> collection, Function<Object, A> wrapperFunc) {
        return WrapperHelper.wrapCollection(collection, wrapperFunc, false, null);
    }

    public static <A extends AbstractWrapped<?>> Collection<A> wrapCollection(@Nullable Collection<?> collection, Function<Object, A> wrapperFunc, boolean mutableIfEmpty) {
        return WrapperHelper.wrapCollection(collection, wrapperFunc, mutableIfEmpty, null);
    }

    @IndirectCallers
    public static <A extends AbstractWrapped<?>> Collection<A> wrapCollection(@Nullable Collection<?> collection, Function<Object, A> wrapperFunc, @Nullable Collector<A, ?, Collection<A>> collector) {
        return WrapperHelper.wrapCollection(collection, wrapperFunc, false, collector);
    }

    public static <A extends AbstractWrapped<?>> Collection<A> wrapCollection(@Nullable Collection<?> collection, Function<Object, A> wrapperFunc, boolean mutableIfEmpty, @Nullable Collector<A, ?, Collection<A>> collector) {
        if (Objects.isNull(collection) || collection.isEmpty()) {
            return mutableIfEmpty ? new ArrayList() : Collections.emptyList();
        }
        if (Objects.isNull(collector)) {
            collector = WrapperHelper.defaultCollector();
        }
        return collection.stream().map(wrapperFunc).collect(collector);
    }

    public static <S> CommandSenderAPI<S> wrapCommandSender(@Nullable Object source, @Nullable Function<?, ?> getter) {
        return WrapperHelper.wrapCommandSender(WrapperHelper.fixGenericGetter(source, getter));
    }

    public static <S> CommandSenderAPI<S> wrapCommandSender(@Nullable Object sender) {
        return WrapperHelper.getAPI().wrapCommandSender(sender);
    }

    public static <S> DamageAPI<S> wrapDamage(@Nullable Object source, @Nullable Function<?, ?> getter, @Nullable Function<?, Float> getAmount) {
        return WrapperHelper.wrapDamage(WrapperHelper.fixGenericGetter(source, getter), getAmount);
    }

    public static <S> DamageAPI<S> wrapDamage(@Nullable Object source, @Nullable Function<?, ?> getter, float amount) {
        return WrapperHelper.wrapDamage(WrapperHelper.fixGenericGetter(source, getter), amount);
    }

    public static <S> DamageAPI<S> wrapDamage(@Nullable Object source, @Nullable Function<?, Float> getAmount) {
        float amount = 0.0f;
        if (Objects.nonNull(source) && Objects.nonNull(getAmount)) {
            amount = getAmount.apply(GenericUtils.cast(source)).floatValue();
        }
        return WrapperHelper.wrapDamage(source, amount);
    }

    public static <S> DamageAPI<S> wrapDamage(@Nullable Object source, float amount) {
        return WrapperHelper.getAPI().wrapDamage(source, amount);
    }

    public static <D> DimensionAPI<D> wrapDimension(WorldAPI<?> world, @Nullable Object source, @Nullable Function<?, ?> getter) {
        return WrapperHelper.wrapDimension(world, WrapperHelper.fixGenericGetter(source, getter));
    }

    public static <D> DimensionAPI<D> wrapDimension(WorldAPI<?> world, @Nullable Object dimension) {
        return WrapperHelper.getAPI().wrapDimension(world, dimension);
    }

    public static <E> EffectAPI<E> wrapEffect(@Nullable Object source, @Nullable Function<?, ?> getter) {
        return WrapperHelper.wrapEffect(WrapperHelper.fixGenericGetter(source, getter));
    }

    public static <E> EffectAPI<E> wrapEffect(@Nullable Object effect) {
        return WrapperHelper.getAPI().wrapEffect(effect);
    }

    @IndirectCallers
    public static <I> EffectInstanceAPI<I> wrapEffectInstance(@Nullable Object source, @Nullable Function<?, ?> getter) {
        return WrapperHelper.wrapEffectInstance(WrapperHelper.fixGenericGetter(source, getter));
    }

    public static <I> EffectInstanceAPI<I> wrapEffectInstance(@Nullable Object instance) {
        return WrapperHelper.getAPI().wrapEffectInstance(instance);
    }

    public static <E> EntityAPI<E, ?> wrapEntity(@Nullable Object source, @Nullable Function<?, ?> getter) {
        return WrapperHelper.wrapEntity(WrapperHelper.fixGenericGetter(source, getter));
    }

    public static <E> EntityAPI<E, ?> wrapEntity(@Nullable Object entity) {
        return WrapperHelper.getAPI().wrapEntity(entity);
    }

    @IndirectCallers
    public static <E> ExplosionAPI<E> wrapExplosion(@Nullable Object source, @Nullable Function<?, ?> getter) {
        return WrapperHelper.wrapExplosion(WrapperHelper.fixGenericGetter(source, getter));
    }

    public static <E> ExplosionAPI<E> wrapExplosion(@Nullable Object explosion) {
        return WrapperHelper.getAPI().wrapExplosion(explosion);
    }

    @IndirectCallers
    public static <W> W wrapGeneric(Class<W> wrapperClass, @Nullable Object generic) {
        return WrapperHelper.getAPI().wrapGeneric(wrapperClass, generic);
    }

    @IndirectCallers
    public static <I> InventoryAPI<I> wrapInventory(@Nullable Object source, @Nullable Function<?, ?> getter) {
        return WrapperHelper.wrapInventory(WrapperHelper.fixGenericGetter(source, getter));
    }

    @IndirectCallers
    public static <I> InventoryAPI<I> wrapInventory(@Nullable Object inventory) {
        return WrapperHelper.getAPI().wrapInventory(inventory);
    }

    public static <I> ItemAPI<I> wrapItem(@Nullable Object source, @Nullable Function<?, ?> getter) {
        return WrapperHelper.wrapItem(WrapperHelper.fixGenericGetter(source, getter));
    }

    public static <I> ItemAPI<I> wrapItem(@Nullable Object item) {
        return WrapperHelper.getAPI().wrapItem(item);
    }

    public static <S> ItemStackAPI<S> wrapItemStack(@Nullable Object source, @Nullable Function<?, ?> getter) {
        return WrapperHelper.wrapItemStack(WrapperHelper.fixGenericGetter(source, getter));
    }

    public static <S> ItemStackAPI<S> wrapItemStack(@Nullable Object stack) {
        return WrapperHelper.getAPI().wrapItemStack(stack);
    }

    public static <L> LivingEntityAPI<L, ?> wrapLivingEntity(@Nullable Object source, @Nullable Function<?, ?> getter) {
        return WrapperHelper.wrapLivingEntity(WrapperHelper.fixGenericGetter(source, getter));
    }

    public static <L> LivingEntityAPI<L, ?> wrapLivingEntity(@Nullable Object living) {
        return WrapperHelper.getAPI().wrapLivingEntity(living);
    }

    public static <M> MaterialAPI<M> wrapMaterial(@Nullable Object source, @Nullable Function<?, ?> getter) {
        return WrapperHelper.wrapMaterial(WrapperHelper.fixGenericGetter(source, getter));
    }

    public static <M> MaterialAPI<M> wrapMaterial(@Nullable Object material) {
        return WrapperHelper.getAPI().wrapMaterial(material);
    }

    public static <P> PlayerAPI<P, ?> wrapPlayer(@Nullable Object source, @Nullable Function<?, ?> getter) {
        return WrapperHelper.wrapPlayer(WrapperHelper.fixGenericGetter(source, getter));
    }

    public static <P> PlayerAPI<P, ?> wrapPlayer(@Nullable Object player) {
        return WrapperHelper.getAPI().wrapPlayer(player);
    }

    public static <I> PlayerInventoryAPI<I> wrapPlayerInventory(@Nullable Object source, @Nullable Function<?, ?> getter) {
        return WrapperHelper.wrapPlayerInventory(WrapperHelper.fixGenericGetter(source, getter));
    }

    public static <I> PlayerInventoryAPI<I> wrapPlayerInventory(@Nullable Object inventory) {
        return WrapperHelper.getAPI().wrapPlayerInventory(inventory);
    }

    @IndirectCallers
    public static <P> PotionAPI<P> wrapPotion(@Nullable Object source, @Nullable Function<?, ?> getter) {
        return WrapperHelper.wrapPotion(WrapperHelper.fixGenericGetter(source, getter));
    }

    @IndirectCallers
    public static <P> PotionAPI<P> wrapPotion(@Nullable Object potion) {
        return WrapperHelper.getAPI().wrapPotion(potion);
    }

    public static <P> BlockPosAPI<P> wrapPosition(@Nullable Object source, @Nullable Function<?, ?> getter) {
        return WrapperHelper.wrapPosition(WrapperHelper.fixGenericGetter(source, getter));
    }

    public static <P> BlockPosAPI<P> wrapPosition(@Nullable Object pos) {
        return WrapperHelper.getAPI().wrapPosition(pos);
    }

    public static <R> ResourceLocationAPI<R> wrapResourceLocation(@Nullable Object source, @Nullable Function<?, ?> getter) {
        return WrapperHelper.wrapResourceLocation(WrapperHelper.fixGenericGetter(source, getter));
    }

    public static <R> ResourceLocationAPI<R> wrapResourceLocation(@Nullable Object resourceLocation) {
        return WrapperHelper.getAPI().wrapResourceLocation(resourceLocation);
    }

    public static <S> BlockSnapshotAPI<S> wrapSnapshot(@Nullable Object source, @Nullable Function<?, ?> getter) {
        return WrapperHelper.wrapSnapshot(WrapperHelper.fixGenericGetter(source, getter));
    }

    public static <S> BlockSnapshotAPI<S> wrapSnapshot(@Nullable Object state) {
        return WrapperHelper.getAPI().wrapSnapshot(state);
    }

    @Nullable
    public static <S> SoundEventAPI<S> wrapSoundEvent(@Nullable Object source, @Nullable Function<?, ?> getter) {
        return WrapperHelper.wrapSoundEvent(WrapperHelper.fixGenericGetter(source, getter));
    }

    @Nullable
    public static <S> SoundEventAPI<S> wrapSoundEvent(@Nullable Object soundEvent) {
        return WrapperHelper.getAPI().wrapSoundEvent(soundEvent);
    }

    @Nullable
    public static <S> SoundAPI<S> wrapSoundInstance(@Nullable Object source, @Nullable Function<?, ?> getter) {
        return WrapperHelper.wrapSoundInstance(WrapperHelper.fixGenericGetter(source, getter));
    }

    @Nullable
    public static <S> SoundAPI<S> wrapSoundInstance(@Nullable Object sound) {
        return WrapperHelper.getAPI().wrapSoundInstance(sound);
    }

    public static <S> BlockStateAPI<S> wrapState(@Nullable Object source, @Nullable Function<?, ?> getter) {
        return WrapperHelper.wrapState(WrapperHelper.fixGenericGetter(source, getter));
    }

    public static <S> BlockStateAPI<S> wrapState(@Nullable Object state) {
        return WrapperHelper.getAPI().wrapState(state);
    }

    public static <S> StructureAPI<S> wrapStructure(@Nullable Object source, @Nullable Function<?, ?> getter) {
        return WrapperHelper.wrapStructure(WrapperHelper.fixGenericGetter(source, getter));
    }

    @IndirectCallers
    public static <S> StructureAPI<S> wrapStructure(@Nullable Object structure) {
        return WrapperHelper.getAPI().wrapStructure(structure);
    }

    public static <T> CreativeTabAPI<T> wrapTab(@Nullable Object source, @Nullable Function<?, ?> getter) {
        return WrapperHelper.wrapTab(WrapperHelper.fixGenericGetter(source, getter));
    }

    public static <T> CreativeTabAPI<T> wrapTab(@Nullable Object tab) {
        return WrapperHelper.getAPI().wrapTab(tab);
    }

    public static <W> WorldAPI<W> wrapWorld(@Nullable Object source, @Nullable Function<?, ?> getter) {
        return WrapperHelper.wrapWorld(WrapperHelper.fixGenericGetter(source, getter));
    }

    public static <W> WorldAPI<W> wrapWorld(@Nullable Object world) {
        return WrapperHelper.getAPI().wrapWorld(world);
    }

    public static enum WrapperType {
        ADVANCEMENT("advancement", new String[0]),
        BIOME("biome", new String[0]),
        BLOCK("block", new String[0]),
        BLOCK_ENTITY("block_entity", "blockentity"),
        BLOCK_SNAPSHOT("snapshot", "block_snapshot", "blocksnapshot"),
        BLOCK_STATE("state", "block_state", "blockstate"),
        COMMAND_SENDER("command_sender", "commandsender"),
        CREATIVE_MODE_TAB("tab", "creative_mode_tab", "creative_modetab", "creativemode_tab", "creativemodetab", "creative_tab", "creativetab"),
        DAMAGE("damage", new String[0]),
        EFFECT("effect", new String[0]),
        EFFECT_INSTANCE("effect_instance", "effectinstance"),
        ENTITY("entity", new String[0]),
        EXPLOSION("explosion", new String[0]),
        INVENTORY("inventory", new String[0]),
        ITEM("item", new String[0]),
        ITEM_STACK("item_stack", "itemstack"),
        LIVING_ENTITY("living_entity", "livingentity", "living"),
        MATERIAL("material", new String[0]),
        PLAYER("player", "server_player", "serverplayer", "remote_player", "remoteplayer", "local_player", "localplayer", "client_player", "clientplayer"),
        PLAYER_INVENTORY("player_inventory", "playerinventory"),
        POTION("potion", new String[0]),
        POSITION("position", "block_position", "blockposition", "block_pos", "blockpos", "pos"),
        RESOURCE_LOCATION("resource_location", "resourcelocation", "resource_name", "resourcename", "resource", "name", "identifier", "id"),
        SOUND_EVENT("sound_event", "soundevent"),
        SOUND_INSTANCE("sound_instance", "soundinstance", "sound"),
        STRUCTURE("structure", "structure_feature", "structurefeature", "configured_structure", "configuredstructure", "configured_structure_feature", "configured_structurefeature", "configuredstructure_feature", "configuredstructurefeature"),
        WORLD("world", "level", "server_world", "serverworld", "server_level", "serverlevel", "remote_world", "remoteworld", "remote_level", "remotelevel", "local_world", "localworld", "local_level", "locallevel", "client_world", "clientworld", "client_level", "clientlevel");

        static final Map<String, WrapperType> ALIAS_MAP;
        final String name;
        final String[] aliases;
        final String wrapperMethod;

        public static WrapperType getByName(String alias) {
            if (Objects.isNull(alias) || alias.isEmpty()) {
                return null;
            }
            if (ALIAS_MAP.containsKey(alias)) {
                return ALIAS_MAP.get(alias);
            }
            for (WrapperType type : WrapperType.values()) {
                if (!type.name.equals(alias)) continue;
                ALIAS_MAP.put(alias, type);
                return type;
            }
            for (WrapperType type : WrapperType.values()) {
                for (String typeAlias : type.aliases) {
                    if (!typeAlias.equals(alias)) continue;
                    ALIAS_MAP.put(alias, type);
                    return type;
                }
            }
            return null;
        }

        static String wrapperMethodName(String name) {
            if (!name.contains("_")) {
                return "wrap" + TextHelper.capitalize(name);
            }
            StringBuilder methodName = new StringBuilder("wrap");
            for (String part : name.split("_")) {
                methodName.append(TextHelper.capitalize(part));
            }
            return methodName.toString();
        }

        private WrapperType(String name, String ... aliases) {
            this.name = name;
            this.aliases = aliases;
            this.wrapperMethod = WrapperType.wrapperMethodName(name);
        }

        public <A extends AbstractWrapped<?>> A wrap(@Nullable Object toWrap) {
            AbstractWrapped wrapped = (AbstractWrapped)Hacks.invokeStatic(WrapperHelper.class, this.wrapperMethod, toWrap);
            if (Objects.isNull(wrapped)) {
                LOGGER.error("Failed to wrap {} using type {}", toWrap, (Object)this.name);
            }
            return (A)wrapped;
        }

        public <A extends AbstractWrapped<?>> A wrap(@Nullable Object source, @Nullable Function<?, ?> getter) {
            AbstractWrapped wrapped = (AbstractWrapped)Hacks.invokeStatic(WrapperHelper.class, this.wrapperMethod, source, getter);
            if (Objects.isNull(wrapped)) {
                LOGGER.error("Failed to wrap {} via getter {} using type {}", source, getter, (Object)this.name);
            }
            return (A)wrapped;
        }

        public <A extends AbstractWrapped<?>> Collection<A> wrapCollectionGetter(@Nullable Object source, @Nullable Function<Object, Collection<?>> getter) {
            Collection<?> collection = Objects.nonNull(source) && Objects.nonNull(getter) ? getter.apply(source) : null;
            return WrapperHelper.wrapCollection(collection, this);
        }

        static {
            ALIAS_MAP = new HashMap<String, WrapperType>();
        }
    }
}

