/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.fabric.core;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import mods.thecomputerizer.theimpossiblelibrary.api.core.ClassHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.Hacks;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILDev;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.core.loader.MultiVersionModCandidate;
import mods.thecomputerizer.theimpossiblelibrary.api.core.loader.MultiVersionModInfo;
import mods.thecomputerizer.theimpossiblelibrary.api.io.FileHelper;
import mods.thecomputerizer.theimpossiblelibrary.fabric.common.TILCommonEntryPointFabricTest;
import mods.thecomputerizer.theimpossiblelibrary.fabric.core.asm.TILFabricASMTarget;
import mods.thecomputerizer.theimpossiblelibrary.fabric.core.asm.TILFabricCoreModLoader;
import mods.thecomputerizer.theimpossiblelibrary.fabric.core.loader.TILModInjectorFabric;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.LanguageAdapter;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.impl.FabricLoaderImpl;
import net.fabricmc.loader.impl.ModContainerImpl;
import net.fabricmc.loader.impl.discovery.ModCandidateImpl;
import net.fabricmc.loader.impl.entrypoint.EntrypointStorage;
import net.fabricmc.loader.impl.launch.FabricLauncher;
import net.fabricmc.loader.impl.launch.FabricLauncherBase;
import net.fabricmc.loader.impl.metadata.DependencyOverrides;
import net.fabricmc.loader.impl.metadata.EntrypointMetadata;
import net.fabricmc.loader.impl.metadata.LoaderModMetadata;
import net.fabricmc.loader.impl.metadata.ModMetadataParser;
import net.fabricmc.loader.impl.metadata.ParseMetadataException;
import net.fabricmc.loader.impl.metadata.VersionOverrides;
import net.fabricmc.loader.impl.util.UrlUtil;
import net.fabricmc.loader.impl.util.log.Log;
import net.fabricmc.loader.impl.util.log.LogCategory;
import org.jetbrains.annotations.Nullable;

@IndirectCallers
public class TILLanguageAdaptorFabric
implements LanguageAdapter {
    private static final String BURNINGWAVE = "org.burningwave.core.assembler.StaticComponentContainer";
    private static final String BURNINGWAVE_DRIVER = "org.burningwave.jvm.NativeDriver";
    private static final String CORE = "mods.thecomputerizer.theimpossiblelibrary.api.core.CoreAPI";
    private static final String TOOLFACTORY = "io.github.toolfactory.jvm.Info";
    private final CoreAPI core;
    Collection<ModContainerImpl> queuedContainers;

    public TILLanguageAdaptorFabric() {
        FabricLauncher launcher = FabricLauncherBase.getLauncher();
        String target = this.addCoreSources(launcher);
        this.core = this.scheduleContainers(this.initializeCore(launcher.getTargetClassLoader(), target));
        if (Objects.nonNull(this.core)) {
            TILDev.logInfo("Successfully instantiated multiversionAdaptor", new Object[0]);
        }
    }

    String addCoreSources(FabricLauncher launcher) {
        if (Boolean.parseBoolean(System.getProperty("til.dev"))) {
            ClassLoader loader = ClassLoader.getSystemClassLoader();
            for (String className : new String[]{TOOLFACTORY, BURNINGWAVE, BURNINGWAVE_DRIVER, CORE}) {
                try {
                    Class<?> clazz = loader.loadClass(className);
                    this.addSource(launcher, clazz.getProtectionDomain().getCodeSource().getLocation());
                }
                catch (Exception ex) {
                    throw new RuntimeException("Failed to load class " + className, ex);
                }
            }
        }
        return this.addMoreSources(launcher);
    }

    String addMoreSources(FabricLauncher launcher) {
        String version = FabricLoaderImpl.INSTANCE.getGameProvider().getNormalizedGameVersion().split("-")[0];
        String className = CoreAPI.findLoadingClass(CoreAPI.ModLoader.FABRIC, version);
        ClassLoader loader = launcher.getTargetClassLoader();
        for (Class clazz = (Class)Hacks.checkBurningWaveInitAndCall("findClass", className, loader); Objects.nonNull(clazz) && clazz != Object.class; clazz = clazz.getSuperclass()) {
            this.addSource(launcher, ClassHelper.getSourceURL(className, loader));
            String name = clazz.getName();
            if (!CoreAPI.class.getName().equals(name)) continue;
            break;
        }
        return className;
    }

    void addSource(FabricLauncher launcher, @Nullable URL url) {
        if (Objects.nonNull(url)) {
            try {
                launcher.addToClassPath(UrlUtil.asPath((URL)url), new String[0]);
                Log.debug((LogCategory)LogCategory.ENTRYPOINT, (String)("Added loader source " + url));
            }
            catch (Exception ex) {
                Log.error((LogCategory)LogCategory.ENTRYPOINT, (String)("Failed to add " + url + " to the classpath"), (Throwable)ex);
            }
        }
    }

    void addTransformer(FabricLoader loader, CoreAPI core) {
        if (loader instanceof FabricLoaderImpl) {
            TILFabricCoreModLoader.patchTransformer((FabricLoaderImpl)loader, core);
        } else {
            TILRef.logError("Unknown FabricLoader type! Cannot add coremod transformer patch to {}", loader);
        }
    }

    JsonObject buildDependencies(String modid) {
        JsonObject json = new JsonObject();
        json.addProperty("fabric", "*");
        json.addProperty("fabricloader", ">=0.14.0");
        json.addProperty("java", ">=8");
        json.addProperty("minecraft", ">=1.16.5");
        if (!"theimpossiblelibrary".equals(modid)) {
            json.addProperty("theimpossiblelibrary", ">=0.4.6");
        }
        return json;
    }

    void buildEntryPoint(JsonObject json, String name, String ... entryPoints) {
        JsonArray array = new JsonArray();
        for (String entryPoint : entryPoints) {
            JsonObject entry = new JsonObject();
            entry.addProperty("adapter", "multiversionAdaptor");
            entry.addProperty("value", entryPoint);
            array.add((JsonElement)entry);
        }
        json.add(name, (JsonElement)array);
    }

    JsonObject buildEntryPoints(CoreAPI core, MultiVersionModInfo info) {
        JsonObject json = new JsonObject();
        String mainClasspath = info.getModClasspath();
        this.buildEntryPoint(json, "main", mainClasspath);
        if (core.isClientSide() && info.isClient()) {
            this.buildEntryPoint(json, "client", mainClasspath + "$LoaderClient");
        } else if (core.isServerSide() && info.isServer()) {
            this.buildEntryPoint(json, "server", mainClasspath + "$LoaderServer");
        }
        return json;
    }

    JsonObject buildEntryPointTests(CoreAPI core) {
        JsonObject json = new JsonObject();
        String mainClasspath = TILCommonEntryPointFabricTest.class.getName();
        this.buildEntryPoint(json, "main", mainClasspath);
        if (core.isClientSide()) {
            this.buildEntryPoint(json, "client", mainClasspath + "$LoaderClient");
        } else if (core.isServerSide()) {
            this.buildEntryPoint(json, "server", mainClasspath + "$LoaderServer");
        }
        return json;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    LoaderModMetadata buildMetaData(CoreAPI core, MultiVersionModCandidate candidate, MultiVersionModInfo info, VersionOverrides versionOverrides, DependencyOverrides dependencyOverrides) {
        Gson gson = new GsonBuilder().disableHtmlEscaping().setLenient().setPrettyPrinting().create();
        JsonObject json = new JsonObject();
        String modid = info.getModID();
        json.addProperty("schemaVersion", (Number)1);
        json.addProperty("description", info.getDescription());
        json.addProperty("environment", "*");
        json.addProperty("icon", "logo.png");
        json.addProperty("id", modid);
        json.addProperty("license", info.getLicense());
        json.addProperty("name", info.getName());
        json.addProperty("version", info.getVersion());
        json.add("depends", (JsonElement)this.buildDependencies(modid));
        if (Objects.nonNull(System.getProperty("til.dev.testModLoading"))) {
            json.add("entrypoints", (JsonElement)this.buildEntryPointTests(core));
        } else {
            json.add("entrypoints", (JsonElement)this.buildEntryPoints(core, info));
        }
        this.buildModClasses(core, candidate, info);
        try (ByteArrayInputStream stream = new ByteArrayInputStream(gson.toJson((JsonElement)json).getBytes(StandardCharsets.UTF_8));){
            Path path = candidate.getFile().toPath();
            LoaderModMetadata loaderModMetadata = ModMetadataParser.parseMetadata((InputStream)stream, (String)path.toString(), null, (VersionOverrides)versionOverrides, (DependencyOverrides)dependencyOverrides, (boolean)TILDev.DEV);
            return loaderModMetadata;
        }
        catch (IOException ex) {
            TILRef.logError("Failed to read mod metadata from stream of {}", json, ex);
            return null;
        }
        catch (ParseMetadataException ex) {
            TILRef.logError("Failed to parse mod metadata from stream of {}", new Object[]{json, ex});
        }
        return null;
    }

    void buildModClasses(CoreAPI core, MultiVersionModCandidate candidate, MultiVersionModInfo info) {
        for (Map.Entry<String, byte[]> classBytes : core.getModData(new File("."), candidate, info).writeModClass()) {
            String name = classBytes.getKey();
            TILFabricASMTarget.registerDefinition(name, classBytes.getValue());
            TILRef.logInfo("Built mod entrypoint at {}", name);
        }
    }

    @Nullable
    ModCandidateImpl buildCandidate(List<Path> paths, LoaderModMetadata metadata, String modid) {
        TILRef.logDebug("Successfully built mod metadata for {}! Attempting some reflection magic", modid);
        try {
            return (ModCandidateImpl)Hacks.invokeStaticDirect(ModCandidateImpl.class, "createPlain", paths, metadata, FabricLoaderImpl.INSTANCE.isDevelopmentEnvironment(), Collections.emptyList());
        }
        catch (Throwable t) {
            TILRef.logFatal("Failed to build mod candidate for {}!", metadata.getId(), t);
            return null;
        }
    }

    void buildCandidateContainer(Collection<ModContainerImpl> containers, MultiVersionModCandidate candidate, MultiVersionModInfo info, BiFunction<MultiVersionModCandidate, MultiVersionModInfo, LoaderModMetadata> metaBuilder) {
        ModContainerImpl container = this.buildCandidateContainer(candidate, info, metaBuilder);
        if (Objects.nonNull(container)) {
            TILRef.logInfo("Successfully built mod container for {}!", info.getModID());
            containers.add(container);
        } else {
            TILRef.logError("Failed to build mod container for {}", info.getModID());
        }
    }

    @Nullable
    ModContainerImpl buildCandidateContainer(MultiVersionModCandidate candidate, MultiVersionModInfo info, BiFunction<MultiVersionModCandidate, MultiVersionModInfo, LoaderModMetadata> metaBuilder) {
        ArrayList<Path> paths = new ArrayList<Path>();
        this.loadCandidatePath(candidate, paths);
        return this.buildContainer(paths, metaBuilder.apply(candidate, info), info.getModID());
    }

    Collection<ModContainerImpl> buildCandidateContainers(CoreAPI core, BiFunction<MultiVersionModCandidate, MultiVersionModInfo, LoaderModMetadata> metaBuilder) {
        ArrayList<ModContainerImpl> containers = new ArrayList<ModContainerImpl>();
        for (Map.Entry<MultiVersionModCandidate, Collection<MultiVersionModInfo>> fileEntry : core.getModInfo().entrySet()) {
            for (MultiVersionModInfo info : fileEntry.getValue()) {
                this.buildCandidateContainer(containers, fileEntry.getKey(), info, metaBuilder);
            }
        }
        return containers;
    }

    @Nullable
    ModContainerImpl buildContainer(List<Path> paths, LoaderModMetadata metadata, String modid) {
        ModCandidateImpl candidate = this.buildCandidate(paths, metadata, modid);
        if (Objects.nonNull(candidate)) {
            TILRef.logDebug("Successfully built ModCandidateImpl instance for {}", modid);
            return new ModContainerImpl(candidate);
        }
        return null;
    }

    public <T> T create(ModContainer mod, String value, Class<T> type) {
        Object instance = Hacks.constructWithLoader(value, FabricLauncherBase.getLauncher().getTargetClassLoader(), new Object[0]);
        if (instance instanceof TILModInjectorFabric && Objects.nonNull(this.queuedContainers)) {
            TILDev.logInfo("Queuing {} new mod containers", this.queuedContainers.size());
            ((TILModInjectorFabric)instance).setContainers(this.queuedContainers);
        }
        return instance;
    }

    CoreAPI initializeCore(ClassLoader targetLoader, String classname) {
        CoreAPI core = null;
        Object[] failureArgs = new Object[]{classname, targetLoader};
        try {
            core = (CoreAPI)Hacks.construct(Hacks.findClass(classname, targetLoader, true), new Object[0]);
        }
        catch (Throwable t) {
            failureArgs = new Object[]{classname, targetLoader, t};
        }
        if (Objects.isNull(core)) {
            TILRef.logFatal("Failed to initialize CoreAPI instance for {} on {}!", failureArgs);
            return null;
        }
        TILRef.logInfo("Loading core mods", new Object[0]);
        core.loadCoreModInfo(targetLoader);
        core.instantiateCoreMods();
        this.addTransformer(FabricLoader.getInstance(), core);
        TILRef.logDebug("Writing mods", new Object[0]);
        core.writeModContainers(targetLoader);
        return core;
    }

    Collection<ModContainerImpl> loadCandidateInfos(CoreAPI core) {
        TILRef.logDebug("Finding multiversion mod candidates", new Object[0]);
        Collection<ModContainerImpl> containers = this.buildCandidateContainers(core, (candidate, info) -> this.buildMetaData(core, (MultiVersionModCandidate)candidate, (MultiVersionModInfo)info, new VersionOverrides(), new DependencyOverrides(FabricLoaderImpl.INSTANCE.getConfigDir())));
        TILRef.logInfo("Built {} multiversion mod containers", containers.size());
        TILFabricASMTarget.loadDefinitions();
        return containers;
    }

    void loadCandidatePath(MultiVersionModCandidate candidate, List<Path> paths) {
        if (TILDev.DEV) {
            try {
                URL url = ClassHelper.getSourceURL(CoreAPI.class);
                if (Objects.nonNull(url)) {
                    paths.add(FileHelper.toPath(url));
                }
            }
            catch (Exception ex) {
                TILRef.logError("Failed to get path for {}", this.core.getClass());
            }
        } else {
            paths.add(candidate.getFile().toPath());
        }
    }

    void scheduleContainer(EntrypointStorage storage, ModContainerImpl container, String entryPoint, EntrypointMetadata metadata, Map<String, LanguageAdapter> adaptors) {
        try {
            storage.add(container, entryPoint, metadata, adaptors);
        }
        catch (Exception ex) {
            String modid = container.getMetadata().getId();
            TILRef.logError("Failed to add entrypoint {} {} for {}", metadata, metadata.getValue(), modid, ex);
        }
    }

    void scheduleContainer(EntrypointStorage storage, ModContainerImpl container, Collection<String> entryPoints, Map<String, LanguageAdapter> adaptors, Function<String, Collection<EntrypointMetadata>> metaGetter) {
        for (String entryPoint : entryPoints) {
            for (EntrypointMetadata metadata : metaGetter.apply(entryPoint)) {
                this.scheduleContainer(storage, container, entryPoint, metadata, adaptors);
            }
        }
    }

    void scheduleContainers(Collection<ModContainerImpl> containers, Map<String, ModContainerImpl> modMap, EntrypointStorage storage, Map<String, LanguageAdapter> adaptors) {
        for (ModContainerImpl container : containers) {
            LoaderModMetadata metadata = container.getMetadata();
            modMap.put(metadata.getId(), container);
            this.scheduleContainer(storage, container, metadata.getEntrypointKeys(), adaptors, arg_0 -> ((LoaderModMetadata)metadata).getEntrypoints(arg_0));
        }
    }

    CoreAPI scheduleContainers(@Nullable CoreAPI core) {
        if (Objects.isNull(core)) {
            return null;
        }
        Collection<ModContainerImpl> containers = this.loadCandidateInfos(core);
        Map modMap = (Map)Hacks.getFieldDirect(FabricLoaderImpl.INSTANCE, "modMap");
        EntrypointStorage storage = (EntrypointStorage)Hacks.getFieldDirect(FabricLoaderImpl.INSTANCE, "entrypointStorage");
        HashMap<String, LanguageAdapter> adapters = new HashMap<String, LanguageAdapter>();
        adapters.put("multiversionAdaptor", this);
        this.scheduleContainers(containers, modMap, storage, adapters);
        TILRef.logDebug("Adding {} mod containers to the queue", containers.size());
        if (Objects.isNull(this.queuedContainers)) {
            this.queuedContainers = containers;
        } else {
            this.queuedContainers.addAll(containers);
        }
        return core;
    }
}

