/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.fabric.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.Hacks;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILDev;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.network.NetworkAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.network.NetworkHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.network.message.MessageAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.network.message.MessageDirectionInfo;
import mods.thecomputerizer.theimpossiblelibrary.api.network.message.MessageWrapperAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.resource.ResourceHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.resource.ResourceLocationAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.tag.CompoundTagAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.tag.TagHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.util.GenericUtils;
import mods.thecomputerizer.theimpossiblelibrary.api.wrappers.BasicMutableWrapped;
import mods.thecomputerizer.theimpossiblelibrary.api.wrappers.MutableWrapped;
import mods.thecomputerizer.theimpossiblelibrary.fabric.network.MessageWrapperFabric;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public interface FabricNetwork<N, DIR>
extends NetworkAPI<N, DIR> {
    public static final String IMPL_CLIENT = FabricNetwork.fabricPkg("impl.networking.client.ClientNetworkingImpl");
    public static final Class<?> IMPL_CLIENT_CLASS = FabricNetwork.getClassIfClient(IMPL_CLIENT);
    public static final String IMPL_SERVER = FabricNetwork.fabricPkg("impl.networking.server.ServerNetworkingImpl");
    public static final Class<?> IMPL_SERVER_CLASS = FabricNetwork.tryGetClass(IMPL_SERVER);
    public static final Object CLIENT_LOGIN = FabricNetwork.getStaticField(IMPL_CLIENT_CLASS, "LOGIN");
    public static final Object CLIENT_PLAY = FabricNetwork.getStaticField(IMPL_CLIENT_CLASS, "PLAY");
    public static final boolean NAMED_ENV = CoreAPI.isNamedEnv();
    public static final String PLAY_CLIENT = FabricNetwork.fabricPkg("api.client.networking.v1.ClientPlayNetworking");
    public static final Class<?> PLAY_CLIENT_CLASS = FabricNetwork.getClassIfClient(PLAY_CLIENT);
    public static final Class<?> PLAY_CLIENT_HANDLER_CLASS = FabricNetwork.getHandlerClassIfClient(PLAY_CLIENT, "PlayChannelHandler", "PlayPayloadHandler");
    public static final Map<class_2960, Object> PROXY_MAP = new HashMap<class_2960, Object>();
    public static final String PLAY_SERVER = FabricNetwork.fabricPkg("api.networking.v1.ServerPlayNetworking");
    public static final Class<?> PLAY_SERVER_CLASS = FabricNetwork.tryGetClass(PLAY_SERVER);
    public static final Class<?> PLAY_SERVER_HANDLER_CLASS = FabricNetwork.tryGetHandlerClass(PLAY_SERVER, "PlayChannelHandler", "PlayPayloadHandler");
    public static final Object SERVER_LOGIN = FabricNetwork.getStaticField(IMPL_SERVER_CLASS, "LOGIN");
    public static final Object SERVER_PLAY = FabricNetwork.getStaticField(IMPL_SERVER_CLASS, "PLAY");
    public static final class_2505 UNLIMITED_ACCOUNTER = FabricNetwork.unlimitedAccounter();
    public static final MutableWrapped<Class<?>> WRAPPED_WRAPPER_CLASS = new BasicMutableWrapped();

    public static boolean atLeastV20_4() {
        return CoreAPI.isVersionAtLeast(CoreAPI.GameVersion.V20_4);
    }

    public static boolean atLeastV20_6() {
        return CoreAPI.isVersionAtLeast(CoreAPI.GameVersion.V20_6);
    }

    public static String fabricPkg(String pkg) {
        return "net.fabricmc.fabric." + pkg;
    }

    @Nullable
    public static Class<?> getClassIfClient(String className) {
        return CoreAPI.isClient() ? FabricNetwork.tryGetClass(className) : null;
    }

    @Nullable
    public static Class<?> getHandlerClassIfClient(String baseClass, String oldHandler, String newHandler) {
        return CoreAPI.isClient() ? FabricNetwork.tryGetHandlerClass(baseClass, oldHandler, newHandler) : null;
    }

    @Nullable
    public static Object getStaticField(@Nullable Class<?> c, String fieldName) {
        try {
            return Hacks.CallStrategy.STATIC.get(c, fieldName);
        }
        catch (Throwable t) {
            TILRef.logError("Failed to get static field {} for {}", fieldName, c, t);
            return null;
        }
    }

    public static Class<?> getWrapperClass() {
        Class<?> wrapperClass = WRAPPED_WRAPPER_CLASS.getWrapped();
        if (Objects.isNull(wrapperClass)) {
            wrapperClass = FabricNetwork.initWrapperClass(CoreAPI.getInstance());
            WRAPPED_WRAPPER_CLASS.setWrapped(wrapperClass);
        }
        return wrapperClass;
    }

    public static Class<?> initWrapperClass(CoreAPI core) {
        Supplier<String> packageGetter;
        Function<String, String> classNameGetter;
        if (Objects.isNull(core)) {
            TILRef.logError("Cannot initialize MessageWrapper class with null CoreAPI instance!", new Object[0]);
            return null;
        }
        CoreAPI.GameVersion version = core.getVersion();
        switch (version) {
            case V20_6: {
                classNameGetter = version::withClassExt;
                packageGetter = () -> version.getPackageName(core.getModLoader().getPackageName());
                break;
            }
            case V21_1: {
                classNameGetter = className -> version.withClassExt((String)className, false);
                packageGetter = () -> version.getPackageName(core.getModLoader().getPackageName(), false);
                break;
            }
            default: {
                return MessageWrapperFabric.class;
            }
        }
        String className2 = classNameGetter.apply(packageGetter.get() + ".network.MessageWrapperFabric");
        Class wrapperClass = Hacks.findClass(className2);
        if (Objects.isNull(wrapperClass)) {
            TILRef.logError("Failed to find MessageWrapper class {}", className2);
        }
        return wrapperClass;
    }

    @Nullable
    public static Class<?> tryGetClass(String className) {
        Class c;
        try {
            c = Hacks.findClass(className);
        }
        catch (Throwable t) {
            TILRef.logError("Failed to get class {}", className, t);
            return null;
        }
        if (Objects.isNull(c)) {
            TILRef.logError("Failed to get class {}", className);
        }
        return c;
    }

    @Nullable
    public static Class<?> tryGetHandlerClass(String baseClass, String oldHandler, String newHandler) {
        return FabricNetwork.tryGetClass(baseClass + "$" + (FabricNetwork.atLeastV20_6() ? newHandler : oldHandler));
    }

    public static class_2505 unlimitedAccounter() {
        return FabricNetwork.atLeastV20_4() ? (class_2505)Hacks.CallStrategy.STATIC_DIRECT.invoke(class_2505.class, NAMED_ENV ? "unlimitedHeap" : "method_53898") : (class_2505)Hacks.CallStrategy.STATIC_DIRECT.get(class_2505.class, NAMED_ENV ? "UNLIMITED" : "field_11556");
    }

    @Nullable
    default public Object createHandlerProxy(DIR dir, boolean newType) {
        boolean client;
        if (Objects.isNull(dir)) {
            return null;
        }
        return this.createHandlerProxy(dir, newType, client, (client = this.isDirToClient(dir)) ? PLAY_CLIENT_HANDLER_CLASS : PLAY_SERVER_HANDLER_CLASS);
    }

    @Nullable
    default public Object createHandlerProxy(Object dir, boolean newType, boolean client, @Nullable Class<?> c) {
        if (Objects.isNull(c)) {
            TILRef.logError("Cannot create proxy with null class for {} dir {}", client ? "client" : "server", dir);
            return null;
        }
        InvocationHandler invoker = newType ? this.createInvokerCustomPayload(dir, client, c) : this.createInvoker(dir, client, c);
        return Proxy.newProxyInstance(c.getClassLoader(), new Class[]{c}, invoker);
    }

    default public InvocationHandler createInvoker(Object dir, boolean client, Class<?> c) {
        return (proxy, method, args) -> {
            String methodName = method.getName();
            if (!"receive".equals(methodName)) {
                TILRef.logDebug("InvocationHandler method '{}' was not 'receive'", methodName);
                try {
                    return method.invoke(proxy, args);
                }
                catch (Throwable t) {
                    TILRef.logError("Failed to execute non receive method ({}) for InvocationHandler", methodName, t);
                    return null;
                }
            }
            try {
                this.receiveAndRespond(dir, args[client ? 2 : 3], args[client ? 3 : 4], client ? null : args[1]);
                TILRef.logDebug("InvocationHandler success for {} ({})", dir, c);
            }
            catch (Throwable t) {
                TILRef.logError("Failed to execute InvocationHandler for proxy instance of {} (direction={})", c, dir, t);
            }
            return null;
        };
    }

    default public InvocationHandler createInvokerCustomPayload(Object dir, boolean client, Class<?> c) {
        return (proxy, method, args) -> {
            String methodName = method.getName();
            if (!"receive".equals(methodName)) {
                TILRef.logDebug("InvocationHandler method '{}' was not 'receive'", methodName);
                try {
                    return method.invoke(proxy, args);
                }
                catch (Throwable t) {
                    TILRef.logError("Failed to execute non receive method ({}) for InvocationHandler", methodName, t);
                    return null;
                }
            }
            try {
                this.receiveAndRespondGeneric(args[0], Hacks.invoke(args[1], "responseSender", new Object[0]), client ? null : Hacks.invoke(args[1], "player", new Object[0]));
                TILRef.logDebug("InvocationHandler success for {} ({})", dir, c);
            }
            catch (Throwable t) {
                TILRef.logError("Failed to execute InvocationHandler for proxy instance of {} (direction={})", c, dir, t);
            }
            return null;
        };
    }

    default public class_2540 encodeMessage(MessageWrapperAPI<?, ?> message) {
        class_2540 buf = PacketByteBufs.create();
        message.encode((ByteBuf)buf);
        return buf;
    }

    @Nullable
    default public DIR getCheckedDir(MessageDirectionInfo<DIR> info) {
        if (Objects.isNull(info)) {
            return null;
        }
        DIR dir = info.getDirection();
        return (DIR)(this.isDirToClient(dir) ? (CoreAPI.isClient() ? dir : null) : dir);
    }

    @Override
    default public DIR getDirFromName(String name) {
        switch (name.toUpperCase()) {
            case "LOGIN_TO_CLIENT": {
                return (DIR)CLIENT_LOGIN;
            }
            case "LOGIN_TO_SERVER": {
                return (DIR)SERVER_LOGIN;
            }
            case "PLAY_TO_SERVER": {
                return (DIR)SERVER_PLAY;
            }
        }
        return (DIR)CLIENT_PLAY;
    }

    @Override
    @Nullable
    default public DIR getDirToClient() {
        return (DIR)CLIENT_PLAY;
    }

    @Override
    @Nullable
    default public DIR getDirToClientLogin() {
        return (DIR)CLIENT_LOGIN;
    }

    @Override
    default public DIR getDirToServer() {
        return (DIR)SERVER_PLAY;
    }

    @Override
    default public DIR getDirToServerLogin() {
        return (DIR)SERVER_LOGIN;
    }

    @Override
    default public String getNameFromDir(DIR dir) {
        if (dir == CLIENT_LOGIN) {
            return "LOGIN_TO_CLIENT";
        }
        if (dir == CLIENT_PLAY) {
            return "PLAY_TO_CLIENT";
        }
        if (dir == SERVER_LOGIN) {
            return "LOGIN_TO_SERVER";
        }
        return "PLAY_TO_SERVER";
    }

    @Override
    @Nullable
    default public N getNetwork() {
        return null;
    }

    @Override
    @Nullable
    default public DIR getOppositeDir(DIR dir) {
        if (dir == CLIENT_LOGIN) {
            return (DIR)SERVER_LOGIN;
        }
        if (dir == CLIENT_PLAY) {
            return (DIR)SERVER_PLAY;
        }
        if (dir == SERVER_LOGIN) {
            return (DIR)CLIENT_LOGIN;
        }
        return (DIR)CLIENT_PLAY;
    }

    default public class_2960 getRegistryName(MessageWrapperAPI<?, ?> message) {
        if (Objects.isNull(message)) {
            TILRef.logError("Cannot get registry name from null MessageWrapper!", new Object[0]);
            return null;
        }
        return ((MessageWrapperFabric)message).getRegistryName();
    }

    default public class_2960 getRegistryNameFromDir(Object dir) {
        return this.getRegistryName(this.getWrapper(dir));
    }

    default public <CTX> MessageWrapperAPI<?, CTX> getWrapper(Object dir) {
        Class<?> wrapperClass = FabricNetwork.getWrapperClass();
        if (Objects.isNull(wrapperClass)) {
            TILRef.logError("Cannot get direction-based registry name from null MessageWrapper class!", new Object[0]);
            return null;
        }
        return (MessageWrapperAPI)Hacks.CallStrategy.STATIC.invoke(wrapperClass, "getInstance", this, dir);
    }

    @Override
    default public boolean isDirToClient(DIR dir) {
        return dir == CLIENT_PLAY || dir == CLIENT_LOGIN;
    }

    @Override
    default public boolean isDirLogin(DIR dir) {
        return dir == CLIENT_LOGIN || dir == SERVER_LOGIN;
    }

    @Override
    default public ResourceLocationAPI<?> readResourceLocation(ByteBuf buf) {
        return ResourceHelper.getResource(NetworkHelper.readString(buf));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    default public CompoundTagAPI<?> readTag(ByteBuf buf) {
        class_2505 accounter;
        if (Objects.isNull(buf)) {
            TILRef.logWarn("Tried to read tag from null ByteBuf", new Object[0]);
            return TagHelper.makeCompoundTag();
        }
        class_2505 class_25052 = accounter = Objects.nonNull(UNLIMITED_ACCOUNTER) ? UNLIMITED_ACCOUNTER : FabricNetwork.unlimitedAccounter();
        if (Objects.isNull(accounter)) {
            TILRef.logWarn("Cannot read tag with null UNLIMITED_ACCOUNTER field", new Object[0]);
            return TagHelper.makeCompoundTag();
        }
        try (ByteBufInputStream stream = new ByteBufInputStream(buf);){
            class_2487 tag = class_2507.method_10625((DataInput)stream, (class_2505)accounter);
            if (!Objects.nonNull(tag)) return TagHelper.makeCompoundTag();
            CompoundTagAPI compoundTagAPI = (CompoundTagAPI)TagHelper.getWrapped(tag);
            return compoundTagAPI;
        }
        catch (Exception ex) {
            TILRef.logError("Failed to write tag to buffer", ex);
        }
        return TagHelper.makeCompoundTag();
    }

    default public <P, CTX, M extends MessageWrapperAPI<P, CTX>> void receiveAndRespond(Object dir, Object buf, CTX ctx, @Nullable P player) {
        Class<?> wrapperClass = FabricNetwork.getWrapperClass();
        if (Objects.isNull(wrapperClass)) {
            return;
        }
        MessageWrapperAPI wrapper = (MessageWrapperAPI)Hacks.CallStrategy.STATIC_DIRECT.invoke(wrapperClass, "getInstance", this, dir, buf);
        this.receiveAndRespond(wrapper, ctx, player);
    }

    default public <P, CTX, M extends MessageWrapperAPI<P, CTX>> void receiveAndRespond(M wrapper, CTX ctx, @Nullable P player) {
        MessageWrapperAPI<P, CTX> response = wrapper.handle(ctx);
        if (Objects.nonNull(response)) {
            if (Objects.nonNull(player)) {
                response.setPlayer(player);
            }
            response.send();
        }
    }

    default public <P, CTX, M extends MessageWrapperAPI<P, CTX>> void receiveAndRespondGeneric(@Nullable Object wrapper, @Nullable Object ctx, @Nullable Object player) {
        MessageWrapperAPI wrapperCast = (MessageWrapperAPI)GenericUtils.cast(wrapper);
        Object ctxCast = GenericUtils.cast(ctx);
        Object playerCast = GenericUtils.cast(player);
        if (Objects.nonNull(wrapperCast)) {
            this.receiveAndRespond(wrapperCast, ctxCast, playerCast);
        }
    }

    @Override
    default public void registerLateMessages(Collection<MessageDirectionInfo<DIR>> infos) {
        for (MessageDirectionInfo<DIR> dirInfo : infos) {
            this.registerMessage(dirInfo, false);
        }
    }

    @Override
    default public void registerMessage(MessageDirectionInfo<DIR> dirInfo, int id) {
        this.registerMessage(dirInfo, true);
    }

    default public void registerMessage(MessageDirectionInfo<DIR> dirInfo, boolean warnDuplicate) {
        DIR dir = this.getCheckedDir(dirInfo);
        if (Objects.isNull(dir)) {
            return;
        }
        class_2960 registryName = this.getRegistryNameFromDir(dir);
        if (Objects.isNull(registryName)) {
            return;
        }
        if (PROXY_MAP.containsKey(registryName)) {
            if (warnDuplicate) {
                TILRef.logWarn("Tried to register duplicate sided network receiver {}", registryName);
            } else if (TILDev.DEBUG_NETWORK) {
                TILRef.logDebug("Tried to register duplicate sided network receiver {}", registryName);
            }
            return;
        }
        Object proxy = this.createHandlerProxy(dir, false);
        if (Objects.isNull(proxy)) {
            TILRef.logError("Failed to create PlayChannelHandler proxy for dirction {} ({})", dir, registryName);
            return;
        }
        if (this.registerWithProxy(this.isDirToClient(dir), registryName, proxy)) {
            PROXY_MAP.put(registryName, proxy);
        }
    }

    default public void registerMessageCustomPayload(MessageDirectionInfo<DIR> directionInfo, Function<DIR, Object> codecBuilder) {
        DIR dir = this.getCheckedDir(directionInfo);
        if (Objects.isNull(dir)) {
            return;
        }
        MessageWrapperAPI wrapper = this.getWrapper(dir);
        if (Objects.isNull(wrapper)) {
            return;
        }
        class_2960 registryName = this.getRegistryName(wrapper);
        if (Objects.isNull(registryName)) {
            return;
        }
        if (PROXY_MAP.containsKey(registryName)) {
            TILRef.logWarn("Tried to register sided network receiver {} twice!", registryName);
            return;
        }
        Object type = Hacks.invoke(wrapper, NAMED_ENV ? "type" : "method_56479", new Object[0]);
        if (Objects.isNull(type)) {
            return;
        }
        String registryClassName = FabricNetwork.fabricPkg("api.networking.v1.PayloadTypeRegistry");
        Class<?> c = FabricNetwork.tryGetClass(registryClassName);
        if (Objects.isNull(c)) {
            TILRef.logError("Failed to get class payload registry class {}", registryClassName);
            return;
        }
        boolean client = this.isDirToClient(dir);
        String methodName = "play" + (client ? "S2C" : "C2S");
        Object registry = Hacks.CallStrategy.STATIC.invoke(c, methodName);
        if (Objects.isNull(registry)) {
            TILRef.logError("Failed to get payload registry from {}#{}", registryClassName, methodName);
            return;
        }
        Object codec = codecBuilder.apply(dir);
        try {
            Hacks.invoke(registry, "register", type, codec);
        }
        catch (Throwable t) {
            TILRef.logError("Failed to register payload codec for type {} ({})", type, codec, t);
            return;
        }
        Object proxy = this.createHandlerProxy(dir, true);
        if (Objects.isNull(proxy)) {
            TILRef.logError("Failed to create PlayChannelHandler proxy for dirction {} ({})", dir, registryName);
            return;
        }
        if (this.registerWithProxy(client, type, proxy)) {
            PROXY_MAP.put(registryName, proxy);
        }
    }

    default public boolean registerWithProxy(boolean client, Object registerAs, Object proxy) {
        Class<?> c;
        Class<?> clazz = c = client ? PLAY_CLIENT_CLASS : PLAY_SERVER_CLASS;
        if (Objects.isNull(c)) {
            TILRef.logError("Cannot register PlayChannelHandler proxy to null class!", new Object[0]);
            return false;
        }
        try {
            Hacks.CallStrategy.STATIC.invoke(c, "registerGlobalReceiver", registerAs, proxy);
            return true;
        }
        catch (Throwable t) {
            TILRef.logError("Failed to invoke registerGlobalReceiver for {} using ({},{})", c, registerAs, proxy, t);
            return false;
        }
    }

    @Override
    default public <P, M extends MessageWrapperAPI<?, ?>> void sendToPlayer(M message, P player) {
        this.sendToPlayer(message, player, FabricNetwork.atLeastV20_6());
    }

    default public <P, M extends MessageWrapperAPI<?, ?>> void sendToPlayer(M message, P player, boolean newType) {
        Object[] objectArray;
        if (Objects.isNull(PLAY_SERVER_CLASS)) {
            TILRef.logError("Cannot send message to player {} since class {} was not found", player, PLAY_SERVER);
            return;
        }
        if (Objects.isNull(message)) {
            TILRef.logError("Cannot send null message to {}!", player);
            return;
        }
        if (newType) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = player;
            objectArray = objectArray2;
            objectArray2[1] = message;
        } else {
            Object[] objectArray3 = new Object[3];
            objectArray3[0] = player;
            objectArray3[1] = this.getRegistryName(message);
            objectArray = objectArray3;
            objectArray3[2] = this.encodeMessage(message);
        }
        Object[] args = objectArray;
        Hacks.CallStrategy.STATIC_DIRECT.invoke(PLAY_SERVER_CLASS, "send", args);
    }

    @Override
    default public <M extends MessageWrapperAPI<?, ?>> void sendToServer(M message) {
        this.sendToServer(message, FabricNetwork.atLeastV20_6());
    }

    default public <M extends MessageWrapperAPI<?, ?>> void sendToServer(M message, boolean newType) {
        Object[] objectArray;
        if (Objects.isNull(PLAY_CLIENT_CLASS)) {
            TILRef.logError("Cannot send message to the server since class {} was not found", PLAY_CLIENT);
            return;
        }
        if (Objects.isNull(message)) {
            TILRef.logError("Cannot send null message to the server!", new Object[0]);
            return;
        }
        if (newType) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = message;
        } else {
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = this.getRegistryName(message);
            objectArray = objectArray3;
            objectArray3[1] = this.encodeMessage(message);
        }
        Object[] args = objectArray;
        Hacks.CallStrategy.STATIC_DIRECT.invoke(PLAY_CLIENT_CLASS, "send", args);
    }

    @Override
    default public <CTX> MessageWrapperAPI<?, CTX> wrapMessage(DIR dir, MessageAPI<CTX> message) {
        MessageWrapperAPI<?, CTX> wrapper = this.getWrapper(dir);
        wrapper.setMessage(dir, message);
        return wrapper;
    }

    @Override
    default public <CTX> MessageWrapperAPI<?, CTX> wrapMessages(DIR dir, MessageAPI<CTX> ... messages) {
        MessageWrapperAPI<?, CTX> wrapper = this.getWrapper(dir);
        wrapper.setMessages(dir, messages);
        return wrapper;
    }

    @Override
    default public <CTX> MessageWrapperAPI<?, CTX> wrapMessages(DIR dir, Collection<MessageAPI<CTX>> messages) {
        MessageWrapperAPI<?, CTX> wrapper = this.getWrapper(dir);
        wrapper.setMessages(dir, messages);
        return wrapper;
    }

    @Override
    default public void writeTag(ByteBuf buf, CompoundTagAPI<?> tag) {
        try (ByteBufOutputStream stream = new ByteBufOutputStream(buf);){
            class_2507.method_10628((class_2487)((class_2487)tag.getWrapped()), (DataOutput)stream);
        }
        catch (IOException ex) {
            TILRef.logError("Failed to write tag to buffer", ex);
        }
    }
}

