/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.fabric.v18.m2.server;

import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreStateAccessor;
import mods.thecomputerizer.theimpossiblelibrary.api.core.Hacks;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.server.CommandAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.server.CommandSenderAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.server.MinecraftServerAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.server.ServerHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.wrappers.WrapperHelper;
import net.minecraft.class_2164;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2314;
import net.minecraft.class_2316;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public class WrappedCommand1_18_2
implements CoreStateAccessor {
    private static final Supplier<String> ARGUMENT_TYPE_ENTRY = () -> class_2316.class.getName() + "$" + (!FABRIC || NAMED_ENV ? "Entry" : "class_2317");
    private static final Map<String, CommandAPI> BY_NAME = new HashMap<String, CommandAPI>();
    private static final String FIELD_BY_CLASS;
    private static final String FIELD_BY_NAME;
    private static final CustomSuggesterInfo SERIALIZER;

    public static int execute(CommandContext<class_2168> ctx, CommandAPI wrapped) throws class_2164 {
        wrapped.prepareExceptionInfo();
        String exKey = wrapped.getExceptionKey();
        exKey = Objects.nonNull(exKey) ? exKey : "";
        Object[] exArgs = wrapped.getExceptionArgs();
        try {
            String[] args = WrappedCommand1_18_2.getArgStack(ctx);
            wrapped.execute(ctx, WrappedCommand1_18_2.rebuildInput(args), args[args.length - 1]);
            return 1;
        }
        catch (Exception ex) {
            TILRef.logError("Caught exception for command {}! Rethrowing as CommandException", wrapped.getRootName(), ex);
            throw new class_2164((class_2561)TextHelper.getTranslated(exKey, exArgs).getAsComponent());
        }
    }

    private static ArgumentBuilder<class_2168, ?> getArg(CommandAPI command) {
        ArgumentBuilder<class_2168, ?> arg = WrappedCommand1_18_2.getBuilder(command);
        for (CommandAPI subcmd : command.getSubCommands()) {
            arg.then(WrappedCommand1_18_2.getArg(subcmd));
        }
        if (command.isExecutionNode()) {
            arg.executes(ctx -> WrappedCommand1_18_2.execute((CommandContext<class_2168>)ctx, command));
        }
        return arg;
    }

    private static String[] getArgStack(CommandContext<?> ctx) {
        String input = ctx.getInput();
        if (!input.contains(" ")) {
            return new String[0];
        }
        return input.substring(input.indexOf(" ") + 1).split(" ");
    }

    private static ArgumentBuilder<class_2168, ?> getBuilder(CommandAPI command) {
        String name = command.getName();
        return switch (command.getType()) {
            case CommandAPI.ArgType.BOOLEAN -> class_2170.method_9244((String)name, (ArgumentType)BoolArgumentType.bool());
            case CommandAPI.ArgType.DOUBLE -> class_2170.method_9244((String)name, (ArgumentType)DoubleArgumentType.doubleArg());
            case CommandAPI.ArgType.ENTITY -> class_2170.method_9244((String)name, (ArgumentType)class_2186.method_9309());
            case CommandAPI.ArgType.FLOAT -> class_2170.method_9244((String)name, (ArgumentType)FloatArgumentType.floatArg());
            case CommandAPI.ArgType.INTEGER -> class_2170.method_9244((String)name, (ArgumentType)IntegerArgumentType.integer());
            case CommandAPI.ArgType.LITERAL -> class_2170.method_9247((String)name);
            case CommandAPI.ArgType.LONG -> class_2170.method_9244((String)name, (ArgumentType)LongArgumentType.longArg());
            case CommandAPI.ArgType.PLAYER -> class_2170.method_9244((String)name, (ArgumentType)class_2186.method_9305());
            default -> class_2170.method_9244((String)name, (ArgumentType)new CustomSuggester(command));
        };
    }

    private static String rebuildInput(String ... args) {
        StringJoiner joiner = new StringJoiner(" ");
        for (int i = 0; i < args.length - 1; ++i) {
            joiner.add(args[i]);
        }
        return joiner.toString();
    }

    public static void register(Object dispatcherObj, CommandAPI wrapped) {
        CommandDispatcher dispatcher = (CommandDispatcher)dispatcherObj;
        LiteralArgumentBuilder root = class_2170.method_9247((String)wrapped.getName());
        for (CommandAPI subcmd : wrapped.getSubCommands()) {
            root.then(WrappedCommand1_18_2.getArg(subcmd));
        }
        if (wrapped.isExecutionNode()) {
            root.executes(ctx -> WrappedCommand1_18_2.execute((CommandContext<class_2168>)ctx, wrapped));
        }
        dispatcher.register(root);
        BY_NAME.put(wrapped.getName(), wrapped);
    }

    public static void registerArgType() {
        WrappedCommand1_18_2.registerArgType(new class_2960("theimpossiblelibrary", "custom_suggestor"));
    }

    private static <E> void registerArgType(class_2960 name) {
        Map byClass = (Map)Hacks.getFieldStaticDirect(class_2316.class, FIELD_BY_CLASS);
        Map byName = (Map)Hacks.getFieldStaticDirect(class_2316.class, FIELD_BY_NAME);
        if (Objects.isNull(byClass) || Objects.isNull(byName)) {
            TILRef.logError("Failed to retrieve ArgumentTypes fields! (BY_CLASS = {} | BY_NAME = {})", FIELD_BY_CLASS, FIELD_BY_NAME);
            return;
        }
        String entryClassName = ARGUMENT_TYPE_ENTRY.get();
        Object entry = Hacks.construct(entryClassName, SERIALIZER, name);
        if (Objects.isNull(entry)) {
            TILRef.logError("Failed to contruct {} with args {}", entryClassName, new Object[]{SERIALIZER, name});
            return;
        }
        byClass.put(CustomSuggester.class, entry);
        byName.put(name, entry);
    }

    static {
        String string = NAMED_ENV ? "BY_CLASS" : (FIELD_BY_CLASS = SRG_ENV ? "f_121583_" : "field_10921");
        FIELD_BY_NAME = NAMED_ENV ? "BY_NAME" : (SRG_ENV ? "f_121584_" : "field_10922");
        SERIALIZER = new CustomSuggesterInfo();
    }

    public record CustomSuggester(CommandAPI command) implements ArgumentType<String>
    {
        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> ctx, SuggestionsBuilder builder) {
            MinecraftServerAPI<?> server = ServerHelper.getAPI();
            CommandSenderAPI sender = WrapperHelper.wrapCommandSender(ctx);
            return class_2172.method_9265(this.command.getTabCompletions(server, sender, builder.getInput(), builder.getRemaining()), (SuggestionsBuilder)builder);
        }

        public String parse(StringReader reader) {
            return reader.readUnquotedString();
        }
    }

    public static final class CustomSuggesterInfo
    implements class_2314<CustomSuggester> {
        public void serializeToNetwork(CustomSuggester type, class_2540 buf) {
            buf.method_10814(type.command.getName());
        }

        @NotNull
        public CustomSuggester deserializeFromNetwork(class_2540 buf) {
            return new CustomSuggester(BY_NAME.get(buf.method_19772()));
        }

        public void serializeToJson(CustomSuggester type, JsonObject json) {
            json.addProperty("commandapi", type.command.getName());
        }
    }
}

