/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.forge.common.event;

import java.util.Objects;
import mods.thecomputerizer.theimpossiblelibrary.api.common.event.CommonEventWrapper;
import mods.thecomputerizer.theimpossiblelibrary.api.common.event.EventWrapper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.forge.common.event.events.AttachCapabilitiesEventForge;
import mods.thecomputerizer.theimpossiblelibrary.forge.common.event.events.PlayerInteractBlockEventForge;
import mods.thecomputerizer.theimpossiblelibrary.forge.common.event.events.PlayerInteractEmptyEventForge;
import mods.thecomputerizer.theimpossiblelibrary.forge.common.event.events.PlayerInteractEntityEventForge;
import mods.thecomputerizer.theimpossiblelibrary.forge.common.event.events.PlayerInteractEntitySpecificEventForge;
import mods.thecomputerizer.theimpossiblelibrary.forge.common.event.events.PlayerInteractItemEventForge;
import mods.thecomputerizer.theimpossiblelibrary.forge.common.event.events.PlayerLoggedInEventForge;
import mods.thecomputerizer.theimpossiblelibrary.forge.common.event.events.PlayerLoggedOutEventForge;
import mods.thecomputerizer.theimpossiblelibrary.forge.common.event.events.PlayerNameFormatEventForge;
import mods.thecomputerizer.theimpossiblelibrary.forge.common.event.events.PlayerNameTabFormatEventForge;
import mods.thecomputerizer.theimpossiblelibrary.forge.common.event.events.PlayerPunchBlockEventForge;
import mods.thecomputerizer.theimpossiblelibrary.forge.common.event.events.PlayerPunchEntityEventForge;
import mods.thecomputerizer.theimpossiblelibrary.forge.common.event.events.PlayerPunchItemEventForge;
import mods.thecomputerizer.theimpossiblelibrary.forge.common.event.events.PlayerRespawnEventForge;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import org.jetbrains.annotations.Nullable;

public interface CommonForgeEventHelper {
    default public void defaultEventDefinitions() {
        CommonEventWrapper.CommonType.ATTACH_CAPABILITIES.setConnector(new AttachCapabilitiesEventForge());
        CommonEventWrapper.CommonType.PLAYER_INTERACT_BLOCK.setConnector(new PlayerInteractBlockEventForge());
        CommonEventWrapper.CommonType.PLAYER_INTERACT_EMPTY.setConnector(new PlayerInteractEmptyEventForge());
        CommonEventWrapper.CommonType.PLAYER_INTERACT_ENTITY.setConnector(new PlayerInteractEntityEventForge());
        CommonEventWrapper.CommonType.PLAYER_INTERACT_ENTITY_AT.setConnector(new PlayerInteractEntitySpecificEventForge());
        CommonEventWrapper.CommonType.PLAYER_INTERACT_ITEM.setConnector(new PlayerInteractItemEventForge());
        CommonEventWrapper.CommonType.PLAYER_LOGGED_IN.setConnector(new PlayerLoggedInEventForge());
        CommonEventWrapper.CommonType.PLAYER_LOGGED_OUT.setConnector(new PlayerLoggedOutEventForge());
        CommonEventWrapper.CommonType.PLAYER_NAME_FORMAT.setConnector(new PlayerNameFormatEventForge());
        CommonEventWrapper.CommonType.PLAYER_PUNCH_BLOCK.setConnector(new PlayerPunchBlockEventForge());
        CommonEventWrapper.CommonType.PLAYER_PUNCH_ENTITY.setConnector(new PlayerPunchEntityEventForge());
        CommonEventWrapper.CommonType.PLAYER_PUNCH_ITEM.setConnector(new PlayerPunchItemEventForge());
        CommonEventWrapper.CommonType.PLAYER_RESPAWN.setConnector(new PlayerRespawnEventForge());
        CommonEventWrapper.CommonType.PLAYER_TAB_FORMAT.setConnector(new PlayerNameTabFormatEventForge());
    }

    @Nullable
    default public IEventBus getBusFor(@Nullable Object wrapper) {
        if (Objects.isNull(wrapper)) {
            return MinecraftForge.EVENT_BUS;
        }
        String simpleName = wrapper.getClass().getSimpleName();
        return this.getBusFor(simpleName.substring(0, simpleName.indexOf("Event")));
    }

    @Nullable
    default public IEventBus getBusFor(String simpleClassName) {
        switch (simpleClassName) {
            case "RegisterBlockEntities": 
            case "RegisterBlocks": 
            case "RegisterEntities": 
            case "RegisterItems": 
            case "RegisterSounds": {
                return this.getModBus();
            }
        }
        return MinecraftForge.EVENT_BUS;
    }

    @Nullable
    default public IEventBus getModBus() {
        ModContainer container = ModLoadingContext.get().getActiveContainer();
        if (Objects.isNull(container)) {
            TILRef.logWarn("Active ModContainer not found for current context! Assuming context of {}", "theimpossiblelibrary");
            container = ModList.get().getModContainerById("theimpossiblelibrary").orElse(null);
        }
        if (Objects.isNull(container)) {
            TILRef.logError("Failed to get ModContainer! Event bus will not be returned", new Object[0]);
            return null;
        }
        return this.getModBus(container);
    }

    @Nullable
    public IEventBus getModBus(ModContainer var1);

    default public <E extends EventWrapper<?>> void registerForgeOrModBus(E wrapper) {
        IEventBus bus = this.getBusFor(wrapper);
        if (Objects.nonNull(bus)) {
            bus.register(wrapper.getClass());
        } else {
            TILRef.logError("Unable to find an event bus to register event wrapper {}", wrapper);
        }
    }
}

