/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.forge.core;

import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.security.CodeSigner;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.jar.Manifest;
import lombok.Generated;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILDev;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.forge.core.loader.ForgeModLoading;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.forgespi.locating.IModLocator;
import org.apache.commons.lang3.tuple.Pair;

public class MultiVersionModLocator
implements IModLocator {
    static MultiVersionModLocator instance;
    private Map<IModFile, FileSystem> fileSystems;
    boolean failed;
    boolean initialized;

    static ClassLoader modFileClassLoader(IModFile file) {
        if (Objects.isNull(file)) {
            return IModFile.class.getClassLoader();
        }
        Class<?> cls = file.getClass();
        TILRef.logInfo("Finding ClassLoader for file {}({})", file.getFileName(), cls);
        return ("TILForgeModFile".equals(cls.getSimpleName()) ? ForgeModLoading.class : cls).getClassLoader();
    }

    public MultiVersionModLocator() {
        ClassLoader thisLoader = this.getClass().getClassLoader();
        if (Objects.isNull(instance)) {
            TILRef.logInfo("Core Forge Locator plugin loaded on {}", thisLoader);
            instance = this;
        } else {
            TILRef.logDebug("Extra core Forge Locator plugin loaded on {}", thisLoader);
        }
    }

    FileSystem fileSystemFor(IModFile file) {
        try {
            Path path = file.getFilePath();
            if (TILDev.isLoaderPath(path)) {
                TILRef.logInfo("Subverting the loader file system since this is a dev environment (-Dtil.dev=true)", new Object[0]);
                TILDev.checkDevPath(path);
                return null;
            }
            return FileSystems.newFileSystem(path, MultiVersionModLocator.modFileClassLoader(file));
        }
        catch (IOException ex) {
            TILRef.logError("Could not create file system for {}", file.getFilePath(), ex);
            return null;
        }
    }

    public Optional<Manifest> findManifest(Path path) {
        return (Optional)this.findManifestAndSigners(path).getKey();
    }

    public Pair<Optional<Manifest>, Optional<CodeSigner[]>> findManifestAndSigners(Path path) {
        return Pair.of(ForgeModLoading.findManifest(path), Optional.empty());
    }

    public Path findPath(IModFile modFile, String ... paths) {
        if (paths.length < 1) {
            throw new IllegalArgumentException("Missing path");
        }
        ForgeModLoading.queryCoreMods(paths);
        if (TILDev.DEV && TILDev.isLoaderPath(modFile.getFilePath())) {
            return TILDev.getLoaderResourcePath(paths);
        }
        if (this.fileSystems.containsKey(modFile)) {
            return this.fileSystems.get(modFile).getPath("", paths);
        }
        TILRef.logError("Unable to find paths {} for {}", paths, modFile.getFileName());
        return null;
    }

    public void initArguments(Map<String, ?> arguments) {
        if (this.failed) {
            TILRef.logWarn("Not initializing mod loading for MultiVersionModLocator that failed to load", new Object[0]);
            return;
        }
        this.initialized = ForgeModLoading.initModLoading(this.getClass().getClassLoader(), this, arguments);
    }

    public boolean isValid(IModFile file) {
        return !this.failed;
    }

    public String name() {
        return "multiversionloader";
    }

    public void scanFile(IModFile file, Consumer<Path> consumer) {
    }

    public List<IModFile> scanMods() {
        if (!this.initialized) {
            TILRef.logDebug("Skipping mod scan for uninitialized MultiVersionModLocator", new Object[0]);
            return Collections.emptyList();
        }
        if (this.failed) {
            TILRef.logWarn("Not scanning for mods with MultiVersionModLocator that failed to load", new Object[0]);
            return Collections.emptyList();
        }
        TILRef.logInfo("Scanning for mods", new Object[0]);
        this.fileSystems = Collections.emptyMap();
        try {
            List<IModFile> files = ForgeModLoading.scanMods();
            if (!files.isEmpty() && ForgeModLoading.isPathBased()) {
                this.fileSystems = new HashMap<IModFile, FileSystem>();
                for (IModFile file : files) {
                    FileSystem fs = this.fileSystemFor(file);
                    if (Objects.nonNull(fs)) {
                        this.fileSystems.put(file, fs);
                        continue;
                    }
                    if (TILDev.DEV) continue;
                    TILRef.logWarn("Failed to get FileSystem for {}", file.getFileName());
                }
            }
            TILRef.logInfo("Returing {} scanned mods {}", files.size(), files);
            return files;
        }
        catch (Throwable t) {
            TILRef.logError("Failed to scan mods", t);
            throw t;
        }
    }

    @Generated
    public Map<IModFile, FileSystem> getFileSystems() {
        return this.fileSystems;
    }

    @Generated
    public boolean isFailed() {
        return this.failed;
    }

    @Generated
    public boolean isInitialized() {
        return this.initialized;
    }
}

