/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.forge.core;

import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import mods.thecomputerizer.theimpossiblelibrary.api.core.ClassHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.Hacks;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.forge.core.ForgeCoreLoader;
import mods.thecomputerizer.theimpossiblelibrary.forge.core.loader.ForgeModLoading;
import mods.thecomputerizer.theimpossiblelibrary.forge.core.loader.TILLanguageLoader;
import net.minecraftforge.forgespi.language.ILifecycleEvent;
import net.minecraftforge.forgespi.language.IModLanguageProvider;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.Type;

public class TILLanguageProvider
implements IModLanguageProvider {
    static final Logger LOGGER = TILRef.createLogger("TIL Language Provider (Forge)");
    Object core;

    public TILLanguageProvider() {
        Class<?> c = this.getClass();
        ClassHelper.verifyPackageSelfVersion(c.getPackage());
        LOGGER.debug("Instantiated {} with impl version {}", c, (Object)c.getPackage().getImplementationVersion());
    }

    public <R extends ILifecycleEvent<R>> void consumeLifecycleEvent(Supplier<R> ignored) {
    }

    public Consumer<ModFileScanData> getFileVisitor() {
        boolean pathBased = ForgeModLoading.isPathBased();
        Function<ModFileScanData.AnnotationData, Type> typeMapper = data -> (Type)Hacks.invoke(data, pathBased ? "getAnnotationType" : "annotationType", new Object[0]);
        Function<ModFileScanData.AnnotationData, Type> classTypeMapper = data -> (Type)Hacks.invoke(data, pathBased ? "getClassType" : "clazz", new Object[0]);
        Function<ModFileScanData.AnnotationData, Map> dataMapper = data -> (Map)Hacks.invoke(data, pathBased ? "getAnnotationData" : "annotationData", new Object[0]);
        Type modAnnotation = Type.getType((String)"Lnet/minecraftforge/fml/common/Mod;");
        Class loaderClass = this.getLanguageLoaderClass();
        Function<IModLanguageProvider.IModLanguageLoader, String> loadModIDMapper = loader -> (String)Hacks.invoke(loader, "getModid", new Object[0]);
        return Objects.isNull(loaderClass) ? scan -> {} : scan -> scan.addLanguageLoader(scan.getAnnotations().stream().filter(ad -> ((Type)typeMapper.apply((ModFileScanData.AnnotationData)ad)).equals((Object)modAnnotation)).map(ad -> {
            String className = ((Type)classTypeMapper.apply((ModFileScanData.AnnotationData)ad)).getClassName();
            String value = String.valueOf(((Map)dataMapper.apply((ModFileScanData.AnnotationData)ad)).get("value"));
            TILRef.logInfo("Found @Mod class {} with id {}", className, value);
            return (IModLanguageProvider.IModLanguageLoader)Hacks.construct(loaderClass, this.core, className, value, scan);
        }).collect(Collectors.toMap(loadModIDMapper, Function.identity(), (a, b) -> a)));
    }

    String getFixedClassName(String className) {
        return className.contains("1_19") || className.contains("1_20") || className.contains("1_21") ? className.substring(0, className.length() - 2) : className;
    }

    String getFixedPkg(String pkg) {
        return pkg.contains("v19") || pkg.contains("v20") || pkg.contains("v21") ? pkg.substring(0, pkg.length() - 3) : pkg;
    }

    <T> Class<T> getLanguageLoaderClass() {
        this.initCoreAPI();
        Object modLoader = Hacks.invoke(this.core, "getModLoader", new Object[0]);
        String pkg = "mods.thecomputerizer.theimpossiblelibrary";
        pkg = (String)Hacks.invoke(modLoader, "getPackageName", pkg);
        Object version = Hacks.invoke(this.core, "getVersion", new Object[0]);
        pkg = (String)Hacks.invoke(version, "getPackageName", pkg);
        if (Objects.isNull(pkg)) {
            LOGGER.error("Failed to find language loader package");
            return null;
        }
        String className = this.getFixedClassName(("TILLanguageLoader" + version).replace('.', '_'));
        className = this.getFixedPkg(pkg) + ".core.loader." + className;
        try {
            return Hacks.findClass(className, this.getClass().getClassLoader(), true);
        }
        catch (Throwable t) {
            TILRef.logError("Failed to get language loader class {}", className, t);
            return null;
        }
    }

    void initCoreAPI() {
        if (Objects.nonNull(this.core)) {
            return;
        }
        ClassLoader pluginLoader = ForgeCoreLoader.isJava8() ? this.getClass().getClassLoader() : ForgeCoreLoader.layerClassLoader("PLUGIN");
        this.core = ForgeCoreLoader.initCoreAPI(pluginLoader);
        LOGGER.info("Retrieved CoreAPI instance as {}", this.core);
    }

    public String name() {
        return "multiversionprovider";
    }

    static {
        Class<TILLanguageLoader> c = TILLanguageLoader.class;
        LOGGER.debug("Initialized {} with impl version {}", c, (Object)c.getPackage().getImplementationVersion());
    }
}

