/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.forge.core.asm;

import java.util.Arrays;
import java.util.List;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.ASMHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.ASMRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.ModWriter;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.TypeHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.loader.MultiVersionModInfo;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextHelper;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class ModWriterForge
extends ModWriter {
    protected static final Type DIST = TypeHelper.forge("api/distmarker/Dist");
    protected static final Type EVENT_SUBSCRIBER = TypeHelper.fml("common/Mod$EventBusSubscriber");
    protected static final Type EVENT_SUBSCRIBER_BUS = TypeHelper.fml("common/Mod$EventBusSubscriber$Bus");
    protected static final Type JAVA_LOADING_CONTEXT = TypeHelper.fml("javafmlmod/FMLJavaModLoadingContext");
    protected static final Type MOD_ANNOTATION = TypeHelper.fml("common/Mod");
    protected static final Type SUBSCRIBE_EVENT = TypeHelper.forge("eventbus/api/SubscribeEvent");

    public ModWriterForge(CoreAPI core, MultiVersionModInfo info) {
        super(core, info);
    }

    @Override
    protected void addClassAnnotations(ClassVisitor visitor) {
        this.writeClassAnnotation(visitor, MOD_ANNOTATION, mod -> mod.visit("value", (Object)this.info.getModID()));
    }

    protected void addEntryHooks(MethodVisitor visitor, String method) {
        super.addEntryHooks(visitor, true, method, false);
    }

    protected void addEventSubscriber(ModWriter.InnerClassData data, ClassVisitor visitor) {
        this.addEventSubscriber(visitor, data.isModBus(), data.isClient(), data.isServer());
    }

    protected void addEventSubscriber(ClassVisitor visitor, boolean modBus, boolean client, boolean server) {
        this.writeClassAnnotation(visitor, EVENT_SUBSCRIBER, annotation -> {
            annotation.visit("modid", (Object)this.info.getModID());
            if (modBus) {
                annotation.visitEnum("bus", EVENT_SUBSCRIBER_BUS.getDescriptor(), "MOD");
            }
            if (client && !server || !client && server) {
                this.writeAnnotationArray((AnnotationVisitor)annotation, "value", array -> array.visitEnum(null, DIST.getDescriptor(), client ? "CLIENT" : "DEDICATED_SERVER"));
            }
        });
    }

    protected ModWriter.InnerClassData buildInnerClassData(ClassVisitor outerClass, String className, int flags, String ... entryPoints) {
        return this.buildInnerClassData(this.innerClassDataBuilder(outerClass, className, entryPoints).setFlags(flags));
    }

    protected ModWriter.InnerClassData buildInnerClassData(ModWriter.InnerClassDataBuilder builder) {
        return builder.constructorInit((writer, cv) -> ASMHelper.getConstructor(cv, 1, new Type[0])).constructorHandle((writer, constructor) -> {
            writer.basicContructorHandle((MethodVisitor)constructor);
            constructor.visitInsn(177);
            ASMHelper.finishMethod(constructor);
        }).entryPointHandle((visitor, entryPoint) -> {
            Type[] args = ((Type)this.entryPointMethodTypes.get(entryPoint)).getArgumentTypes();
            this.writeMethod((ClassVisitor)visitor, cv -> ASMHelper.getMethod(cv, 9, entryPoint, args), method -> {
                this.writeMethodAnnotation((MethodVisitor)method, SUBSCRIBE_EVENT, annotation -> {});
                this.addEntryHooks((MethodVisitor)method, (String)entryPoint);
            });
        }).build();
    }

    @Override
    protected List<String[]> entryPointMappings() {
        return Arrays.asList({"<init>", "", "onConstructed", "onPreRegistration"}, {"clientSetup", "FMLClientSetupEvent", "checkClientSetup"}, {"commonSetup", "FMLCommonSetupEvent", "onCommonSetup"}, {"dedicatedServerSetup", "FMLDedicatedServerSetupEvent", "checkDedicatedServerSetup"}, {"interModEnqueue", "InterModEnqueueEvent", "onInterModEnqueue"}, {"interModProcess", "InterModProcessEvent", "onInterModProcess"}, {"loadComplete", "FMLLoadCompleteEvent", "onLoadComplete"}, {"serverAboutToStart", "FMLServerAboutToStartEvent", "onServerAboutToStart"}, {"serverStarting", "FMLServerStartingEvent", "onServerStarting"}, {"serverStarted", "FMLServerStartedEvent", "onServerStarted"}, {"serverStopping", "FMLServerStoppingEvent", "onServerStopping"}, {"serverStopped", "FMLServerStoppedEvent", "onServerStopped"});
    }

    @Override
    protected Type getEventMethod(String className) {
        if (TextHelper.isBlank(className)) {
            return ASMRef.EMPTY_METHOD;
        }
        if (V18_OR_LATER && className.contains("FMLServer")) {
            className = className.replace("FML", "");
            return TypeHelper.method(Type.VOID_TYPE, TypeHelper.forge("event/server/" + className));
        }
        className = (className.startsWith("FMLServer") ? "server" : "lifecycle") + "/" + className;
        return TypeHelper.method(Type.VOID_TYPE, TypeHelper.fml("event/" + className));
    }

    protected ModWriter.InnerClassDataBuilder innerClassDataBuilder(ClassVisitor outer, String name, String ... entryPoints) {
        return this.innerClassDataBuilder(outer, name, this::addEventSubscriber, entryPoints);
    }

    @Override
    protected ModWriter.InnerClassData[] innerClasses(ClassVisitor outerClass) {
        return new ModWriter.InnerClassData[]{this.buildInnerClassData(outerClass, "LoaderClient", 6, "clientSetup"), this.buildInnerClassData(outerClass, "LoaderCommon", 7, "commonSetup", "interModEnqueue", "interModProcess", "loadComplete"), this.buildInnerClassData(outerClass, "LoaderServer", 5, "dedicatedServerSetup"), this.buildInnerClassData(outerClass, "ServerLifecycle", 3, "serverAboutToStart", "serverStarting", "serverStarted", "serverStopping", "serverStopped")};
    }
}

