/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.forge.core.bootstrap;

import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.serviceapi.ILaunchPluginService;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mods.thecomputerizer.theimpossiblelibrary.api.core.ClassHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.Hacks;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.core.bootstrap.TILLauncher;
import mods.thecomputerizer.theimpossiblelibrary.forge.core.bootstrap.TILBootJar;
import mods.thecomputerizer.theimpossiblelibrary.forge.core.modules.ForgeModuleAccess;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;

public class TILBootLauncherForge
extends TILLauncher
implements ILaunchPluginService {
    static final String BASE_PKG = "mods.thecomputerizer.theimpossiblelibrary";
    static final String CORE_PKG = "mods.thecomputerizer.theimpossiblelibrary.forge.core";
    static final String HACKS = "mods.thecomputerizer.theimpossiblelibrary.api.core.Hacks";
    static final String JAR = "cpw.mods.jarhandling.impl.Jar";
    static final String LANGUAGE_LOADER = "mods.thecomputerizer.theimpossiblelibrary.forge.core.TILLanguageProvider";
    static final String LAYER = "cpw.mods.modlauncher.api.IModuleLayerManager$Layer";
    static final String LOCATOR = "mods.thecomputerizer.theimpossiblelibrary.forge.core.MultiVersionModLocator";
    static final String SERVICE_LAUNCHER = "mods.thecomputerizer.theimpossiblelibrary.forge.core.bootstrap.TILServiceLauncherForge";
    static final String UFS = "cpw.mods.niofs.union.UnionFileSystem";
    static final String UNION_PATH = "cpw.mods.niofs.union.UnionPath";
    static final Collection<String> SERVICES = Arrays.asList("mods.thecomputerizer.theimpossiblelibrary.forge.core.bootstrap.TILServiceLauncherForge", "mods.thecomputerizer.theimpossiblelibrary.forge.core.MultiVersionModLocator", "mods.thecomputerizer.theimpossiblelibrary.forge.core.TILLanguageProvider");
    static final String[] DEV_MODULES = new String[]{"main", "tilforge"};
    static final Logger LOGGER;

    static ClassLoader bootLoader() {
        return Launcher.class.getClassLoader();
    }

    static String commonParent(String unionSeparator, Path ... paths) {
        assert (Objects.nonNull(paths) && paths.length > 0);
        Path parent = paths[0];
        if (paths.length > 1) {
            while (Objects.nonNull(parent)) {
                int found = 0;
                block1: for (int i = 1; i < paths.length; ++i) {
                    Path path = paths[i];
                    while (Objects.nonNull(path)) {
                        if (parent.equals(path)) {
                            ++found;
                            continue block1;
                        }
                        path = path.getParent();
                    }
                }
                if (found == paths.length - 1) break;
                parent = parent.getParent();
            }
        }
        if (Objects.isNull(parent)) {
            return null;
        }
        String pathStr = parent.toString().replace(File.separator, unionSeparator);
        return pathStr.startsWith(unionSeparator) ? pathStr : unionSeparator + pathStr;
    }

    static void consolidateDevModules(String ... names) {
        LOGGER.info("Consolidating dev modules {} into {}", (Object)names, (Object)"theimpossiblebootstrap");
        if (names.length < 1) {
            LOGGER.error("Tried to consolidate empty dev module array");
            return;
        }
        URI unified = TILBootLauncherForge.unify(names);
        if (Objects.nonNull(unified)) {
            TILBootLauncherForge.consolidateDevModules(unified, names);
        } else {
            LOGGER.error("Failed to unify dev module locations!");
        }
        LOGGER.info("Finished consolidating dev modules");
    }

    static void consolidateDevModules(URI unified, String ... names) {
        String combinedName = "theimpossiblebootstrap";
        String[] others = names.length > 1 ? Arrays.copyOfRange(names, 1, names.length) : new String[]{};
        LOGGER.info("Combining dev modules: layer = BOOT | combined name = {} | base = {} | others = {} | location = {}", (Object)combinedName, (Object)names[0], (Object)others, (Object)unified);
        Class<TILBootJar> bootJarClass = TILBootJar.class;
        ForgeModuleAccess.combineModules("BOOT", unified, combinedName, names[0], others);
        LOGGER.info("Combination successful! Validating service classes");
        Collection<String> validated = TILBootLauncherForge.validateServices(bootJarClass, combinedName, unified);
        LOGGER.info("Successfully validated {} service classes: {}", (Object)validated.size(), validated);
    }

    static Method findSetFieldDirect(Class<?> hacksClass, Class<?> ... args) {
        String methodName = "setFieldDirect";
        try {
            return hacksClass.getDeclaredMethod("setFieldDirect", args);
        }
        catch (Throwable t) {
            LOGGER.error("Failed to find method {}#{} with args {}", (Object)hacksClass.getName(), (Object)"setFieldDirect", args, (Object)t);
            return null;
        }
    }

    static void fixReferenceJar(Class<?> bootJarClass, Object module, URI unified) {
        LOGGER.info("Fixing jar stuff");
        try {
            ClassLoader loader = (ClassLoader)Hacks.invoke(module, "getClassLoader", new Object[0]);
            Object configuration = Hacks.getFieldDirect(loader, "configuration");
            if (Objects.isNull(configuration)) {
                LOGGER.error("Failed to find configuration for module ClassLoader?");
                return;
            }
            String moduleName = (String)Hacks.invoke(module, "getName", new Object[0]);
            Optional resolved = (Optional)Hacks.invoke(configuration, "findModule", moduleName);
            if (Objects.isNull(resolved) || !resolved.isPresent()) {
                LOGGER.error("Failed to find ResolvedModule for Module?");
                return;
            }
            Object reference = Hacks.invoke(resolved.get(), "reference", new Object[0]);
            Hacks.invokeStatic(bootJarClass, "updateReference", LOGGER, reference, unified);
        }
        catch (Throwable t) {
            LOGGER.error("Failed to update ModuleReference?", t);
        }
    }

    static void invokeMethod(Method method, Object ... args) {
        if (Objects.isNull(method)) {
            LOGGER.error("Cannot invoke null method with args {}", args);
            return;
        }
        try {
            method.invoke(null, args);
        }
        catch (Throwable t) {
            LOGGER.error("Failed to invoke method with args {}", (Object)args, (Object)t);
        }
    }

    static boolean isDevModule(Object module) {
        if (Objects.isNull(module)) {
            return false;
        }
        String moduleName = (String)Hacks.invoke(module, "getName", new Object[0]);
        for (String devModuleName : DEV_MODULES) {
            if (!Objects.nonNull(moduleName) || !moduleName.equals(devModuleName)) continue;
            return true;
        }
        return false;
    }

    static Path modulePath(URI location) {
        Path primary;
        if (Objects.isNull(location)) {
            return null;
        }
        Path path = Paths.get(location);
        Class unionPathClass = Hacks.findClass(UNION_PATH);
        if (Objects.nonNull(unionPathClass) && unionPathClass.isInstance(path) && Objects.nonNull(primary = (Path)Hacks.invoke(Hacks.invoke(path, "getFileSystem", new Object[0]), "getPrimaryPath", new Object[0]))) {
            path = primary;
        }
        return path.toAbsolutePath();
    }

    static Class<?> setClassModule(Class<?> hacksClass, Class<?> c, Object m) {
        String moduleName = (String)Hacks.invoke(m, "getName", new Object[0]);
        if (Objects.isNull(hacksClass)) {
            LOGGER.error("Cannot set module for {} to {} with null hacks class!", c, (Object)moduleName);
            return c;
        }
        if (Objects.isNull(c)) {
            LOGGER.error("Cannot set module of null class to {}!", (Object)moduleName);
            return null;
        }
        if (Hacks.invoke(c, "getModule", new Object[0]) != m) {
            Method setField = TILBootLauncherForge.findSetFieldDirect(hacksClass, Object.class, String.class, Object.class);
            TILBootLauncherForge.invokeMethod(setField, c, "module", m);
        } else {
            LOGGER.info("Class {} already present in module {}", (Object)c.getName(), (Object)moduleName);
        }
        TILBootLauncherForge.setPackageModule(c.getPackage(), m, moduleName);
        return c;
    }

    static void setPackageModule(Package p, Object m, String moduleName) {
        if (Hacks.invokeDirect(p, "module", new Object[0]) != m) {
            Hacks.setFieldDirect(p, "module", m);
            ClassHelper.setPackageSelfVersion(p);
        } else {
            LOGGER.info("Package {} already present in module {}", (Object)p.getName(), (Object)moduleName);
        }
    }

    static String ufsSeparator() {
        return (String)Hacks.getFieldStaticDirect(UFS, "SEP_STRING");
    }

    static Object ufsp() {
        return Hacks.getFieldStaticDirect(JAR, "UFSP");
    }

    static URI unify(String ... moduleNames) {
        return TILBootLauncherForge.unify((Path[])Stream.of(moduleNames).map(moduleName -> ForgeModuleAccess.findResolvedModuleIn(moduleName, "BOOT")).filter(Objects::nonNull).map(module -> module.reference().location()).map(TILBootLauncherForge::modulePath).filter(Objects::nonNull).toArray(Path[]::new));
    }

    static URI unify(Path ... paths) {
        String root;
        if (Objects.isNull(paths) || paths.length == 0) {
            return null;
        }
        String unionSeparator = TILBootLauncherForge.ufsSeparator();
        if (Objects.isNull(unionSeparator)) {
            unionSeparator = "/";
        }
        if (Objects.isNull(root = TILBootLauncherForge.commonParent(unionSeparator, paths))) {
            LOGGER.error("Failed to find root path for {}", (Object)paths);
            return null;
        }
        LOGGER.info("Unifying paths {} under key path {}", (Object)paths, (Object)root);
        Object provider = TILBootLauncherForge.ufsp();
        if (Objects.isNull(provider)) {
            LOGGER.error("Found null UnionFileSystemProvider?? Cannot unify paths {}", (Object)paths);
            return null;
        }
        try {
            String providerScheme = (String)Hacks.invoke(provider, "getScheme", new Object[0]);
            Hacks.invokeDirect(provider, "newFileSystemInternal", root, null, paths);
            StringJoiner joiner = new StringJoiner("!");
            joiner.add(root);
            for (Path path : paths) {
                String pathStr = path.toAbsolutePath().toString().replace(File.separator, unionSeparator);
                if (!pathStr.startsWith(unionSeparator)) {
                    pathStr = unionSeparator + pathStr;
                }
                if (pathStr.contains(root)) {
                    pathStr = pathStr.substring(root.length());
                }
                LOGGER.info("Joining path {}", (Object)pathStr);
                joiner.add(pathStr);
            }
            String joinedPaths = joiner.toString();
            LOGGER.info("Joined paths are {}", (Object)joinedPaths);
            LOGGER.info("Full union URI should be {}:{}", (Object)providerScheme, (Object)joinedPaths);
            return new URI(providerScheme, null, joinedPaths, null);
        }
        catch (Throwable t) {
            LOGGER.error("Failed to construct URI for unified paths {}", (Object)paths, (Object)t);
            return null;
        }
    }

    @Nullable
    static Class<?> validateHacks(Object module, String moduleName) {
        if (Objects.isNull(module)) {
            LOGGER.info("Module {} not found in BOOT layer", (Object)moduleName);
            return null;
        }
        try {
            Class<?> c = Class.forName(HACKS, true, TILBootLauncherForge.bootLoader());
            return TILBootLauncherForge.setClassModule(c, c, module);
        }
        catch (Throwable t) {
            LOGGER.error("Failed to find class {}", (Object)HACKS, (Object)t);
            return null;
        }
    }

    static Collection<String> validateServiceProviders(Object layer, Object module, Collection<String> validated) {
        Object catalog = Hacks.getFieldDirect(layer, "servicesCatalog");
        if (Objects.isNull(catalog)) {
            LOGGER.warn("Unable to retrieve ServicesCatalog for layer of module {}", module);
            return Collections.emptySet();
        }
        Map providerMap = (Map)Hacks.getFieldDirect(catalog, "map");
        if (Objects.isNull(providerMap) || providerMap.isEmpty()) {
            LOGGER.warn("No service providers found in layer of module {}", module);
            return Collections.emptySet();
        }
        return providerMap.values().stream().flatMap(Collection::stream).map(provider -> TILBootLauncherForge.validateServiceProvider(module, validated, provider)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Nullable
    static String validateServiceProvider(Object module, Collection<String> validated, Object provider) {
        if (Objects.isNull(module) || Objects.isNull(validated) || Objects.isNull(provider) || validated.isEmpty()) {
            return null;
        }
        Object providerModule = Hacks.getFieldDirect(provider, "module");
        if (Objects.isNull(providerModule) || module == providerModule || !TILBootLauncherForge.isDevModule(providerModule)) {
            return null;
        }
        Hacks.setFieldDirect(provider, "module", module);
        return (String)Hacks.getFieldDirect(provider, "providerName");
    }

    static Collection<String> validateServices(Class<?> bootJarClass, String moduleName, URI uri) {
        Optional manager = (Optional)Hacks.invoke(Launcher.INSTANCE, "findLayerManager", new Object[0]);
        if (Objects.isNull(manager) || !manager.isPresent()) {
            LOGGER.fatal("Failed to find IModuleLayerManager instance??");
            return Collections.emptySet();
        }
        Object[] getLayerArgs = new Object[]{Hacks.getFieldStatic(LAYER, "BOOT")};
        Optional layer = (Optional)Hacks.invoke(manager.get(), "getLayer", getLayerArgs);
        if (Objects.nonNull(layer) && layer.isPresent()) {
            return TILBootLauncherForge.validateServices(bootJarClass, layer.get(), moduleName, uri);
        }
        LOGGER.fatal("Failed to find BOOT layer?? (manager={})", (Object)manager);
        return Collections.emptySet();
    }

    static Collection<String> validateServices(Class<?> bootJarClass, Object layer, String moduleName, URI uri) {
        LOGGER.info("Validating service classes for module {}", (Object)moduleName);
        Optional optionalModule = (Optional)Hacks.invoke(layer, "findModule", moduleName);
        Object module = Objects.nonNull(optionalModule) ? optionalModule.orElse(null) : null;
        Class<?> hacksClass = TILBootLauncherForge.validateHacks(module, moduleName);
        if (Objects.isNull(hacksClass) || Objects.isNull(module)) {
            LOGGER.error("Cannot validate services with null hacks class!");
            return Collections.emptySet();
        }
        LOGGER.info("Successfully validated hacks class");
        TILBootLauncherForge.fixReferenceJar(bootJarClass, module, uri);
        HashSet<String> validated = new HashSet<String>();
        ClassLoader loader = (ClassLoader)Hacks.invoke(module, "getClassLoader", new Object[0]);
        LOGGER.info("Validating service classes for ClassLoader {}", (Object)loader);
        Class<?> thisClass = TILBootLauncherForge.setClassModule(hacksClass, TILBootLauncherForge.class, module);
        if (Objects.nonNull(thisClass)) {
            validated.add(thisClass.getName());
        }
        for (String service : SERVICES) {
            if (Objects.nonNull(service)) {
                LOGGER.info("Attempting to validate service class {}", (Object)service);
                Class<?> serviceClass = (Class<?>)Hacks.invoke(loader, "findClass", service);
                serviceClass = TILBootLauncherForge.setClassModule(hacksClass, serviceClass, module);
                if (Objects.nonNull(serviceClass)) {
                    validated.add(service);
                    continue;
                }
                LOGGER.error("Failed to find service class {}", (Object)service);
                continue;
            }
            LOGGER.info("Skipping validation for null service class");
        }
        Collection<String> providers = TILBootLauncherForge.validateServiceProviders(layer, module, validated);
        if (providers.isEmpty()) {
            LOGGER.info("All service providers are valid");
        } else {
            LOGGER.info("Updated module for {} service providers {}", (Object)providers.size(), providers);
        }
        return validated;
    }

    @IndirectCallers
    public TILBootLauncherForge() {
        super(true);
        if (DEV && MODULES) {
            TILBootLauncherForge.consolidateDevModules(DEV_MODULES);
        }
    }

    public EnumSet<ILaunchPluginService.Phase> handlesClass(Type classType, boolean isEmpty) {
        return TILBootLauncherForge.none(ILaunchPluginService.Phase.class);
    }

    static {
        System.out.println("[BOOT] Class init: " + TILBootLauncherForge.class.getName());
        LOGGER = TILRef.createLogger("The Impossible Loader (Boot)");
    }
}

