/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.forge.core.bootstrap;

import cpw.mods.modlauncher.Launcher;
import java.util.Objects;
import mods.thecomputerizer.theimpossiblelibrary.api.core.Hacks;
import mods.thecomputerizer.theimpossiblelibrary.api.core.bootstrap.TILForgeLikeServiceLauncher;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ModuleAccess;
import mods.thecomputerizer.theimpossiblelibrary.forge.core.ForgeCoreLoader;
import mods.thecomputerizer.theimpossiblelibrary.forge.core.bootstrap.TILServiceLauncherForge;
import mods.thecomputerizer.theimpossiblelibrary.forge.core.modules.ForgeModuleAccess;
import org.apache.logging.log4j.Logger;

public class TILLauncherForge
extends TILForgeLikeServiceLauncher {
    static ClassLoader setBootLoader() {
        return TILLauncherForge.java8() ? ClassLoader.getSystemClassLoader() : Launcher.class.getClassLoader();
    }

    public static void validateBootClass(Logger logger, String moduleName, String className) {
        logger.debug("Validating that {} can be found in BOOT layer module {}", (Object)className, (Object)moduleName);
        ModuleAccess module = ForgeModuleAccess.findModuleInLayer(moduleName, "BOOT");
        if (Objects.isNull(module)) {
            logger.error("Cannot validate BOOT loaded class with missing module {} (class = {})", (Object)moduleName, (Object)className);
            return;
        }
        TILLauncherForge.validateBootClass(logger, Launcher.class.getClassLoader(), module, className);
        logger.debug("Finished validation check for {}", (Object)className);
    }

    static void validateBootClass(Logger logger, ClassLoader bootLoader, ModuleAccess module, String className) {
        try {
            Class c = (Class)Hacks.callOnOtherClassLoader(bootLoader, "invokeDirect", bootLoader, "findClass", new Object[]{"theimpossiblebootstrap", className});
            String moduleName = module.getName();
            if (Objects.nonNull(c)) {
                Hacks.callOnOtherClassLoader(bootLoader, "setFieldDirect", c, "module", module.access());
                logger.info("Added service class {} to BOOT layer module {}", (Object)className, (Object)moduleName);
            } else {
                logger.error("Failed to find BOOT layer class {} for module {}!", (Object)className, (Object)moduleName);
            }
        }
        catch (Throwable t) {
            System.err.println("Error validating class for BOOT layer " + className);
            t.printStackTrace(System.err);
        }
    }

    public TILLauncherForge(Class<?> caller) {
        super(TILLauncherForge.setBootLoader(), "Forge");
        this.load(caller);
    }

    @Override
    protected String coreLoader() {
        return "mods.thecomputerizer.theimpossiblelibrary.forge.core.ForgeCoreLoader";
    }

    @Override
    protected Object initCoreAPI() {
        return ForgeCoreLoader.initCoreAPI();
    }

    @Override
    protected String modLoading() {
        return "mods.thecomputerizer.theimpossiblelibrary.forge.core.loader.ForgeModLoading";
    }

    @Override
    protected String moduleName(Class<?> c) {
        Object module = TILLauncherForge.callMethod(TILLauncherForge.getMethod(Class.class, "getModule", new Class[0]), TILServiceLauncherForge.class, new Object[0]);
        if (Objects.isNull(module)) {
            return null;
        }
        Object moduleName = TILLauncherForge.callMethod(TILLauncherForge.getMethod(module.getClass(), "getName", new Class[0]), module, new Object[0]);
        return moduleName instanceof String ? (String)moduleName : null;
    }

    @Override
    protected void moveModule(String moduleName) {
        this.logger.info("Moving module {} from SERVICE to BOOT layer", (Object)moduleName);
        ForgeModuleAccess.moveModule("SERVICE", "BOOT", moduleName, true);
        this.logger.info("Renaming BOOT module from {} to {}", (Object)moduleName, (Object)"theimpossiblebootstrap");
        ForgeModuleAccess.renameModule("BOOT", moduleName, "theimpossiblebootstrap");
    }
}

