/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.forge.core.loader;

import cpw.mods.modlauncher.api.LamdbaExceptionUtils;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.jar.Manifest;
import mods.thecomputerizer.theimpossiblelibrary.api.core.ClassHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.Hacks;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ResolvedModuleAccess;
import mods.thecomputerizer.theimpossiblelibrary.forge.core.loader.ForgeModLoading;
import mods.thecomputerizer.theimpossiblelibrary.forge.core.modules.ForgeModuleAccess;

public class TILLoaderJarModuleDataProvider {
    static final String MODULE_DATA_PROVIDER = "cpw.mods.jarhandling.SecureJar$ModuleDataProvider";
    final Function<FileSystem, Path> rootGetter = ForgeModLoading.isSecureLoadingFormat() ? fs -> fs.getRootDirectories().iterator().next() : fs -> (Path)Hacks.invoke(fs, "getRoot", new Object[0]);
    final Object providerProxy;
    final FileSystem ufs;
    final URI uri;
    final Manifest manifest;

    private static URI computeLoaderURI() {
        ResolvedModuleAccess module = ForgeModuleAccess.findResolvedModuleIn("theimpossiblebootstrap", "BOOT");
        if (Objects.isNull(module)) {
            TILRef.logError("Failed to find ResolvedModule {} in BOOT layer!", "theimpossiblebootstrap");
        }
        URI uri = Objects.nonNull(module) ? module.reference().location() : null;
        TILRef.logInfo("Called computeLoaderURI on TILLoaderJarModuleDataProvider and returning URI is {}", uri);
        return uri;
    }

    static Optional<URI> findFile(FileSystem fs, String name, Function<FileSystem, Path> rootGetter) {
        Path root = rootGetter.apply(fs);
        if (Objects.isNull(root)) {
            return Optional.empty();
        }
        return Optional.of(root.resolve(fs.getPath(name, new String[0]))).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).map(Path::toUri);
    }

    public static TILLoaderJarModuleDataProvider get(Object jar, Object metadata, Manifest manifest, boolean useProxy) {
        URI uri = TILLoaderJarModuleDataProvider.computeLoaderURI();
        return Objects.nonNull(uri) ? new TILLoaderJarModuleDataProvider(jar, metadata, manifest, uri, useProxy) : null;
    }

    TILLoaderJarModuleDataProvider(Object jar, Object metadata, Manifest manifest, URI uri, boolean useProxy) {
        this.uri = uri;
        this.ufs = Paths.get(uri).getFileSystem();
        this.manifest = manifest;
        this.providerProxy = useProxy ? this.createProxy(this.getClass().getClassLoader(), jar, metadata, uri) : null;
    }

    Object createProxy(ClassLoader loader, Object jar, Object metadata, URI uri) {
        return ClassHelper.newGenericProxy(loader, MODULE_DATA_PROVIDER, (methodName, args) -> {
            switch (methodName) {
                case "descriptor": {
                    return Hacks.invoke(metadata, "descriptor", new Object[0]);
                }
                case "findFile": {
                    return TILLoaderJarModuleDataProvider.findFile(this.ufs, (String)args[0], this.rootGetter);
                }
                case "getManifest": {
                    return this.manifest;
                }
                case "name": {
                    return Hacks.invoke(metadata, "name", new Object[0]);
                }
                case "open": {
                    return TILLoaderJarModuleDataProvider.findFile(this.ufs, (String)args[0], this.rootGetter).map(Paths::get).map(LamdbaExceptionUtils.rethrowFunction(x$0 -> Files.newInputStream(x$0, new OpenOption[0])));
                }
                case "uri": {
                    return uri;
                }
                case "verifyAndGetSigners": {
                    return Hacks.invoke(jar, "verifyAndGetSigners", args[0], args[1]);
                }
            }
            return null;
        });
    }

    Optional<URI> findFile(String name) {
        return TILLoaderJarModuleDataProvider.findFile(this.ufs, name, this.rootGetter);
    }
}

