/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.forge.core.modules;

import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ClassLoaderAccess;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ConfigurationAccess;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ModuleAccess;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ModuleDescriptorAccess;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ModuleHolder;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ModuleLayerAccess;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ModuleReferenceAccess;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ModuleSystemAccessor;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ResolvedModuleAccess;
import mods.thecomputerizer.theimpossiblelibrary.forge.core.ForgeCoreLoader;
import mods.thecomputerizer.theimpossiblelibrary.forge.core.modules.ForgeModuleAccess;
import mods.thecomputerizer.theimpossiblelibrary.forge.core.modules.ModuleLayerHandlerAccess;
import org.jetbrains.annotations.Nullable;

public class ModuleClassLoaderAccess
extends ClassLoaderAccess
implements ModuleHolder {
    static final String packageLookupField = ForgeModuleAccess.changing("packageToOurModules", "packageLookup");
    static final String parentLoadersField = ForgeModuleAccess.changing("packageToParentLoader", "parentLoaders");
    static final String resolvedRootsField = ForgeModuleAccess.changing("ourModules", "resolvedRoots");
    String layerName;

    ModuleClassLoaderAccess(ClassLoader loader, Object accessorOrLogger) {
        super(loader, accessorOrLogger);
    }

    @IndirectCallers
    public void addPackage(String pkg, ResolvedModuleAccess resolvedModule) {
        this.addPackage(pkg, resolvedModule.access());
    }

    void addPackage(String pkg, Object resolvedModule) {
        this.packageLookup().put(pkg, resolvedModule);
    }

    @IndirectCallers
    public void addPackages(ResolvedModuleAccess resolvedModule) {
        this.addPackages(resolvedModule.reference().descriptor(), resolvedModule);
    }

    public void addPackages(ModuleDescriptorAccess moduleDescriptor, ResolvedModuleAccess resolvedModule) {
        this.addPackages(moduleDescriptor.packages(), resolvedModule);
    }

    public void addPackages(Collection<String> pkgs, ResolvedModuleAccess resolvedModule) {
        this.addPackages(pkgs, resolvedModule.access());
    }

    void addPackages(Collection<String> pkgs, Object resolvedModule) {
        Map<String, Object> packageLookup = this.packageLookup();
        for (String pkg : pkgs) {
            packageLookup.put(pkg, resolvedModule);
        }
    }

    @IndirectCallers
    public void addPackagesFrom(Collection<String> pkgs, ModuleClassLoaderAccess source, String moduleName) {
        Object module = source.getConfigModuleDirect(moduleName);
        this.addPackages(pkgs, module);
    }

    @IndirectCallers
    public void addParentLoaders(ResolvedModuleAccess resolvedModule, ModuleClassLoaderAccess loader) {
        this.addParentLoaders(resolvedModule.reference().descriptor(), loader);
    }

    public void addParentLoaders(ModuleDescriptorAccess moduleDescriptor, ModuleClassLoaderAccess loader) {
        this.addParentLoaders(moduleDescriptor.packages(), loader);
    }

    public void addParentLoaders(Collection<String> pkgs, ModuleClassLoaderAccess loader) {
        this.addParentLoaders(pkgs, loader.access());
    }

    void addParentLoaders(Collection<String> pkgs, Object loader) {
        Map<String, Object> parentLoaders = this.parentLoaders();
        for (String pkg : pkgs) {
            parentLoaders.put(pkg, loader);
        }
    }

    @IndirectCallers
    public void addParentLoader(String pkg, ModuleClassLoaderAccess loader) {
        this.addParentLoader(pkg, loader.access());
    }

    void addParentLoader(String pkg, Object loader) {
        this.parentLoaders().put(pkg, loader);
    }

    @IndirectCallers
    public void addRoot(ResolvedModuleAccess resolvedModule) {
        this.addRoot(resolvedModule.reference());
    }

    public void addRoot(ModuleReferenceAccess moduleReference) {
        this.addRoot(moduleReference.name(), moduleReference.access());
    }

    @IndirectCallers
    public void addRoot(String name, ModuleReferenceAccess moduleReference) {
        this.addRoot(name, moduleReference.access());
    }

    public void addRoot(String name, Object moduleReference) {
        this.resolvedRoots().put(name, moduleReference);
    }

    public void addSecureModule(Object secureModule, String ... names) {
        if (ForgeCoreLoader.SECURE_CLASSLOADER_FORMAT) {
            for (String name : names) {
                this.ourModulesSecure().put(name, secureModule);
            }
        }
    }

    @Override
    public void cloneModule(String moduleName, String newModuleName) {
        this.clonePackages(moduleName, newModuleName);
        this.cloneModuleMap(this.resolvedRoots(), moduleName, newModuleName);
        if (ForgeCoreLoader.SECURE_CLASSLOADER_FORMAT) {
            this.cloneModuleMap(this.ourModulesSecure(), moduleName, newModuleName);
        }
    }

    void cloneModuleMap(Map<String, Object> map, String moduleName, String newModuleName) {
        if (map.containsKey(moduleName)) {
            Object o = map.get(moduleName);
            map.remove(moduleName);
            if (!map.containsKey(newModuleName)) {
                this.getModuleReference(o).setName(newModuleName);
                map.put(newModuleName, o);
            }
        }
    }

    void clonePackages(String moduleName, String newModuleName) {
        ResolvedModuleAccess existingModule = this.lookupResolvedModule(newModuleName);
        boolean existed = Objects.nonNull(existingModule);
        HashSet<String> packages = existed ? new HashSet<String>() : null;
        Map<String, Object> packageLookup = this.packageLookup();
        for (Map.Entry<String, Object> packageEntry : packageLookup.entrySet()) {
            ResolvedModuleAccess moduleAccess = this.getAsResolvedModule(packageEntry.getValue());
            if (!moduleName.equals(moduleAccess.name())) continue;
            if (existed) {
                packages.add(packageEntry.getKey());
                continue;
            }
            moduleAccess.setName(newModuleName);
        }
        if (existed) {
            for (String pkg : packages) {
                packageLookup.put(pkg, existingModule.access());
            }
        }
    }

    public void combineModules(URI combinedLocation, String combinedName, String ... others) {
        ConfigurationAccess configuration = this.configuration();
        ResolvedModuleAccess module = configuration.getModule(combinedName);
        if (Objects.isNull(module)) {
            this.logger.error("Cannot combined modules {} into module {} that does not exist!", (Object)others, (Object)combinedLocation);
            return;
        }
        ModuleLayerAccess layer = this.getModuleLayer();
        ModuleReferenceAccess reference = this.getRoot(combinedName);
        if (Objects.nonNull(reference)) {
            reference.setLocation(combinedLocation);
        }
        module.inheritFrom(configuration, others);
        Map<String, Object> parentLoaders = this.parentLoaders();
        Map<String, Object> packageLookup = this.packageLookup();
        for (String pkg : module.packages()) {
            packageLookup.put(pkg, module.accessAs());
            parentLoaders.remove(pkg);
        }
        this.removeRoots(others);
        configuration.removeModules(others);
        layer.combineModules(combinedName, others);
    }

    public ConfigurationAccess configuration() {
        Object configuration = this.getDirect("configuration");
        if (Objects.nonNull(configuration)) {
            return this.getConfiguration(configuration);
        }
        this.logOrPrintError("Configuration field not found in ModuleClassLoader " + this.access());
        return null;
    }

    @Override
    public Collection<ModuleHolder> getAllReferents() {
        return Arrays.asList(this, this.configuration(), this.getModuleLayer());
    }

    ResolvedModuleAccess getAsResolvedModule(Object resolvedModule) {
        if (Objects.isNull(resolvedModule)) {
            return null;
        }
        if (resolvedModule instanceof ResolvedModuleAccess) {
            return (ResolvedModuleAccess)resolvedModule;
        }
        return ModuleSystemAccessor.getResolvedModule(resolvedModule, this);
    }

    public <T> T getConfigModuleDirect(String name) {
        return this.configuration().getModuleDirect(name);
    }

    @Nullable
    public ModuleDescriptorAccess getModuleDescriptor(String name) {
        ModuleAccess module = this.getModuleLayer().getModule(name);
        return Objects.nonNull(module) ? module.getDescriptor() : null;
    }

    @Nullable
    public Object getModuleDescriptorDirect(String name) {
        ModuleDescriptorAccess descriptorAccess = this.getModuleDescriptor(name);
        return Objects.nonNull(descriptorAccess) ? descriptorAccess.accessAs() : null;
    }

    public ModuleLayerAccess getModuleLayer() {
        if (Objects.isNull(this.layerName)) {
            this.logOrPrintError("Cannot get ModuleLayer! (ModuleClassLoaderAccess#layerName is null)");
            return null;
        }
        return ForgeModuleAccess.getModuleLayer(this.layerName, this);
    }

    public ResolvedModuleAccess getResolvedModule(String pkg) {
        return this.getAsResolvedModule(this.packageLookup().get(pkg));
    }

    @IndirectCallers
    public String getResolvedModuleName(Object resolvedModule) {
        return this.getAsResolvedModule(resolvedModule).name();
    }

    public ModuleReferenceAccess getRoot(String name) {
        Object moduleReference = this.resolvedRoots().get(name);
        return Objects.nonNull(moduleReference) ? this.getModuleReference(moduleReference) : null;
    }

    public Object getRootDirect(String name) {
        return this.resolvedRoots().get(name);
    }

    @IndirectCallers
    public ModuleLayerHandlerAccess handler() {
        return ForgeModuleAccess.getModuleLayerHandler(this);
    }

    public void lookupAndRemovePackagesFor(String moduleName) {
        this.removePackages(this.lookupResolvedModule(moduleName));
    }

    public ResolvedModuleAccess lookupResolvedModule(String moduleName) {
        for (Object resolvedModule : this.packageLookup().values()) {
            ResolvedModuleAccess moduleAccess = this.getAsResolvedModule(resolvedModule);
            if (!moduleName.equals(moduleAccess.name())) continue;
            return moduleAccess;
        }
        return null;
    }

    public void moveModuleTo(ModuleClassLoaderAccess targetLoader, String moduleName) {
        ResolvedModuleAccess resolvedModule = this.lookupResolvedModule(moduleName);
        Set<String> packages = resolvedModule.packages(false);
        Object resolveModuleAccess = resolvedModule.access();
        Object secureModule = ForgeCoreLoader.SECURE_CLASSLOADER_FORMAT ? this.secureModuleDirect(moduleName) : null;
        resolvedModule.configuration().moveModuleTo(targetLoader.configuration(), resolvedModule);
        this.moveRoots(targetLoader, moduleName);
        if (Objects.nonNull(secureModule)) {
            targetLoader.addSecureModule(secureModule, moduleName);
            this.removeSecureModule(moduleName);
        }
        this.movePackageLookup(targetLoader, packages, resolveModuleAccess);
    }

    private void movePackageLookup(ModuleClassLoaderAccess targetLoader, Set<String> packages, Object resolvedModuleAccess) {
        this.movePackageParent(targetLoader, packages);
        Map<String, Object> packageLookup = this.packageLookup();
        Map<String, Object> targetPackageLookup = targetLoader.packageLookup();
        for (String pkg : packages) {
            packageLookup.remove(pkg);
            targetPackageLookup.put(pkg, resolvedModuleAccess);
        }
    }

    private void movePackageParent(ModuleClassLoaderAccess targetLoader, Set<String> packages) {
        if (packages.isEmpty()) {
            return;
        }
        if (!"BOOT".equals(this.layerName)) {
            this.addParentLoaders(packages, targetLoader);
        }
        targetLoader.removeParentLoaders(packages);
    }

    private void moveRoots(ModuleClassLoaderAccess targetLoader, String moduleName) {
        Object ref = this.getRootDirect(moduleName);
        if (Objects.nonNull(ref)) {
            this.removeRoot(moduleName);
            targetLoader.addRoot(moduleName, ref);
        }
    }

    @IndirectCallers
    public void moveServicesTo(ModuleLayerAccess target, ModuleAccess module) {
        this.getModuleLayer().moveServicesTo(target, module, new String[0]);
    }

    @IndirectCallers
    public ResolvedModuleAccess newResolvedModule(ModuleReferenceAccess moduleReference) {
        return this.newResolvedModule(Objects.nonNull(moduleReference) ? moduleReference.access() : null);
    }

    public ResolvedModuleAccess newResolvedModule(Object moduleReference) {
        ConfigurationAccess configuration = this.configuration();
        return this.newResolvedModule(Objects.nonNull(configuration) ? configuration.access() : null, moduleReference);
    }

    @Override
    public ResolvedModuleAccess newResolvedModule(Object configuration, Object moduleReference) {
        if (Objects.isNull(configuration)) {
            this.logOrPrintError("Cannot create new ResolvedModule with null Configuration!");
            return null;
        }
        if (Objects.isNull(moduleReference)) {
            this.logOrPrintError("Cannot create new ResolvedModule with null ModuleReference!");
            return null;
        }
        return this.newResolvedModule(configuration, moduleReference);
    }

    public Map<String, Object> ourModulesSecure() {
        return ForgeCoreLoader.SECURE_CLASSLOADER_FORMAT ? (Map)this.getDirect("ourModulesSecure") : Collections.emptyMap();
    }

    @IndirectCallers
    public Map<String, Object> packageLookup() {
        return (Map)this.getDirect(packageLookupField);
    }

    public Map<String, Object> packageToCodeSource() {
        return ForgeCoreLoader.SECURE_CLASSLOADER_FORMAT ? (Map)this.getDirect("packageToCodeSource") : Collections.emptyMap();
    }

    @IndirectCallers
    public Map<String, Object> parentLoaders() {
        return (Map)this.getDirect(parentLoadersField);
    }

    @Override
    public void removeModule(String moduleName) {
        this.removeRoot(moduleName);
        this.removeSecureModule(moduleName);
        this.lookupAndRemovePackagesFor(moduleName);
    }

    public void removePackages(ResolvedModuleAccess resolvedModule) {
        if (Objects.nonNull(resolvedModule)) {
            this.removePackages(resolvedModule.packages());
        }
    }

    public void removePackages(Collection<String> pkgs) {
        if (Objects.isNull(pkgs) || pkgs.isEmpty()) {
            return;
        }
        List<Map> maps = ForgeCoreLoader.SECURE_CLASSLOADER_FORMAT ? Arrays.asList(this.packageLookup(), this.parentLoaders(), this.packageToCodeSource()) : Arrays.asList(this.packageLookup(), this.parentLoaders());
        for (Map map : maps) {
            for (String pkg : pkgs) {
                map.remove(pkg);
            }
        }
    }

    @IndirectCallers
    public void removePackage(String pkg) {
        this.removePackageLookup(pkg);
        this.removeParentLoader(pkg);
        this.removePackageToCodeSource(pkg);
    }

    public void removePackageLookup(String pkg) {
        this.packageLookup().remove(pkg);
    }

    public void removePackageToCodeSource(String pkg) {
        if (ForgeCoreLoader.SECURE_CLASSLOADER_FORMAT) {
            this.packageToCodeSource().remove(pkg);
        }
    }

    @IndirectCallers
    public void removePackagesForModule(ResolvedModuleAccess resolvedModule) {
        this.removePackagesForModule(resolvedModule.access());
    }

    public void removePackagesForModule(Object resolvedModule) {
        this.packageLookup().entrySet().removeIf(entry -> entry.getValue().equals(resolvedModule));
    }

    public void removeParentLoaders(Collection<String> pkgs) {
        Map<String, Object> parentLoaders = this.parentLoaders();
        for (String pkg : pkgs) {
            parentLoaders.remove(pkg);
        }
    }

    public void removeParentLoader(String pkg) {
        this.parentLoaders().remove(pkg);
    }

    public void removeRoot(String root) {
        this.resolvedRoots().remove(root);
    }

    public void removeRoots(String ... roots) {
        Map<String, Object> resolvedRoots = this.resolvedRoots();
        for (String root : roots) {
            resolvedRoots.remove(root);
        }
    }

    public void removeSecureModule(String moduleName) {
        if (ForgeCoreLoader.SECURE_CLASSLOADER_FORMAT) {
            this.ourModulesSecure().remove(moduleName);
        }
    }

    public void renameModule(String name, String newName) {
        this.logger.info("Renaming module from {} to {}", (Object)name, (Object)newName);
        ConfigurationAccess configuration = this.configuration();
        ResolvedModuleAccess module = configuration.getModule(name);
        if (Objects.isNull(module)) {
            this.logger.error("Cannot rename module {} that does not exist on layer {}!", (Object)name, (Object)this.layerName);
            return;
        }
        ModuleLayerAccess layer = this.getModuleLayer();
        module.setName(newName);
        Object root = this.getRootDirect(name);
        if (Objects.nonNull(root)) {
            this.removeRoot(name);
            this.addRoot(newName, root);
        }
        configuration.renameModule(name, newName);
        layer.renameModule(name, newName);
    }

    @IndirectCallers
    public Map<String, Object> resolvedRoots() {
        return (Map)this.getDirect(resolvedRootsField);
    }

    public <T> T secureModuleDirect(String name) {
        return (T)(ForgeCoreLoader.SECURE_CLASSLOADER_FORMAT ? this.ourModulesSecure().get(name) : null);
    }

    @Generated
    public void setLayerName(String layerName) {
        this.layerName = layerName;
    }
}

