/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.forge.core.modules;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import mods.thecomputerizer.theimpossiblelibrary.api.core.Hacks;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.AbstractModuleSystemAccessor;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ModuleLayerAccess;
import mods.thecomputerizer.theimpossiblelibrary.forge.core.ForgeCoreLoader;
import mods.thecomputerizer.theimpossiblelibrary.forge.core.modules.ForgeModuleAccess;
import mods.thecomputerizer.theimpossiblelibrary.forge.core.modules.LayerInfoAccess;
import mods.thecomputerizer.theimpossiblelibrary.forge.core.modules.ModuleClassLoaderAccess;
import org.apache.logging.log4j.Logger;

public class ModuleLayerHandlerAccess
extends AbstractModuleSystemAccessor {
    ModuleLayerHandlerAccess(Object access, Object accessorOrLogger) {
        super(access, accessorOrLogger);
    }

    ModuleLayerAccess asModuleLayer(Object moduleLayer) {
        return moduleLayer instanceof ModuleLayerAccess ? (ModuleLayerAccess)moduleLayer : this.getModuleLayer(moduleLayer);
    }

    public Map<Enum<?>, ?> completedLayers() {
        return (Map)this.getDirect("completedLayers");
    }

    public Map<String, Collection<String>> getAllModuleNames(String ... layerNames) {
        HashMap<String, Collection<String>> map = new HashMap<String, Collection<String>>();
        for (Map.Entry<ModuleLayerAccess, String> layerEntry : this.getAllNamedModuleLayers(layerNames).entrySet()) {
            map.put(layerEntry.getValue(), layerEntry.getKey().moduleNames());
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    public Map<ModuleLayerAccess, String> getAllNamedModuleLayers(String ... layerNames) {
        void var7_10;
        HashMap<ModuleLayerAccess, String> layerToName = new HashMap<ModuleLayerAccess, String>();
        HashMap<Object, ModuleLayerAccess> layerToWrapper = new HashMap<Object, ModuleLayerAccess>();
        HashSet<Object> layers = new HashSet<Object>();
        String[] stringArray = layerNames;
        int n = stringArray.length;
        boolean bl = false;
        while (var7_10 < n) {
            String layerName = stringArray[var7_10];
            ModuleLayerAccess layer = this.getModuleLayer(layerName);
            layers.add(layer.access());
            layerToName.put(layer, layerName);
            layerToWrapper.put(layer.access(), layer);
            List<Object> parents = layer.parents();
            layers.addAll(parents);
            ++var7_10;
        }
        int unknownParentCounter = 0;
        for (Object e : layers) {
            if (layerToWrapper.containsKey(e)) continue;
            ModuleLayerAccess layerAccess = this.asModuleLayer(e);
            layerToWrapper.put(e, layerAccess);
            layerToName.put(layerAccess, "UNKNOWN-PARENT-" + unknownParentCounter);
            ++unknownParentCounter;
        }
        return layerToName;
    }

    @IndirectCallers
    public ClassLoader getLayerClassLoader(String layerName) {
        return this.getLayerInfo(layerName).getClassLoader();
    }

    public LayerInfoAccess getLayerInfo(String layerName) {
        LayerInfoAccess layerInfo = this.getLayerInfo(ForgeModuleAccess.getLayerEnum(layerName));
        layerInfo.setLayerName(layerName);
        return layerInfo;
    }

    public LayerInfoAccess getLayerInfo(Enum<?> layerEnum) {
        Object layerInfo = this.completedLayers().get(layerEnum);
        return ForgeModuleAccess.getLayerInfo(layerInfo, (Object)this);
    }

    @IndirectCallers
    public ModuleClassLoaderAccess getLayerModuleClassLoader(String layerName) {
        return this.getLayerInfo(layerName).getModuleClassLoader();
    }

    public Map<String, Collection<String>> getLayerPathNames(String ... layerNames) {
        HashMap<String, Collection<String>> pathMap = new HashMap<String, Collection<String>>();
        Function<Object, String> printer = ForgeCoreLoader.SECURE_CLASSLOADER_FORMAT ? this::printSecureJar : this::printPathOrJar;
        for (String layerName : layerNames) {
            pathMap.put(layerName, this.getLayerPaths(layerName).stream().map(printer).collect(Collectors.toSet()));
        }
        if (pathMap.isEmpty()) {
            this.logOrPrint("Returning empty path map for layers " + Arrays.toString(layerNames), Logger::warn);
        }
        return pathMap;
    }

    public List<Object> getLayerPaths(String layerName) {
        Map<Object, List<Object>> map = this.layerPathMap();
        Enum<?> layerEnum = ForgeModuleAccess.getLayerEnum(layerName);
        if (Objects.isNull(layerEnum)) {
            this.logOrPrintError("Failed to get Layer " + layerName + "! Cannot return paths");
            return Collections.emptyList();
        }
        if (!map.containsKey(layerEnum)) {
            this.logOrPrint("Layer path map does not contain paths for " + layerName, Logger::warn);
            return Collections.emptyList();
        }
        return map.get(layerEnum);
    }

    public ModuleLayerAccess getModuleLayer(String layerName) {
        return this.getLayerInfo(layerName).getModuleLayer();
    }

    public Map<Object, List<Object>> layerPathMap() {
        return (Map)this.getDirect("layers");
    }

    @IndirectCallers
    public void printAllModuleNames(String ... layerNames) {
        this.defaultMapPrinter().accept(this.getAllModuleNames(layerNames));
    }

    @IndirectCallers
    void printForLayers(Function<String[], Map<?, ?>> mapGetter, String ... layerNames) {
        this.defaultMapPrinter().accept(mapGetter.apply(layerNames));
    }

    @IndirectCallers
    public void printLayerPaths(String ... layerNames) {
        this.defaultMapPrinter().accept(this.getLayerPathNames(layerNames));
    }

    String printPathOrJar(Object pathOrJar) {
        try {
            Object namedPath = Hacks.invoke(pathOrJar, "path", new Object[0]);
            String name = (String)Hacks.invoke(namedPath, "name", new Object[0]);
            Object[] paths = (Path[])Hacks.invoke(namedPath, "paths", new Object[0]);
            return "name = '" + name + "' | paths = '" + Arrays.toString(paths) + "'";
        }
        catch (Throwable t) {
            this.logOrPrintError("Failed to extract path string from " + pathOrJar, t);
            return "Unknown path object '" + pathOrJar + "'";
        }
    }

    String printSecureJar(Object secureJar) {
        return ForgeModuleAccess.getSecureJar(secureJar, this).print();
    }
}

