/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.forge.core.modules;

import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ResolvedModuleAccess;
import mods.thecomputerizer.theimpossiblelibrary.forge.core.modules.ForgeModuleAccess;
import mods.thecomputerizer.theimpossiblelibrary.forge.core.modules.ModuleClassLoaderAccess;

public class ResolvedModuleHolder {
    final ResolvedModuleAccess module;
    final ModuleClassLoaderAccess loader;

    public static ResolvedModuleHolder findModule(String moduleName, ModuleClassLoaderAccess ... loaders) {
        for (ModuleClassLoaderAccess loader : loaders) {
            ResolvedModuleHolder holder = ResolvedModuleHolder.findModule(moduleName, loader);
            if (!Objects.nonNull(holder)) continue;
            return holder;
        }
        return null;
    }

    public static ResolvedModuleHolder findModule(String moduleName, ModuleClassLoaderAccess loader) {
        ResolvedModuleAccess resolvedModule = loader.configuration().getModule(moduleName);
        return Objects.nonNull(resolvedModule) ? new ResolvedModuleHolder(resolvedModule, loader) : null;
    }

    public static ResolvedModuleHolder findPackage(String pkg, ModuleClassLoaderAccess ... loaders) {
        for (ModuleClassLoaderAccess loader : loaders) {
            ResolvedModuleHolder holder = ResolvedModuleHolder.findPackage(pkg, loader);
            if (!Objects.nonNull(holder)) continue;
            return holder;
        }
        return null;
    }

    @IndirectCallers
    public static ResolvedModuleHolder findPackage(String pkg, String ... layerNames) {
        for (String layerName : layerNames) {
            ResolvedModuleHolder holder = ResolvedModuleHolder.findPackage(pkg, ForgeModuleAccess.getModuleClassLoader(layerName));
            if (!Objects.nonNull(holder)) continue;
            return holder;
        }
        return null;
    }

    public static ResolvedModuleHolder findPackage(String pkg, ModuleClassLoaderAccess loader) {
        ResolvedModuleAccess resolvedModule = loader.getResolvedModule(pkg);
        return Objects.nonNull(resolvedModule) ? new ResolvedModuleHolder(resolvedModule, loader) : null;
    }

    ResolvedModuleHolder(ResolvedModuleAccess resolvedModule, ModuleClassLoaderAccess loader) {
        this.module = resolvedModule;
        this.loader = loader;
    }

    @IndirectCallers
    public String getLayerName() {
        return this.loader.layerName;
    }

    @IndirectCallers
    public Set<String> getPackages() {
        return this.module.packages();
    }

    @Generated
    public ResolvedModuleAccess getModule() {
        return this.module;
    }

    @Generated
    public ModuleClassLoaderAccess getLoader() {
        return this.loader;
    }
}

