/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.forge.v16.m5.core.loader;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.core.loader.MultiVersionModCandidate;
import mods.thecomputerizer.theimpossiblelibrary.api.core.loader.MultiVersionModInfo;
import mods.thecomputerizer.theimpossiblelibrary.forge.core.loader.MultiVersionLoaderForge;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.javafmlmod.FMLModContainer;
import org.jetbrains.annotations.Nullable;

public class MultiVersionLoaderForge1_16_5
extends MultiVersionLoaderForge {
    public MultiVersionLoaderForge1_16_5(CoreAPI parent) {
        super(parent);
    }

    @Override
    protected File findCoreModRoot() {
        return new File("mods");
    }

    @Override
    public File findModRoot() {
        return new File("mods");
    }

    @Override
    protected List<File> gatherCandidateModFiles(File root) {
        HashSet<File> set = new HashSet<File>();
        for (Path path : this.potentialModPaths) {
            File file = path.toFile();
            if (!file.isFile() || !file.getName().endsWith(".jar")) continue;
            set.add(file);
        }
        return Collections.unmodifiableList(new ArrayList(set));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    protected Attributes getFileAttributes(File file) {
        if (Objects.isNull(file)) return null;
        if (!file.exists()) {
            return null;
        }
        try (JarFile jar = new JarFile(file);){
            Manifest manifest = jar.getManifest();
            Attributes attributes = Objects.nonNull(manifest) ? manifest.getMainAttributes() : null;
            return attributes;
        }
        catch (IOException ex) {
            TILRef.logError("Error getting attributes for jar file {}", file, ex);
            return null;
        }
    }

    @IndirectCallers
    public FMLModContainer getModContainer(String modid) {
        ModList list = ModList.get();
        Optional container = list.getModContainerById(modid);
        return container.orElse(null);
    }

    @Override
    protected MultiVersionModInfo loadModInfo(ClassLoader classLoader, MultiVersionModCandidate candidate, MultiVersionModInfo info) {
        return info;
    }
}

