/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.forge.v16.m5.world;

import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Function;
import mods.thecomputerizer.theimpossiblelibrary.api.resource.ResourceLocationAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.world.DimensionAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.world.WorldAPI;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;

public class Dimension1_16_5
extends DimensionAPI<DimensionType> {
    private final ResourceLocationAPI<?> cachedRegistryName;
    private final String name;

    public Dimension1_16_5(WorldAPI<?> world, Object dimension) {
        super(dimension);
        this.cachedRegistryName = this.cacheRegistryName(world);
        this.name = this.calculateName();
    }

    private String calculateName() {
        if (Objects.isNull(this.cachedRegistryName)) {
            return null;
        }
        String[] words = this.cachedRegistryName.getPath().split("_");
        StringJoiner joiner = new StringJoiner(" ");
        for (String word : words) {
            joiner.add(TextHelper.capitalize(word));
        }
        return joiner.toString();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ResourceLocationAPI<?> getRegistryName() {
        return this.cachedRegistryName;
    }

    @Override
    protected Function<Object, Object> levelLocator() {
        return level -> {
            RegistryKey key = level instanceof World ? ((World)level).func_234923_W_() : null;
            return Objects.nonNull(key) ? key.func_240901_a_() : null;
        };
    }
}

