/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.forge.v19.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.VertexWrapper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;

public class VertexWrapper1_19
extends VertexWrapper {
    protected final VertexFormat format;
    protected final VertexFormat.Mode formatMode;
    protected final Tesselator tesselator;
    protected final BufferBuilder buffer;

    public VertexWrapper1_19(VertexFormat.Mode mode, VertexFormat format, int numVertices, int ... vertexSizes) {
        super(mode.f_166946_, numVertices, vertexSizes);
        this.format = format;
        this.formatMode = mode;
        this.tesselator = mode == VertexFormat.Mode.LINES || mode == VertexFormat.Mode.LINE_STRIP ? RenderSystem.m_69883_() : Tesselator.m_85913_();
        this.buffer = this.tesselator.m_85915_();
    }

    @Override
    protected void begin() {
        this.buffer.m_166779_(this.formatMode, this.format);
    }

    @Override
    protected void draw() {
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)this.buffer.m_231175_());
    }

    @Override
    protected void onVertexEnded(Number[][] numbers) {
        for (int i = 0; i < numbers.length; ++i) {
            this.pushBuffer((VertexFormatElement)this.format.m_86023_().get(i), numbers[i]);
        }
        this.buffer.m_5752_();
    }

    protected void pushBuffer(VertexFormatElement element, Number[] numbers) {
        int count = element.m_166969_();
        VertexFormatElement.Type type = element.m_86041_();
        VertexFormatElement.Usage usage = element.m_86048_();
        if (numbers.length != count && (numbers.length != 1 || usage != VertexFormatElement.Usage.COLOR)) {
            TILRef.logError("Incorrect buffer size {} for VertextFormatElement! (Count={}|Type={}|Usage={}!", numbers.length, count, type, usage);
            return;
        }
        switch (usage) {
            case COLOR: {
                if (numbers.length == 1) {
                    this.buffer.m_193479_(numbers[0].intValue());
                } else {
                    Number r = numbers[0];
                    Number g = numbers[1];
                    Number b = numbers[2];
                    Number a = numbers[3];
                    if (r instanceof Integer || r instanceof Long || r instanceof Short) {
                        this.buffer.m_6122_(r.intValue(), g.intValue(), b.intValue(), a.intValue());
                    } else {
                        this.buffer.m_85950_(r.floatValue(), g.floatValue(), b.floatValue(), a.floatValue());
                    }
                }
                return;
            }
            case NORMAL: {
                this.buffer.m_5601_(numbers[0].floatValue(), numbers[1].floatValue(), numbers[2].floatValue());
                return;
            }
            case POSITION: {
                this.buffer.m_5483_(numbers[0].doubleValue(), numbers[1].doubleValue(), numbers[2].doubleValue());
                return;
            }
            case UV: {
                Number u = numbers[0];
                Number v = numbers[1];
                if (type == VertexFormatElement.Type.FLOAT) {
                    this.buffer.m_7421_(u.floatValue(), v.floatValue());
                } else {
                    this.buffer.m_7120_(u.intValue(), v.intValue());
                }
                return;
            }
        }
        TILRef.logError("Unsupported VertextFormatElement (Count={}|Type={}|Usage={}!", count, type, usage);
    }
}

