/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.forge.v19.m4.registry.tab;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import mods.thecomputerizer.theimpossiblelibrary.api.common.item.ItemStackAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.registry.tab.FutureCreativeTab;
import mods.thecomputerizer.theimpossiblelibrary.api.resource.ResourceLocationAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.CreativeModeTabEvent;
import org.jetbrains.annotations.Nullable;

public class FutureCreativeTabForge1_19_4
extends FutureCreativeTab<CreativeModeTab> {
    private final List<ItemStack> suppliedItems = new ArrayList<ItemStack>();

    public FutureCreativeTabForge1_19_4(ResourceLocationAPI<?> registryName) {
        super(registryName);
    }

    @Override
    public void register(@Nullable Object arg) {
        if (Objects.isNull(arg) || Objects.isNull(this.registryName)) {
            TILRef.logError("Cannot register future creative tab with null arg or registryName!", new Object[0]);
            return;
        }
        CreativeModeTabEvent.Register event = (CreativeModeTabEvent.Register)arg;
        ResourceLocation name = (ResourceLocation)this.registryName.unwrap();
        this.wrapped = event.registerCreativeModeTab(name, builder -> {
            if (Objects.nonNull(this.iconSupplier)) {
                builder.m_257737_(() -> (ItemStack)this.iconSupplier.get());
            }
            builder.m_257941_((Component)TextHelper.getTranslated("itemGroup." + name.m_135815_(), new Object[0]).getAsComponent()).m_257501_((args, output) -> {
                for (ItemStack stack : this.suppliedItems) {
                    output.m_246342_(stack);
                }
            }).m_257652_();
        });
        this.registered = true;
    }

    @Override
    public void supply(@Nullable Object arg, List<Supplier<ItemStackAPI<?>>> stackSuppliers) {
        if (Objects.isNull(arg)) {
            TILRef.logError("Cannot supply future creative tab with null arg!", new Object[0]);
            return;
        }
        CreativeModeTabEvent.BuildContents event = (CreativeModeTabEvent.BuildContents)arg;
        if (event.getTab() != this.wrapped) {
            return;
        }
        this.suppliedItems.clear();
        for (Supplier<ItemStackAPI<?>> supplier : stackSuppliers) {
            ItemStack stack = (ItemStack)supplier.get().unwrap();
            if (!event.getEntries().contains((Object)stack)) {
                event.m_246342_(stack);
            }
            if (this.suppliedItems.contains(stack)) continue;
            this.suppliedItems.add(stack);
        }
        stackSuppliers.clear();
    }
}

