/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.forge.v20.core.bootstrap;

import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

public abstract class FixTILDevRunsForge1_20 {
    static final String CLASSPATH_FILE = System.getProperty("til.classpath.file", "");
    static final String SOURCE_NAME = "tilforge";
    static final String[] RELATIVE_SOURCE_PATHS = new String[]{"classes" + File.separatorChar + "java" + File.separatorChar + "main", "classes" + File.separatorChar + "java" + File.separatorChar + "tilforge", "resources" + File.separatorChar + "tilforge"};

    static void expandLoaderPaths(List<Path[]> classpath, Path[] foundLoaderPaths) {
        if (Objects.isNull(foundLoaderPaths)) {
            System.out.println("Adding loader paths that were not present in the classpath");
            FixTILDevRunsForge1_20.expandLoaderPaths(classpath, FixTILDevRunsForge1_20.extractBasePath());
            return;
        }
        if (foundLoaderPaths.length == 3) {
            return;
        }
        classpath.remove(foundLoaderPaths);
        FixTILDevRunsForge1_20.expandLoaderPaths(classpath, FixTILDevRunsForge1_20.extractBasePath(foundLoaderPaths[0].toAbsolutePath().toString()));
    }

    static void expandLoaderPaths(List<Path[]> classpath, String basePath) {
        Object[] newPaths = new Path[3];
        for (int i = 0; i < RELATIVE_SOURCE_PATHS.length; ++i) {
            newPaths[i] = Path.of(basePath + RELATIVE_SOURCE_PATHS[i], new String[0]);
        }
        classpath.add((Path[])newPaths);
        System.out.println("Expanded TIL loader paths to " + Arrays.toString(newPaths));
    }

    static String extractBasePath() {
        return FixTILDevRunsForge1_20.extractBasePath(CLASSPATH_FILE);
    }

    static String extractBasePath(String pathStr) {
        for (String relativePath : RELATIVE_SOURCE_PATHS) {
            if (!pathStr.endsWith(relativePath)) continue;
            return pathStr.substring(0, pathStr.length() - relativePath.length());
        }
        System.err.println("Failed to extract base path from " + pathStr);
        return pathStr;
    }

    static Collection<String> getLoaderPaths() {
        HashSet<String> pathSet = new HashSet<String>();
        for (String path : System.getProperty("til.classpath.file", "").split(";")) {
            pathSet.add(path);
            if (path.endsWith("main")) {
                pathSet.add(path.substring(0, path.length() - 4) + SOURCE_NAME);
                continue;
            }
            if (!path.endsWith(SOURCE_NAME)) continue;
            pathSet.add(path.substring(0, path.length() - SOURCE_NAME.length()) + "main");
        }
        return pathSet;
    }

    public final String name() {
        return "The Impossible Classpath Modifier";
    }

    public boolean process(List<Path[]> classpath) {
        HashSet<String> pathSet = new HashSet<String>(FixTILDevRunsForge1_20.getLoaderPaths());
        Path[] loaderPaths = null;
        for (Path[] pathArr : classpath) {
            boolean hasLoaderPath = false;
            for (Path path : pathArr) {
                String pathStr = (path.isAbsolute() ? path : path.toAbsolutePath()).toString();
                pathSet.add(pathStr);
                if (!pathStr.endsWith(SOURCE_NAME)) continue;
                System.out.println("Found path that ends with 'tilforge': " + pathStr);
                hasLoaderPath = true;
            }
            if (!hasLoaderPath) continue;
            loaderPaths = pathArr;
        }
        FixTILDevRunsForge1_20.expandLoaderPaths(classpath, loaderPaths);
        StringJoiner joiner = new StringJoiner(File.pathSeparator);
        for (String path : pathSet) {
            System.out.println("Adding path to legacyClassPath: " + path);
            joiner.add(path);
        }
        System.setProperty("legacyClassPath", joiner.toString());
        return false;
    }
}

