/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.forge.v20.m6.network;

import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.BiConsumer;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.network.message.MessageAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.network.message.MessageDirectionInfo;
import mods.thecomputerizer.theimpossiblelibrary.api.network.message.MessageWrapperAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.util.GenericUtils;
import mods.thecomputerizer.theimpossiblelibrary.shared.v20.m6.network.MessageWrapper1_20_6;
import mods.thecomputerizer.theimpossiblelibrary.shared.v20.m6.network.Network1_20_6;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.Channel;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkProtocol;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.payload.PayloadFlow;
import net.minecraftforge.network.payload.PayloadProtocol;
import org.jetbrains.annotations.Nullable;

public class NetworkForge1_20_6
extends Network1_20_6<Channel<CustomPacketPayload>, NetworkDirection<?>> {
    private final Collection<MessageDirectionInfo<NetworkDirection<?>>> registeredDirs = new HashSet();
    private Channel<CustomPacketPayload> network;

    static <B extends FriendlyByteBuf, P extends CustomPacketPayload> PayloadFlow<B, P> addPayloads(PayloadFlow<B, P> flow, NetworkProtocol<B> protocol, Class<?> ... msgClasses) {
        for (Class<?> msgCls : msgClasses) {
            flow = NetworkForge1_20_6.addPayload(flow, protocol, msgCls);
        }
        return flow;
    }

    static <B extends FriendlyByteBuf, P extends CustomPacketPayload> PayloadFlow<B, P> addPayload(PayloadFlow<B, P> flow, NetworkProtocol<B> protocol, Class<?> msgCls) {
        NetworkDirection dir = (NetworkDirection)GenericUtils.cast(NetworkForge1_20_6.selectDir(protocol, msgCls));
        return Objects.nonNull(dir) ? NetworkForge1_20_6.addPayload(flow, dir, msgCls) : flow;
    }

    static <B extends FriendlyByteBuf, P extends CustomPacketPayload, M extends MessageWrapper1_20_6<CustomPayloadEvent.Context>> PayloadFlow<B, P> addPayload(PayloadFlow<B, P> flow, NetworkDirection<B> dir, Class<?> msgCls) {
        CustomPacketPayload.Type type = MessageWrapper1_20_6.getClassType(msgCls);
        StreamCodec codec = MessageWrapper1_20_6.streamCodec(dir);
        BiConsumer<M, CustomPayloadEvent.Context> handler = NetworkForge1_20_6.buildPayloadHandler();
        return (PayloadFlow)GenericUtils.cast(((PayloadFlow)flow.flow(MessageWrapper1_20_6.getClassFlow(msgCls))).add(type, codec, handler));
    }

    static <M extends MessageWrapper1_20_6<CustomPayloadEvent.Context>> BiConsumer<M, CustomPayloadEvent.Context> buildPayloadHandler() {
        return (msg, ctx) -> {
            MessageWrapperAPI maybeReply = msg.handle(ctx);
            if (maybeReply instanceof MessageWrapper1_20_6) {
                MessageWrapper1_20_6 reply = (MessageWrapper1_20_6)maybeReply;
                if (ctx.isServerSide()) {
                    reply.setPlayer(ctx.getSender());
                }
                reply.send();
            }
            ctx.setPacketHandled(true);
        };
    }

    static Channel<CustomPacketPayload> registerPayloads(ChannelBuilder builder) {
        return NetworkForge1_20_6.registerPayloads(builder, NetworkProtocol.PLAY, null);
    }

    static <B extends FriendlyByteBuf, P extends CustomPacketPayload> Channel<P> registerPayloads(ChannelBuilder builder, NetworkProtocol<B> protocol, @Nullable PacketFlow channelFlow) {
        PayloadProtocol protocolBuilder = builder.payloadChannel().protocol(protocol);
        PayloadFlow flowBuilder = Objects.nonNull(channelFlow) ? (PayloadFlow)protocolBuilder.flow(channelFlow) : (PayloadFlow)protocolBuilder.bidirectional();
        return (Channel)GenericUtils.cast(NetworkForge1_20_6.addPayloads(flowBuilder, protocol, MessageWrapper1_20_6.Client.class, MessageWrapper1_20_6.Server.class).build());
    }

    static NetworkDirection<?> selectDir(NetworkProtocol<?> protocol, Class<?> msgClass) {
        if (protocol == NetworkProtocol.CONFIGURATION) {
            return MessageWrapper1_20_6.Client.class == msgClass ? NetworkDirection.CONFIGURATION_TO_CLIENT : NetworkDirection.CONFIGURATION_TO_SERVER;
        }
        if (protocol == NetworkProtocol.LOGIN) {
            return MessageWrapper1_20_6.Client.class == msgClass ? NetworkDirection.LOGIN_TO_CLIENT : NetworkDirection.LOGIN_TO_SERVER;
        }
        return MessageWrapper1_20_6.Client.class == msgClass ? NetworkDirection.PLAY_TO_CLIENT : NetworkDirection.PLAY_TO_SERVER;
    }

    Channel<CustomPacketPayload> buildChannel(ResourceLocation name) {
        return NetworkForge1_20_6.registerPayloads(ChannelBuilder.named((ResourceLocation)name).clientAcceptedVersions((status, version) -> true).serverAcceptedVersions((status, version) -> true).networkProtocolVersion(1));
    }

    @Override
    public NetworkDirection<?> getDirFromName(String name) {
        return switch (name.toUpperCase()) {
            case "LOGIN_TO_CLIENT" -> NetworkDirection.LOGIN_TO_CLIENT;
            case "PLAY_TO_SERVER" -> NetworkDirection.PLAY_TO_SERVER;
            case "LOGIN_TO_SERVER" -> NetworkDirection.LOGIN_TO_SERVER;
            default -> NetworkDirection.PLAY_TO_CLIENT;
        };
    }

    @Override
    public String getNameFromDir(NetworkDirection<?> dir) {
        if (dir == NetworkDirection.PLAY_TO_CLIENT) {
            return "PLAY_TO_CLIENT";
        }
        if (dir == NetworkDirection.PLAY_TO_SERVER) {
            return "PLAY_TO_SERVER";
        }
        if (dir == NetworkDirection.LOGIN_TO_CLIENT) {
            return "LOGIN_TO_CLIENT";
        }
        if (dir == NetworkDirection.LOGIN_TO_SERVER) {
            return "LOGIN_TO_SERVER";
        }
        if (dir == NetworkDirection.CONFIGURATION_TO_CLIENT) {
            return "CONFIGURATION_TO_CLIENT";
        }
        return "CONFIGURATION_TO_SERVER";
    }

    @Override
    public NetworkDirection<?> getDirToClient() {
        return NetworkDirection.PLAY_TO_CLIENT;
    }

    @Override
    public NetworkDirection<?> getDirToClientLogin() {
        return NetworkDirection.LOGIN_TO_CLIENT;
    }

    @Override
    public NetworkDirection<?> getDirToServer() {
        return NetworkDirection.PLAY_TO_SERVER;
    }

    @Override
    public NetworkDirection<?> getDirToServerLogin() {
        return NetworkDirection.LOGIN_TO_SERVER;
    }

    @Override
    @Nullable
    public NetworkDirection<?> getOppositeDir(NetworkDirection<?> dir) {
        if (dir == NetworkDirection.PLAY_TO_CLIENT) {
            return NetworkDirection.PLAY_TO_SERVER;
        }
        if (dir == NetworkDirection.PLAY_TO_SERVER) {
            return NetworkDirection.PLAY_TO_CLIENT;
        }
        if (dir == NetworkDirection.LOGIN_TO_CLIENT) {
            return NetworkDirection.LOGIN_TO_SERVER;
        }
        return NetworkDirection.LOGIN_TO_CLIENT;
    }

    @Override
    public Channel<CustomPacketPayload> getNetwork() {
        if (Objects.isNull(this.network)) {
            if (this.registeredDirs.isEmpty()) {
                return null;
            }
            this.network = this.buildChannel((ResourceLocation)TILRef.res("main_network").unwrap());
        }
        return this.network;
    }

    @Override
    public boolean isDirToClient(NetworkDirection<?> dir) {
        return dir == NetworkDirection.PLAY_TO_CLIENT || dir == NetworkDirection.LOGIN_TO_CLIENT;
    }

    @Override
    public boolean isDirLogin(NetworkDirection<?> dir) {
        return dir == NetworkDirection.LOGIN_TO_CLIENT || dir == NetworkDirection.LOGIN_TO_SERVER;
    }

    @Override
    public void messageRegistrationStarted() {
        this.registeredDirs.clear();
    }

    @Override
    public void registerMessage(MessageDirectionInfo<NetworkDirection<?>> dir, int id) {
        this.registeredDirs.add(dir);
    }

    @Override
    public <P, M extends MessageWrapperAPI<?, ?>> void sendToPlayer(M message, P player) {
        this.getNetwork().send((Object)((MessageWrapper1_20_6)message), PacketDistributor.PLAYER.with((Object)((ServerPlayer)player)));
    }

    @Override
    public <M extends MessageWrapperAPI<?, ?>> void sendToServer(M message) {
        this.getNetwork().send((Object)((MessageWrapper1_20_6)message), PacketDistributor.SERVER.noArg());
    }

    @Override
    public <CTX> MessageWrapperAPI<?, CTX> wrapMessage(NetworkDirection<?> dir, MessageAPI<CTX> message) {
        MessageWrapperAPI wrapper = MessageWrapperAPI.getInstance(dir);
        if (Objects.nonNull(wrapper)) {
            wrapper.setMessage(dir, message);
        } else {
            TILRef.logError("Null message wrapper for dir {}", dir);
        }
        return wrapper;
    }

    @Override
    @SafeVarargs
    public final <CTX> MessageWrapperAPI<?, CTX> wrapMessages(NetworkDirection<?> dir, MessageAPI<CTX> ... messages) {
        MessageWrapperAPI wrapper = MessageWrapperAPI.getInstance(dir);
        if (Objects.nonNull(wrapper)) {
            wrapper.setMessages(dir, messages);
        } else {
            TILRef.logError("Null message wrapper for dir {}", dir);
        }
        return wrapper;
    }

    @Override
    public <CTX> MessageWrapperAPI<?, CTX> wrapMessages(NetworkDirection<?> dir, Collection<MessageAPI<CTX>> messages) {
        MessageWrapperAPI wrapper = MessageWrapperAPI.getInstance(dir);
        if (Objects.nonNull(wrapper)) {
            wrapper.setMessages(dir, messages);
        } else {
            TILRef.logError("Null message wrapper for dir {}", dir);
        }
        return wrapper;
    }
}

