/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.forge.v21.client;

import com.google.common.base.Strings;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import mods.thecomputerizer.theimpossiblelibrary.api.client.input.KeyAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.ArrayHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.forge.client.ForgeHandlesClient;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.Nullable;

public class ForgeHandlesClient1_21
extends ForgeHandlesClient {
    private final Set<KeyMapping> keys = new HashSet<KeyMapping>();
    private boolean registeredKeys;

    @Override
    public void endRenderTypeBatch(Object source, @Nullable Object type) {
        if (Objects.nonNull(type)) {
            ((MultiBufferSource.BufferSource)source).endBatch((RenderType)type);
        } else {
            ((MultiBufferSource.BufferSource)source).endBatch();
        }
    }

    protected Event getDebugTextEvent(Minecraft mc, GuiGraphics graphics, List<String> lines, boolean left) {
        float partialTick = mc.getTimer().getGameTimeDeltaTicks();
        return new CustomizeGuiOverlayEvent.DebugText(mc.getWindow(), graphics, partialTick, lines, left ? CustomizeGuiOverlayEvent.DebugText.Side.Left : CustomizeGuiOverlayEvent.DebugText.Side.Right);
    }

    @Override
    public void registerKeyBinding(KeyAPI<?> key) {
        if (this.registeredKeys) {
            ArrayHelper.append(Minecraft.getInstance().options.keyMappings, (KeyMapping)key.unwrap(), false);
        } else {
            this.keys.add((KeyMapping)key.unwrap());
        }
    }

    @Override
    public void registerKeyBindingsEvent(Object eventObj) {
        RegisterKeyMappingsEvent event = (RegisterKeyMappingsEvent)eventObj;
        TILRef.logInfo("Registering {} keybinds for 1.21", this.keys.size());
        for (KeyMapping key : this.keys) {
            event.register(key);
        }
        this.keys.clear();
        this.registeredKeys = true;
    }

    @Override
    public void renderDebugText(Object graphicsObj, List<String> left, List<String> right) {
        Minecraft mc = Minecraft.getInstance();
        GuiGraphics graphics = (GuiGraphics)graphicsObj;
        MinecraftForge.EVENT_BUS.post(this.getDebugTextEvent(mc, graphics, left, true));
        MinecraftForge.EVENT_BUS.post(this.getDebugTextEvent(mc, graphics, right, false));
        this.renderDebugText(graphicsObj, left, true);
        this.renderDebugText(graphicsObj, right, false);
    }

    @Override
    public void renderDebugText(Object graphicsObj, List<String> text, boolean left) {
        if (text.isEmpty()) {
            return;
        }
        GuiGraphics graphics = (GuiGraphics)graphicsObj;
        Minecraft mc = Minecraft.getInstance();
        for (int i = 0; i < text.size(); ++i) {
            String string = text.get(i);
            if (Strings.isNullOrEmpty((String)string)) continue;
            int lineSpacing = 9;
            int textWidth = mc.font.width(string);
            int x = left ? 2 : mc.getWindow().getGuiScaledWidth() - textWidth - 2;
            int y = 2 + lineSpacing * i;
            graphics.fill(x - 1, y - 1, x + textWidth + 1, y + lineSpacing - 1, -1873784752);
            graphics.drawString(mc.font, string, x, y, 0xE0E0E0);
        }
    }
}

