/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.forge.v21.core;

import java.util.List;
import java.util.function.Function;
import mods.thecomputerizer.theimpossiblelibrary.api.client.SharedHandlesClient;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreEntryPoint;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.ASMHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.ASMRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.TypeHelper;
import mods.thecomputerizer.theimpossiblelibrary.forge.core.TILCoreEntryPointForge;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;

public class TILCoreEntryPointForge1_21
extends TILCoreEntryPointForge {
    static final String ARRAYLIST = "java/util/ArrayList";
    static final String[] DEBUG_LIST_FIELDS = new String[]{"theimpossiblelibrary$left", "theimpossiblelibrary$right"};
    static final String DEBUG_OVERLAY = "net/minecraft/client/gui/components/DebugScreenOverlay";
    protected static final String GUI = "net/minecraft/client/gui/Gui";
    static final String LIST = "java/util/List";
    protected static final String MINECRAFT = "net/minecraft/client/Minecraft";
    static final String REF = Type.getInternalName(TILRef.class);
    static final String SHARED_HANDLES_CLIENT = Type.getInternalName(SharedHandlesClient.class);
    protected final CoreAPI core;

    public TILCoreEntryPointForge1_21(CoreAPI core) {
        this.core = core;
        TILRef.logInfo("Initialized core version handler {}", this.getClass());
    }

    void addRenderFields(List<FieldNode> fields) {
        String signature = this.toSignature(LIST, String.class.getName());
        for (String name : new String[]{"theimpossiblelibrary$left", "theimpossiblelibrary$right"}) {
            fields.add(new FieldNode(20, name, this.toDesc(LIST), signature, null));
        }
    }

    InsnList buildRenderDebugInvoker() {
        Type listType = Type.getType(List.class);
        String listDesc = this.toDesc(LIST);
        this.beginList(new InsnList());
        this.renderDebugQuery().insIf(154, new Label());
        for (String name : DEBUG_LIST_FIELDS) {
            this.insThis().insField(180, this.guiClass(), name, listDesc).insInvokeInterface(LIST, "clear");
        }
        String renderDesc = TypeHelper.voidMethodDesc(ASMRef.OBJECT_TYPE, listType, listType);
        this.insInvokeStatic(REF, "getClientHandles", TypeHelper.methodDesc(SharedHandlesClient.class));
        this.insVar(25, 1);
        for (String name : DEBUG_LIST_FIELDS) {
            this.insThis().insField(180, this.guiClass(), name, listDesc);
        }
        this.insInvokeVirtual(SHARED_HANDLES_CLIENT, "renderDebugText", renderDesc);
        return this.insLabel().endList();
    }

    @Override
    public List<String> classTargets() {
        return List.of(this.guiClass());
    }

    @Override
    public ClassNode editClass(ClassNode classNode) {
        TILRef.logInfo("Editing class node for {}", classNode.name);
        if (this.isTarget(classNode)) {
            this.addRenderFields(classNode.fields);
            for (MethodNode method : classNode.methods) {
                InsnList code = method.instructions;
                String methodName = this.getMethodName(classNode, method);
                if ("<init>".equals(methodName)) {
                    Function<AbstractInsnNode, Boolean> compare = node -> node.getOpcode() == 183;
                    AbstractInsnNode node2 = ASMHelper.findNode(code, compare, 0);
                    code.insert(node2, this.initRenderFields());
                    continue;
                }
                if (!"render".equals(methodName)) continue;
                TILRef.logInfo("Building RENDER_DEBUG_INFO invoker for gui with ordinal {}", 3);
                AbstractInsnNode label = ASMHelper.findLabel(code, 3);
                code.insertBefore(label, this.buildRenderDebugInvoker());
            }
        }
        return classNode;
    }

    String guiClass() {
        return GUI;
    }

    InsnList initRenderFields() {
        this.beginList(new InsnList());
        for (String name : new String[]{"theimpossiblelibrary$left", "theimpossiblelibrary$right"}) {
            this.insThis().insType(187, ARRAYLIST).insBasic(89).insInvokeSpecial(ARRAYLIST, "<init>").insField(181, this.guiClass(), name, this.toDesc(LIST));
        }
        return this.endList();
    }

    protected CoreEntryPoint renderDebugQuery() {
        this.insVar(25, 0);
        String overlayMethodDesc = TypeHelper.methodDesc(Type.getType((String)this.toDesc(DEBUG_OVERLAY)));
        return this.insField(180, this.guiClass(), "minecraft", this.toDesc(MINECRAFT)).insField(180, MINECRAFT, "gui", this.toDesc(GUI.replace('.', '/'))).insInvokeVirtual(GUI.replace('.', '/'), "getDebugOverlay", overlayMethodDesc).insInvokeVirtual(DEBUG_OVERLAY, "showDebugScreen", TypeHelper.methodDesc(Type.BOOLEAN_TYPE));
    }
}

