/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.legacy.v12.m2.core.asm;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.ASMHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.ASMRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.ModWriter;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.TypeHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.loader.MultiVersionModInfo;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextHelper;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class ModWriter1_12_2
extends ModWriter {
    private static final Type EVENT_HANDLER = TypeHelper.fml("common/Mod$EventHandler");
    private static final Type MOD_ANNOTATION = TypeHelper.fml("common/Mod");

    public ModWriter1_12_2(CoreAPI core, MultiVersionModInfo info) {
        super(core, info);
    }

    @Override
    protected void addClassAnnotations(ClassVisitor visitor) {
        this.writeClassAnnotation(visitor, MOD_ANNOTATION, mod -> {
            mod.visit("modid", (Object)this.info.getModID());
            mod.visit("name", (Object)this.info.getName());
            mod.visit("version", (Object)this.info.getVersion());
        });
    }

    @Override
    protected List<String[]> entryPointMappings() {
        return Arrays.asList({"<init>", "", "onConstructed"}, {"preInit", "FMLPreInitializationEvent", "onPreRegistration"}, {"init", "FMLInitializationEvent", "onCommonSetup", "checkClientSetup", "checkDedicatedServerSetup"}, {"postInit", "FMLPostInitializationEvent", "onInterModEnqueue", "onInterModProcess"}, {"loadComplete", "FMLLoadCompleteEvent", "onLoadComplete"}, {"serverAboutToStart", "FMLServerAboutToStartEvent", "onServerAboutToStart"}, {"serverStarting", "FMLServerStartingEvent", "onServerStarting"}, {"serverStarted", "FMLServerStartedEvent", "onServerStarted"}, {"serverStopping", "FMLServerStoppingEvent", "onServerStopping"}, {"serverStopped", "FMLServerStoppedEvent", "onServerStopped"});
    }

    @Override
    protected Type getEventMethod(String className) {
        if (TextHelper.isBlank(className)) {
            return ASMRef.EMPTY_METHOD;
        }
        return TypeHelper.method(Type.VOID_TYPE, TypeHelper.fml("common/event/" + className));
    }

    @Override
    protected void writeMod(ClassWriter writer, List<Map.Entry<String, byte[]>> classBytes) {
        super.writeMod(writer, classBytes);
        for (Map.Entry entryPoint : this.entryPointMethods.entrySet()) {
            String methodName = (String)entryPoint.getKey();
            if ("<init>".equals(methodName)) continue;
            Type[] eventArgs = ((Type)this.entryPointMethodTypes.get(methodName)).getArgumentTypes();
            Consumer<MethodVisitor> methodWriter = method -> {
                this.writeMethodAnnotation((MethodVisitor)method, EVENT_HANDLER, annotation -> {});
                this.addEntryHooks((MethodVisitor)method, false, methodName, false);
            };
            this.writeMethod((ClassVisitor)writer, cv -> ASMHelper.getMethod(cv, 1, methodName, eventArgs), methodWriter);
        }
    }
}

