/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.legacy.v12.m2.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.server.CommandAPI;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.Nullable;

public class WrappedCommand1_12_2
extends CommandBase {
    private final CommandAPI wrapped;
    private final List<List<CommandAPI>> executionStacks;

    public WrappedCommand1_12_2(CommandAPI wrapped) {
        this.wrapped = wrapped;
        this.executionStacks = this.collectExecutionStacks();
    }

    List<List<CommandAPI>> collectExecutionStacks() {
        ArrayList<List<CommandAPI>> stacks = new ArrayList<List<CommandAPI>>();
        for (CommandAPI node : this.findExecutionNodes(this.wrapped)) {
            stacks.add(node.getStackReverse());
        }
        return stacks;
    }

    List<CommandAPI> computeCommandStack(String[] args) {
        for (List<CommandAPI> stack : this.executionStacks) {
            if (!this.isValidStack(stack, args)) continue;
            return stack;
        }
        return Collections.singletonList(this.wrapped);
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        List<CommandAPI> stack = this.computeCommandStack(args);
        this.executeAt(sender, stack.get(stack.size() - 1), this.rebuildInput(args), args.length > 0 ? args[args.length - 1] : "");
    }

    void executeAt(ICommandSender sender, CommandAPI executionNode, String input, String remaining) throws CommandException {
        executionNode.prepareExceptionInfo();
        String exKey = executionNode.getExceptionKey();
        exKey = Objects.nonNull(exKey) ? exKey : "";
        Object[] exArgs = executionNode.getExceptionArgs();
        try {
            executionNode.execute(sender, input, remaining);
        }
        catch (Exception ex) {
            TILRef.logError("Caught exception for command {}! Rethrowing as CommandException", this.func_71517_b(), ex);
            throw new CommandException(exKey, exArgs);
        }
    }

    List<CommandAPI> findExecutionNodes(CommandAPI command) {
        ArrayList<CommandAPI> nodes = new ArrayList<CommandAPI>();
        this.findExecutionNodes(command, nodes);
        return nodes;
    }

    void findExecutionNodes(CommandAPI command, List<CommandAPI> nodes) {
        if (command.isExecutionNode()) {
            nodes.add(command);
        }
        for (CommandAPI subCmd : command.getSubCommands()) {
            this.findExecutionNodes(subCmd, nodes);
        }
    }

    public String func_71517_b() {
        return this.wrapped.getName();
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos pos) {
        List<CommandAPI> stack = this.computeCommandStack(args);
        String remaining = args.length > 0 ? args[args.length - 1] : "";
        return stack.get(stack.size() - 1).getTabCompletions(sender, this.rebuildInput(args), remaining);
    }

    public String func_71518_a(ICommandSender sender) {
        return "";
    }

    boolean isValidStack(List<CommandAPI> stack, String[] args) {
        if (stack.size() != args.length + 1) {
            return false;
        }
        for (int i = 0; i < args.length; ++i) {
            if (stack.get(i + 1).isValidInput(args[i])) continue;
            return false;
        }
        return true;
    }

    private String rebuildInput(String ... args) {
        StringJoiner joiner = new StringJoiner(" ");
        joiner.add(this.wrapped.getRootName());
        for (int i = 0; i < args.length - 1; ++i) {
            joiner.add(args[i]);
        }
        return joiner.toString();
    }
}

