/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.neoforge.core;

import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import java.lang.module.ModuleDescriptor;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import mods.thecomputerizer.theimpossiblelibrary.api.core.ClassHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.Hacks;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ModuleLayerAccess;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ResolvedModuleAccess;
import mods.thecomputerizer.theimpossiblelibrary.neoforge.core.bootstrap.TILLauncherNeoForge;
import mods.thecomputerizer.theimpossiblelibrary.neoforge.core.modules.ModuleClassLoaderAccess;
import mods.thecomputerizer.theimpossiblelibrary.neoforge.core.modules.NeoforgeModuleAccess;
import net.neoforged.neoforgespi.language.IModFileInfo;
import net.neoforged.neoforgespi.language.IModInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class NeoForgeCoreLoader {
    private static final String COREAPI_CLASS = "mods.thecomputerizer.theimpossiblelibrary.api.core.CoreAPI";
    private static final String NEOFORGE_PKG = "mods.thecomputerizer.theimpossiblelibrary.neoforge";
    private static final Logger LOGGER = LogManager.getLogger((String)"TIL NeoforgeCoreLoader");

    public static void addLibraryToGameLayer(String pkg, String gameLayerName) {
        ModuleClassLoaderAccess bootLoader = NeoForgeCoreLoader.bootLoaderAccess();
        ModuleClassLoaderAccess gameLoader = NeoforgeModuleAccess.getModuleClassLoader(IModuleLayerManager.Layer.GAME);
        ResolvedModuleAccess module = bootLoader.getResolvedModule(pkg);
        Set<String> packages = module.packages(false);
        ModuleDescriptor descriptor = gameLoader.getModuleDescriptorDirect(gameLayerName);
        NeoforgeModuleAccess.moveModule(bootLoader, gameLoader, module, true);
        TILLauncherNeoForge.checkHacksInit(false, gameLoader.unwrap());
        NeoForgeCoreLoader.addPackagesToDescriptor(module, packages, descriptor);
    }

    static void addPackagesToDescriptor(Object source, Set<String> packages, @Nullable ModuleDescriptor descriptor) {
        if (Objects.isNull(descriptor)) {
            LOGGER.error("Cannot add packages from {} to null game layer module descriptor", source);
            return;
        }
        String target = descriptor.name();
        if (packages.isEmpty()) {
            LOGGER.warn("Tried adding 0 packages from {} to game layer module {}", source, (Object)target);
            return;
        }
        LOGGER.info("Adding {} packages from {} to game layer module {}", (Object)packages.size(), source, (Object)target);
        Hacks.setFieldDirect(descriptor, "packages", packages);
    }

    public static ClassLoader bootLoader() {
        return Launcher.class.getClassLoader();
    }

    static ModuleClassLoaderAccess bootLoaderAccess() {
        return NeoforgeModuleAccess.getModuleClassLoader(IModuleLayerManager.Layer.BOOT);
    }

    @Nullable
    public static CoreAPI getBootLoadedCoreAPI() {
        return NeoForgeCoreLoader.getCoreAPIReflectively(NeoForgeCoreLoader.bootLoaderAccess());
    }

    static CoreAPI getCoreAPIReflectively(ModuleClassLoaderAccess loader) {
        CoreAPI coreInstance;
        try {
            Class<?> c = ClassHelper.existsOn(COREAPI_CLASS, loader.unwrap());
            coreInstance = Objects.nonNull(c) ? (CoreAPI)Hacks.getFieldStatic(c, "INSTANCE") : null;
        }
        catch (Throwable ignored) {
            coreInstance = null;
        }
        if (Objects.isNull(coreInstance)) {
            LOGGER.debug("CoreAPI not found on {} layer", (Object)loader.layerName());
        }
        return coreInstance;
    }

    public static Object getLogger() {
        return LOGGER;
    }

    static <T> int getMatchingArrayIndex(T[] array, T value) {
        if (Objects.isNull(array) || array.length == 0) {
            return -1;
        }
        for (int i = 0; i < array.length; ++i) {
            if (!value.equals(array[i])) continue;
            return i;
        }
        return -1;
    }

    static String getVersionStr() {
        Object handler;
        Class accessClass = Hacks.findClass(NeoforgeModuleAccess.class.getName(), NeoForgeCoreLoader.bootLoader());
        Object launcher = Hacks.invokeStatic(accessClass, "getLauncher", new Object[0]);
        Object v0 = handler = Objects.nonNull(launcher) ? Hacks.invoke(launcher, "argumentHandler", new Object[0]) : null;
        if (Objects.isNull(handler)) {
            return null;
        }
        Object[] rawArgs = (String[])Hacks.invoke(handler, "getArgs", new Object[0]);
        if (Objects.isNull(rawArgs)) {
            LOGGER.error("Failed to find version using handler {}", handler);
            return null;
        }
        int versionIndex = NeoForgeCoreLoader.getMatchingArrayIndex(rawArgs, "--fml.mcVersion") + 1;
        if (versionIndex > 0) {
            LOGGER.debug("Found fml.mcVersion arg at index {} -> {}", (Object)versionIndex, rawArgs[versionIndex]);
            return rawArgs[versionIndex];
        }
        LOGGER.error("Failed to find fml.mcVersion or version flags from args {}", (Object)Arrays.toString(rawArgs));
        return null;
    }

    @Nullable
    public static CoreAPI initCoreAPI() {
        return NeoForgeCoreLoader.initCoreAPI(NeoForgeCoreLoader.bootLoader());
    }

    @Nullable
    public static CoreAPI initCoreAPI(ClassLoader loader) {
        LOGGER.debug("Starting CoreAPI init");
        CoreAPI bootInstance = NeoForgeCoreLoader.getBootLoadedCoreAPI();
        if (Objects.nonNull(bootInstance)) {
            LOGGER.debug("Returning existing CoreAPI instance found in the BOOT layer");
            return bootInstance;
        }
        String version = NeoForgeCoreLoader.getVersionStr();
        Class<?> coreClass = NeoForgeCoreLoader.loadAPI(version, NeoForgeCoreLoader.bootLoader());
        try {
            return (CoreAPI)Hacks.constructAndCast(coreClass, new Object[0]);
        }
        catch (Throwable t) {
            LOGGER.fatal("Unknown error while trying to get CoreAPI instance as {}", coreClass, (Object)t);
            LOGGER.fatal("Failed to initialize CoreAPI [Neoforge-{}] using {}", (Object)version, (Object)loader);
            return null;
        }
    }

    public static boolean isJava21() {
        return System.getProperty("java.version").startsWith("21");
    }

    public static ClassLoader layerClassLoader(IModuleLayerManager.Layer layer) {
        return NeoforgeModuleAccess.getModuleClassLoader(layer).unwrap();
    }

    static Class<?> loadAPI(String version, ClassLoader loader) {
        Class clazz = Hacks.findClass(NeoForgeCoreLoader.versionClassName("core.TILCoreNeoForge", version), loader, true);
        if (Objects.isNull(clazz)) {
            throw new RuntimeException("Failed to load CoreAPI instance [Neoforge-" + version + "]");
        }
        LOGGER.debug("Successfully loaded CoreAPI instance {}", clazz);
        return clazz;
    }

    public static void verifyModule(String className, IModInfo info, Object moduleLayer) {
        ModuleLayerAccess layerAccess;
        Optional<Object> optionalModule;
        LOGGER.info("Verifying that {} is valid for {} and can be found in {}", (Object)className, (Object)info, moduleLayer);
        String modid = info.getModId();
        IModFileInfo fileInfo = info.getOwningFile();
        String moduleName = fileInfo.moduleName();
        if (!modid.equals(moduleName)) {
            LOGGER.error("Mod id {} does not equal module name {}!", (Object)modid, (Object)moduleName);
        }
        if ((optionalModule = (layerAccess = NeoforgeModuleAccess.getModuleLayer(moduleLayer)).findModule(moduleName)).isEmpty()) {
            layerAccess.findAndAddModule(moduleLayer, moduleName, modid);
            optionalModule = layerAccess.findModule(moduleName);
        }
        if (optionalModule.isPresent()) {
            NeoforgeModuleAccess.getModule(optionalModule.get()).addClassIfMissing(className, layerAccess);
        } else {
            LOGGER.error("Module {} is not present in the target layer!", (Object)moduleName);
        }
        LOGGER.info("Finished verifying {}", (Object)className);
    }

    static String versionClassName(String name, String version) {
        return NeoForgeCoreLoader.versionPackage(version) + "." + NeoForgeCoreLoader.versionQuantify(name, version);
    }

    static String versionPackage(String version) {
        String[] split = version.split("\\.");
        if (split.length < 3) {
            throw new RuntimeException("Can't parse package for unknown version " + version);
        }
        return "mods.thecomputerizer.theimpossiblelibrary.neoforge.v" + split[1] + ".m" + split[2];
    }

    static String versionQuantify(String name, String version) {
        return name + version.replace('.', '_');
    }
}

