/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.neoforge.core.bootstrap;

import cpw.mods.jarhandling.SecureJar;
import cpw.mods.niofs.union.UnionFileSystem;
import cpw.mods.util.LambdaExceptionUtils;
import java.io.InputStream;
import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleReference;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSigner;
import java.util.Optional;
import java.util.jar.Manifest;
import mods.thecomputerizer.theimpossiblelibrary.api.core.Hacks;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class TILBootJar
implements SecureJar.ModuleDataProvider {
    final SecureJar.ModuleDataProvider provider;
    final URI uri;
    final UnionFileSystem ufs;

    @IndirectCallers
    static void updateReference(Logger logger, ModuleReference reference, URI uri) {
        Hacks.setFieldDirect(reference, "jar", new TILBootJar((SecureJar.ModuleDataProvider)Hacks.getFieldDirect(reference, "jar"), uri));
        logger.info("Updated ModuleDataProvider for JarModuleReference");
    }

    private TILBootJar(SecureJar.ModuleDataProvider provider, URI uri) {
        this.provider = provider;
        this.uri = uri;
        this.ufs = (UnionFileSystem)Paths.get(uri).getFileSystem();
    }

    public ModuleDescriptor descriptor() {
        return this.provider.descriptor();
    }

    public Manifest getManifest() {
        return this.provider.getManifest();
    }

    public Optional<URI> findFile(String name) {
        Path path = this.ufs.getPath(name, new String[0]);
        return Optional.of(this.ufs.getRoot().resolve(path)).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).map(Path::toUri);
    }

    public String name() {
        return this.provider.name();
    }

    public Optional<InputStream> open(String name) {
        return this.findFile(name).map(Paths::get).map(LambdaExceptionUtils.rethrowFunction(x$0 -> Files.newInputStream(x$0, new OpenOption[0])));
    }

    public String toString() {
        return this.provider.toString();
    }

    @Nullable
    public URI uri() {
        return this.uri;
    }

    @Nullable
    public CodeSigner[] verifyAndGetSigners(String cname, byte[] bytes) {
        return this.provider.verifyAndGetSigners(cname, bytes);
    }
}

