/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.neoforge.core.bootstrap;

import cpw.mods.cl.ModuleClassLoader;
import cpw.mods.jarhandling.impl.JarContentsImpl;
import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import cpw.mods.modlauncher.serviceapi.ILaunchPluginService;
import cpw.mods.niofs.union.UnionFileSystem;
import cpw.mods.niofs.union.UnionFileSystemProvider;
import cpw.mods.niofs.union.UnionPath;
import java.io.File;
import java.lang.module.Configuration;
import java.lang.module.ModuleReference;
import java.lang.module.ResolvedModule;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mods.thecomputerizer.theimpossiblelibrary.api.core.Hacks;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.core.bootstrap.TILLauncher;
import mods.thecomputerizer.theimpossiblelibrary.neoforge.core.bootstrap.TILBootJar;
import mods.thecomputerizer.theimpossiblelibrary.neoforge.core.modules.NeoforgeModuleAccess;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;

public class TILBootLauncherNeoForge
extends TILLauncher
implements ILaunchPluginService {
    static final boolean JAVA21 = System.getProperty("java.version").startsWith("21");
    static final String BASE_PKG = "mods.thecomputerizer.theimpossiblelibrary";
    static final String CORE_PKG = "mods.thecomputerizer.theimpossiblelibrary.neoforge." + (JAVA21 ? "v21." : "") + "core";
    static final String HACKS = "mods.thecomputerizer.theimpossiblelibrary.api.core.Hacks";
    static final String LANGUAGE_LOADER = CORE_PKG + "." + (JAVA21 ? "MultiVersionLanguageLoader" : "TILLanguageProvider");
    static final String LOCATOR = CORE_PKG + "." + (JAVA21 ? "TILSelfLocator" : "MultiVersionModLocator");
    static final String PACKAGE_VERSION_INFO = Package.class.getName() + "$VersionInfo";
    static final String READER = JAVA21 ? CORE_PKG + ".MultiVersionModReader" : null;
    static final String SERVICE_LAUNCHER = CORE_PKG + ".bootstrap.TILServiceLauncherNeoForge" + (JAVA21 ? "1_21" : "");
    static final Collection<String> SERVICES = Arrays.asList(SERVICE_LAUNCHER, LOCATOR, READER, LANGUAGE_LOADER);
    static final String[] DEV_MODULES = new String[]{"main", "tilneoforge"};
    static final Logger LOGGER;

    static ClassLoader bootLoader() {
        return Launcher.class.getClassLoader();
    }

    static String commonParent(String unionSeparator, Path ... paths) {
        assert (Objects.nonNull(paths) && paths.length > 0);
        Path parent = paths[0];
        if (paths.length > 1) {
            while (Objects.nonNull(parent)) {
                int found = 0;
                block1: for (int i = 1; i < paths.length; ++i) {
                    Path path = paths[i];
                    while (Objects.nonNull(path)) {
                        if (parent.equals(path)) {
                            ++found;
                            continue block1;
                        }
                        path = path.getParent();
                    }
                }
                if (found == paths.length - 1) break;
                parent = parent.getParent();
            }
        }
        if (Objects.isNull(parent)) {
            return null;
        }
        String pathStr = parent.toString().replace(File.separator, unionSeparator);
        return pathStr.startsWith(unionSeparator) ? pathStr : unionSeparator + pathStr;
    }

    static void consolidateDevModules(String ... names) {
        LOGGER.info("Consolidating dev modules {} into {}", (Object)names, (Object)"theimpossiblebootstrap");
        if (names.length < 1) {
            LOGGER.error("Tried to consolidate empty dev module array");
            return;
        }
        URI unified = TILBootLauncherNeoForge.unify(names);
        if (Objects.nonNull(unified)) {
            TILBootLauncherNeoForge.consolidateDevModules(unified, names);
        } else {
            LOGGER.error("Failed to unify dev module locations!");
        }
        LOGGER.info("Finished consolidating dev modules");
    }

    static void consolidateDevModules(URI unified, String ... names) {
        String combinedName = "theimpossiblebootstrap";
        String[] others = names.length > 1 ? Arrays.copyOfRange(names, 1, names.length) : new String[]{};
        LOGGER.info("Combining dev modules: layer = {} | combined name = {} | base = {} | others = {} | location = {}", (Object)IModuleLayerManager.Layer.BOOT, (Object)combinedName, (Object)names[0], (Object)others, (Object)unified);
        Class<TILBootJar> bootJarClass = TILBootJar.class;
        NeoforgeModuleAccess.combineModules(IModuleLayerManager.Layer.BOOT, unified, combinedName, names[0], others);
        LOGGER.info("Combination successful! Validating service classes");
        Collection<String> validated = TILBootLauncherNeoForge.validateServices(bootJarClass, combinedName, unified);
        LOGGER.info("Successfully validated {} service classes: {}", (Object)validated.size(), validated);
    }

    static Method findSetFieldDirect(Class<?> hacksClass, Class<?> ... args) {
        String methodName = "setFieldDirect";
        try {
            return hacksClass.getDeclaredMethod("setFieldDirect", args);
        }
        catch (Throwable t) {
            LOGGER.error("Failed to find method {}#{} with args {}", (Object)hacksClass.getName(), (Object)"setFieldDirect", args, (Object)t);
            return null;
        }
    }

    static void fixReferenceJar(Class<?> bootJarClass, Module module, URI unified) {
        LOGGER.info("Fixing jar stuff");
        try {
            Configuration configuration = (Configuration)Hacks.getFieldDirect(module.getClassLoader(), "configuration");
            if (Objects.isNull(configuration)) {
                LOGGER.error("Failed to find configuration for module ClassLoader?");
                return;
            }
            ResolvedModule resolved = configuration.findModule(module.getName()).orElse(null);
            if (Objects.isNull(resolved)) {
                LOGGER.error("Failed to find ResolvedModule for Module?");
                return;
            }
            Hacks.invokeStatic(bootJarClass, "updateReference", LOGGER, resolved.reference(), unified);
        }
        catch (Throwable t) {
            LOGGER.error("Failed to update ModuleReference?", t);
        }
    }

    static void invokeMethod(Method method, Object ... args) {
        if (Objects.isNull(method)) {
            LOGGER.error("Cannot invoke null method with args {}", args);
            return;
        }
        try {
            method.invoke(null, args);
        }
        catch (Throwable t) {
            LOGGER.error("Failed to invoke method with args {}", (Object)args, (Object)t);
        }
    }

    static boolean isDevModule(Module module) {
        if (Objects.isNull(module)) {
            return false;
        }
        String moduleName = module.getName();
        for (String devModuleName : DEV_MODULES) {
            if (!Objects.nonNull(moduleName) || !moduleName.equals(devModuleName)) continue;
            return true;
        }
        return false;
    }

    static <T> Set<Map.Entry<String, T>> mapEntries(Object target, String mapFieldName) {
        try {
            Map map = (Map)Hacks.getFieldDirect(target, mapFieldName);
            return Objects.nonNull(map) ? map.entrySet() : Collections.emptySet();
        }
        catch (Throwable t) {
            LOGGER.error("Failed to get map entries for field {} on target {}", (Object)mapFieldName, target, (Object)t);
            return Collections.emptySet();
        }
    }

    static Path modulePath(URI location) {
        Path path;
        if (Objects.isNull(location)) {
            return null;
        }
        Path path2 = Paths.get(location);
        if (path2 instanceof UnionPath) {
            UnionPath union = (UnionPath)path2;
            path = union.getFileSystem().getPrimaryPath();
        } else {
            path = path2;
        }
        return path.toAbsolutePath();
    }

    static void printDebugStuff(ModuleLayer layer, Module module) {
        String moduleName = module.getName();
        try {
            LOGGER.info("");
            ModuleClassLoader loader = (ModuleClassLoader)module.getClassLoader();
            Configuration configuration = (Configuration)Hacks.getFieldDirect(loader, "configuration");
            if (Objects.nonNull(configuration)) {
                if (configuration == layer.configuration()) {
                    LOGGER.info("Verified that the layer Configuration is the same as the ModuleClassLoader configuration");
                } else {
                    LOGGER.warn("Mismatched ModuleLayer/ModuleClassLoader Configuration instance??");
                }
                ResolvedModule configurationModule = configuration.findModule(moduleName).orElse(null);
                if (Objects.nonNull(configurationModule)) {
                    LOGGER.info("Verified that module {} is present in the configuration for ModuleClassLoader {}", (Object)moduleName, (Object)loader);
                    LOGGER.info("Configuration module location = {}", configurationModule.reference().location().orElse(null));
                } else {
                    LOGGER.warn("Failed to find module {} in the configuration for ModuleClassLoader {}", (Object)moduleName, (Object)loader);
                }
            } else {
                LOGGER.error("Failed to get configuration for ModuleClassLoader {}", (Object)loader);
            }
            LOGGER.info("");
            LOGGER.info("Printing packages for module {} found in layer {}", (Object)moduleName, (Object)layer);
            for (String pkg : module.getPackages()) {
                LOGGER.info("\t- {}", (Object)pkg);
            }
            LOGGER.info("");
            Set packageLookup = TILBootLauncherNeoForge.mapEntries(loader, "packageLookup");
            if (packageLookup.isEmpty()) {
                LOGGER.warn("No entries found in packageLookup map?");
            } else {
                LOGGER.info("Printing package lookup for ModuleClassLoader (filtered for {})", (Object)moduleName);
            }
            HashMap<String, ResolvedModule> uniqueModules = new HashMap<String, ResolvedModule>();
            for (Map.Entry packageEntry : packageLookup) {
                String string = packageEntry.getKey();
                if (!string.contains(moduleName)) continue;
                ResolvedModule packageModule = (ResolvedModule)packageEntry.getValue();
                String packageModuleName = packageModule.name();
                LOGGER.info("\t- [packageLookup] Package = {}", (Object)string);
                LOGGER.info("\t- [packageLookup] Module = {}", (Object)packageModuleName);
                uniqueModules.put(packageModuleName, packageModule);
            }
            LOGGER.info("");
            Set parentLoaders = TILBootLauncherNeoForge.mapEntries(loader, "parentLoaders");
            if (parentLoaders.isEmpty()) {
                LOGGER.warn("No entries found in parentLoaders map?");
            } else {
                LOGGER.info("Printing parent loaders for ModuleClassLoader {}", (Object)loader);
            }
            for (Map.Entry entry : parentLoaders) {
                LOGGER.info("\t- [parentLoaders] Package = {}", entry.getKey());
                LOGGER.info("\t- [parentLoaders] ClassLoader = {}", entry.getValue());
            }
            LOGGER.info("");
            Set resolvedRoots = TILBootLauncherNeoForge.mapEntries(loader, "resolvedRoots");
            if (resolvedRoots.isEmpty()) {
                LOGGER.warn("No entries found in resolvedRoots map?");
            } else {
                LOGGER.info("Printing roots for ModuleClassLoader {}", (Object)loader);
            }
            for (Map.Entry rootEntry : resolvedRoots) {
                String rootName = rootEntry.getKey();
                ModuleReference reference = (ModuleReference)rootEntry.getValue();
                LOGGER.info("\t- [resolvedRoots] Module = {}", (Object)rootName);
                LOGGER.info("\t- [resolvedRoots] Location = {}", reference.location().orElse(null));
                if (!moduleName.equals(rootName)) continue;
                LOGGER.info("\t- [resolvedRoots] Running additional checks for {}", (Object)moduleName);
                LOGGER.info("\t\t- [resolvedRoots] Equal descriptors = {}", (Object)(reference.descriptor() == module.getDescriptor() ? 1 : 0));
                if (uniqueModules.containsKey(rootName)) {
                    LOGGER.info("\t\t- [resolvedRoots] Equal references = {}", (Object)(reference == ((ResolvedModule)uniqueModules.get(rootName)).reference() ? 1 : 0));
                    continue;
                }
                LOGGER.warn("\t\t- [resolvedRoots] Module was not found in packageLookup");
            }
            LOGGER.info("");
        }
        catch (Throwable t) {
            LOGGER.error("Failed to print debug stuff for module {}", (Object)moduleName, (Object)t);
        }
    }

    static Class<?> setClassModule(Class<?> hacksClass, Class<?> c, Module m) {
        if (Objects.isNull(hacksClass)) {
            LOGGER.error("Cannot set module for {} to {} with null hacks class!", c, (Object)m.getName());
            return c;
        }
        if (Objects.isNull(c)) {
            LOGGER.error("Cannot set module of null class to {}!", (Object)m.getName());
            return null;
        }
        if (c.getModule() != m) {
            Method setField = TILBootLauncherNeoForge.findSetFieldDirect(hacksClass, Object.class, String.class, Object.class);
            TILBootLauncherNeoForge.invokeMethod(setField, c, "module", m);
        } else {
            LOGGER.info("Class {} already present in module {}", (Object)c.getName(), (Object)m.getName());
        }
        TILBootLauncherNeoForge.setPackageModule(c.getPackage(), m);
        return c;
    }

    static void setPackageModule(Package p, Module m) {
        if (Hacks.invokeDirect(p, "module", new Object[0]) != m) {
            Hacks.setFieldDirect(p, "module", m);
            Object versionInfo = Hacks.construct(PACKAGE_VERSION_INFO, null, null, null, null, "0.4.6", null, null);
            Hacks.setFieldDirect(p, "versionInfo", versionInfo);
        } else {
            LOGGER.info("Package {} already present in module {}", (Object)p.getName(), (Object)m.getName());
        }
    }

    static String ufsSeparator() {
        return (String)Hacks.getFieldStaticDirect(UnionFileSystem.class, "SEP_STRING");
    }

    static UnionFileSystemProvider ufsp() {
        return (UnionFileSystemProvider)Hacks.getFieldStaticDirect(JarContentsImpl.class, "UFSP");
    }

    static URI unify(String ... moduleNames) {
        return TILBootLauncherNeoForge.unify((Path[])Stream.of(moduleNames).map(moduleName -> NeoforgeModuleAccess.findResolvedModuleIn(moduleName, IModuleLayerManager.Layer.BOOT)).filter(Objects::nonNull).map(module -> module.reference().location()).map(TILBootLauncherNeoForge::modulePath).filter(Objects::nonNull).toArray(Path[]::new));
    }

    static URI unify(Path ... paths) {
        String root;
        if (Objects.isNull(paths) || paths.length == 0) {
            return null;
        }
        String unionSeparator = TILBootLauncherNeoForge.ufsSeparator();
        if (Objects.isNull(unionSeparator)) {
            unionSeparator = "/";
        }
        if (Objects.isNull(root = TILBootLauncherNeoForge.commonParent(unionSeparator, paths))) {
            LOGGER.error("Failed to find root path for {}", (Object)paths);
            return null;
        }
        LOGGER.info("Unifying paths {} under key path {}", (Object)paths, (Object)root);
        UnionFileSystemProvider provider = TILBootLauncherNeoForge.ufsp();
        if (Objects.isNull(provider)) {
            LOGGER.error("Found null UnionFileSystemProvider?? Cannot unify paths {}", (Object)paths);
            return null;
        }
        try {
            Hacks.invokeDirect(provider, "newFileSystemInternal", root, null, paths);
            StringJoiner joiner = new StringJoiner("!");
            joiner.add(root);
            for (Path path : paths) {
                Object pathStr = path.toAbsolutePath().toString().replace(File.separator, unionSeparator);
                if (!((String)pathStr).startsWith(unionSeparator)) {
                    pathStr = unionSeparator + (String)pathStr;
                }
                if (((String)pathStr).contains(root)) {
                    pathStr = ((String)pathStr).substring(root.length());
                }
                LOGGER.info("Joining path {}", pathStr);
                joiner.add((CharSequence)pathStr);
            }
            String joinedPaths = joiner.toString();
            LOGGER.info("Joined paths are {}", (Object)joinedPaths);
            LOGGER.info("Full union URI should be {}:{}", (Object)provider.getScheme(), (Object)joinedPaths);
            return new URI(provider.getScheme(), null, joinedPaths, null);
        }
        catch (Throwable t) {
            LOGGER.error("Failed to construct URI for unified paths {}", (Object)paths, (Object)t);
            return null;
        }
    }

    @Nullable
    static Class<?> validateHacks(Module module, String moduleName) {
        if (Objects.isNull(module)) {
            LOGGER.info("Module {} not found in BOOT layer", (Object)moduleName);
            return null;
        }
        try {
            Class<?> c = Class.forName(HACKS, true, TILBootLauncherNeoForge.bootLoader());
            return TILBootLauncherNeoForge.setClassModule(c, c, module);
        }
        catch (Throwable t) {
            LOGGER.error("Failed to find class {}", (Object)HACKS, (Object)t);
            return null;
        }
    }

    static Collection<String> validateServiceProviders(ModuleLayer layer, Module module, Collection<String> validated) {
        Object catalog = Hacks.getFieldDirect(layer, "servicesCatalog");
        if (Objects.isNull(catalog)) {
            LOGGER.warn("Unable to retrieve ServicesCatalog for layer of module {}", (Object)module);
            return Collections.emptySet();
        }
        Map providerMap = (Map)Hacks.getFieldDirect(catalog, "map");
        if (Objects.isNull(providerMap) || providerMap.isEmpty()) {
            LOGGER.warn("No service providers found in layer of module {}", (Object)module);
            return Collections.emptySet();
        }
        return providerMap.values().stream().flatMap(Collection::stream).map(provider -> TILBootLauncherNeoForge.validateServiceProvider(module, validated, provider)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Nullable
    static String validateServiceProvider(Module module, Collection<String> validated, Object provider) {
        if (Objects.isNull(module) || Objects.isNull(validated) || Objects.isNull(provider) || validated.isEmpty()) {
            return null;
        }
        Module providerModule = (Module)Hacks.getFieldDirect(provider, "module");
        if (Objects.isNull(providerModule) || module == providerModule || !TILBootLauncherNeoForge.isDevModule(providerModule)) {
            return null;
        }
        Hacks.setFieldDirect(provider, "module", module);
        return (String)Hacks.getFieldDirect(provider, "providerName");
    }

    static Collection<String> validateServices(Class<?> bootJarClass, String moduleName, URI uri) {
        IModuleLayerManager manager = Launcher.INSTANCE.findLayerManager().orElse(null);
        if (Objects.isNull(manager)) {
            LOGGER.fatal("Failed to find IModuleLayerManager instance??");
            return Collections.emptySet();
        }
        ModuleLayer layer = manager.getLayer(IModuleLayerManager.Layer.BOOT).orElse(null);
        if (Objects.nonNull(layer)) {
            return TILBootLauncherNeoForge.validateServices(bootJarClass, layer, moduleName, uri);
        }
        LOGGER.fatal("Failed to find BOOT layer?? (manager={})", (Object)manager);
        return Collections.emptySet();
    }

    static Collection<String> validateServices(Class<?> bootJarClass, ModuleLayer layer, String moduleName, URI uri) {
        LOGGER.info("Validating service classes for module {}", (Object)moduleName);
        Module module = layer.findModule(moduleName).orElse(null);
        Class<?> hacksClass = TILBootLauncherNeoForge.validateHacks(module, moduleName);
        if (Objects.isNull(hacksClass) || Objects.isNull(module)) {
            LOGGER.error("Cannot validate services with null hacks class!");
            return Collections.emptySet();
        }
        LOGGER.info("Successfully validated hacks class");
        TILBootLauncherNeoForge.fixReferenceJar(bootJarClass, module, uri);
        TILBootLauncherNeoForge.printDebugStuff(layer, module);
        HashSet<String> validated = new HashSet<String>();
        ClassLoader loader = module.getClassLoader();
        LOGGER.info("Validating service classes for ClassLoader {}", (Object)loader);
        Class<?> thisClass = TILBootLauncherNeoForge.setClassModule(hacksClass, TILBootLauncherNeoForge.class, module);
        if (Objects.nonNull(thisClass)) {
            validated.add(thisClass.getName());
        }
        for (String service : SERVICES) {
            if (Objects.nonNull(service)) {
                LOGGER.info("Attempting to validate service class {}", (Object)service);
                Class<?> serviceClass = (Class<?>)Hacks.invoke(loader, "findClass", service);
                serviceClass = TILBootLauncherNeoForge.setClassModule(hacksClass, serviceClass, module);
                if (Objects.nonNull(serviceClass)) {
                    validated.add(service);
                    continue;
                }
                LOGGER.error("Failed to find service class {}", (Object)service);
                continue;
            }
            LOGGER.info("Skipping validation for null service class");
        }
        Collection<String> providers = TILBootLauncherNeoForge.validateServiceProviders(layer, module, validated);
        if (providers.isEmpty()) {
            LOGGER.info("All service providers are valid");
        } else {
            LOGGER.info("Updated module for {} service providers {}", (Object)providers.size(), providers);
        }
        return validated;
    }

    @IndirectCallers
    public TILBootLauncherNeoForge() {
        super(true);
        if (DEV) {
            TILBootLauncherNeoForge.consolidateDevModules(DEV_MODULES);
        }
    }

    public EnumSet<ILaunchPluginService.Phase> handlesClass(Type classType, boolean isEmpty) {
        return TILBootLauncherNeoForge.none(ILaunchPluginService.Phase.class);
    }

    static {
        System.out.println("[BOOT] Class init: " + TILBootLauncherNeoForge.class.getName());
        LOGGER = TILRef.createLogger("The Impossible Loader (Boot)");
    }
}

