/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.neoforge.core.bootstrap;

import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import java.util.Objects;
import mods.thecomputerizer.theimpossiblelibrary.api.core.Hacks;
import mods.thecomputerizer.theimpossiblelibrary.api.core.bootstrap.TILForgeLikeServiceLauncher;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ModuleAccess;
import mods.thecomputerizer.theimpossiblelibrary.neoforge.core.NeoForgeCoreLoader;
import mods.thecomputerizer.theimpossiblelibrary.neoforge.core.modules.NeoforgeModuleAccess;
import org.apache.logging.log4j.Logger;

public class TILLauncherNeoForge
extends TILForgeLikeServiceLauncher {
    public static void validateBootClass(Logger logger, String moduleName, String className) {
        logger.debug("Validating that {} can be found in BOOT layer module {}", (Object)className, (Object)moduleName);
        ModuleAccess module = NeoforgeModuleAccess.findModuleInLayer(moduleName, IModuleLayerManager.Layer.BOOT);
        if (Objects.isNull(module)) {
            logger.error("Cannot validate BOOT loaded class with missing module {} (class = {})", (Object)moduleName, (Object)className);
            return;
        }
        TILLauncherNeoForge.validateBootClass(logger, Launcher.class.getClassLoader(), (Module)module.accessAs(), className);
        logger.debug("Finished validation check for {}", (Object)className);
    }

    static void validateBootClass(Logger logger, ClassLoader bootLoader, Module module, String className) {
        try {
            Class c = (Class)Hacks.callOnOtherClassLoader(bootLoader, "invokeDirect", bootLoader, "findClass", new Object[]{"theimpossiblebootstrap", className});
            String moduleName = module.getName();
            if (Objects.nonNull(c)) {
                Hacks.callOnOtherClassLoader(bootLoader, "setFieldDirect", c, "module", module);
                logger.info("Added service class {} to BOOT layer module {}", (Object)className, (Object)moduleName);
            } else {
                logger.error("Failed to find BOOT layer class {} for module {}!", (Object)className, (Object)moduleName);
            }
        }
        catch (Throwable t) {
            System.err.println("Error validating class for BOOT layer " + className);
            t.printStackTrace(System.err);
        }
    }

    public TILLauncherNeoForge(Class<?> caller) {
        super(Launcher.class.getClassLoader(), "Neoforge");
        this.load(caller);
    }

    @Override
    protected String coreLoader() {
        return "mods.thecomputerizer.theimpossiblelibrary.neoforge.core.NeoForgeCoreLoader";
    }

    @Override
    protected Object initCoreAPI() {
        return NeoForgeCoreLoader.initCoreAPI();
    }

    @Override
    protected String modLoading() {
        return "mods.thecomputerizer.theimpossiblelibrary.neoforge.core.loader.NeoForgeModLoading";
    }

    @Override
    protected String moduleName(Class<?> c) {
        return c.getModule().getName();
    }

    @Override
    protected void moveModule(String moduleName) {
        NeoforgeModuleAccess.moveModule(IModuleLayerManager.Layer.SERVICE, IModuleLayerManager.Layer.BOOT, moduleName, true);
        NeoforgeModuleAccess.renameModule(IModuleLayerManager.Layer.BOOT, moduleName, "theimpossiblebootstrap");
    }
}

