/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.neoforge.core.loader;

import cpw.mods.jarhandling.JarContents;
import cpw.mods.jarhandling.JarMetadata;
import cpw.mods.jarhandling.SecureJar;
import cpw.mods.jarhandling.impl.JarSigningData;
import cpw.mods.niofs.union.UnionFileSystem;
import java.nio.file.Path;
import java.security.CodeSigner;
import java.util.Objects;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import mods.thecomputerizer.theimpossiblelibrary.api.core.Hacks;
import mods.thecomputerizer.theimpossiblelibrary.neoforge.core.loader.TILLoaderJarMetadata;
import mods.thecomputerizer.theimpossiblelibrary.neoforge.core.loader.TILLoaderJarModuleDataProvider;
import org.jetbrains.annotations.Nullable;

public class TILLoaderJar
implements SecureJar {
    final JarContents contents;
    final JarMetadata metadata;
    final JarSigningData signingData;
    final Manifest manifest;
    final SecureJar.ModuleDataProvider moduleDataProvider;
    final UnionFileSystem ufs;

    static SecureJar get(JarContents contents, String moduleName) {
        return new TILLoaderJar(contents, moduleName);
    }

    TILLoaderJar(JarContents contents, String moduleName) {
        this.contents = contents;
        this.metadata = TILLoaderJarMetadata.get(moduleName);
        this.signingData = (JarSigningData)Hacks.getFieldDirect(this.contents, "signingData");
        this.manifest = this.contents.getManifest();
        this.moduleDataProvider = TILLoaderJarModuleDataProvider.get(this.contents, this.metadata, this.signingData);
        this.ufs = (UnionFileSystem)Hacks.getFieldDirect(this.contents, "filesystem");
    }

    public SecureJar.Status getFileStatus(String name) {
        return (SecureJar.Status)Hacks.invokeDirect(this.signingData, "getFileStatus", name);
    }

    @Nullable
    public CodeSigner[] getManifestSigners() {
        return (CodeSigner[])Hacks.invokeDirect(this.signingData, "getManifestSigners", new Object[0]);
    }

    public Path getPath(String first, String ... rest) {
        return this.ufs.getPath(first, rest);
    }

    public Path getPrimaryPath() {
        return this.ufs.getPrimaryPath();
    }

    public Path getRootPath() {
        return this.ufs.getPath("", new String[0]);
    }

    @Nullable
    public Attributes getTrustedManifestEntries(String name) {
        return (Attributes)Hacks.invokeDirect(this.signingData, "getTrustedManifestEntries", this.manifest, name);
    }

    public boolean hasSecurityData() {
        Boolean b = (Boolean)Hacks.invokeDirect(this.signingData, "hasSecurityData", new Object[0]);
        return Objects.nonNull(b) && b != false;
    }

    public SecureJar.ModuleDataProvider moduleDataProvider() {
        return this.moduleDataProvider;
    }

    public String name() {
        return this.metadata.name();
    }

    public String toString() {
        return "TILLoaderJar[" + String.valueOf(this.moduleDataProvider.uri()) + "]";
    }

    public SecureJar.Status verifyPath(Path path) {
        if (path.getFileSystem() != this.ufs) {
            throw new IllegalArgumentException("Wrong filesystem");
        }
        String pathname = path.toString();
        return (SecureJar.Status)Hacks.invokeDirect(this.signingData, "verifyPath", this.manifest, path, pathname);
    }
}

